/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.Promotion;
import com.floreantpos.model.dao.PromotionDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.PromotionForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;

public class PromotionExplorer
extends TransparentPanel
implements ExplorerView {
    private BeanTableModel<Promotion> tableModel;
    private JTable table;
    private final int WIDTH = 500;
    private final int HEIGHT = 440;

    public PromotionExplorer() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 5));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Promotions");
        this.tableModel = new BeanTableModel(Promotion.class, 20);
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), Promotion.PROP_NAME);
        this.tableModel.addColumn("AMOUNT BASED", Promotion.PROP_AMOUNT_BASED);
        this.tableModel.addColumn("PERCENTAGE BASED", Promotion.PROP_PERCENTAGE_BASED);
        this.tableModel.addColumn(Promotion.PROP_ACTIVE.toUpperCase(), Promotion.PROP_ACTIVE);
        this.table = new JTable(this.tableModel);
        this.table.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.table.setRowHeight(30);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)this.createButtonPanel(), "South");
    }

    private JPanel createButtonPanel() {
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center"));
        JButton btnAdd = new JButton("ADD");
        JButton btnEdit = new JButton("EDIT");
        JButton btnDelete = new JButton("DELETE");
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PromotionExplorer.this.doAddPromotion();
            }
        });
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PromotionExplorer.this.doEditPromotion();
            }
        });
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ex) {
                PromotionExplorer.this.doDeletePromotion();
            }
        });
        bottomPanel.add(btnAdd);
        bottomPanel.add(btnEdit);
        bottomPanel.add(btnDelete);
        return bottomPanel;
    }

    @Override
    public void initData() {
        List<Promotion> promotions = PromotionDAO.getInstance().findAll();
        this.tableModel.addRows(promotions);
    }

    private void doAddPromotion() {
        try {
            PromotionForm promotionForm = new PromotionForm();
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)promotionForm);
            dialog.openWithScale(500, 440);
            if (dialog.isCanceled()) {
                return;
            }
            this.tableModel.addRow((Promotion)promotionForm.getBean());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doEditPromotion() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Promotion promotion = this.tableModel.getRow(index);
            PromotionForm promotionForm = new PromotionForm(promotion);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)promotionForm);
            dialog.openWithScale(500, 440);
            if (dialog.isCanceled()) {
                return;
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doDeletePromotion() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Are you sure to delete this promotion?", "Delete promotion");
            if (option != 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Promotion promotion = this.tableModel.getRow(index);
            PromotionDAO.getInstance().delete(promotion);
            this.tableModel.removeRow(promotion);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }
}

