/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ModifierPageForm
extends BeanEditor {
    private FixedLengthTextField tfName;
    private IntegerTextField tfSortOrder;
    private IntegerTextField tfNumberOfColumns;
    private IntegerTextField tfNumberOfRows;
    private IntegerTextField tfButtonWidth;
    private IntegerTextField tfButtonHeight;
    private JCheckBox cbFlexibleButtonSize;

    public ModifierPageForm() {
        this(new MenuItemModifierPage());
    }

    public ModifierPageForm(MenuItemModifierPage menuItemModifierPage) {
        this.initComponents();
        this.setBean(menuItemModifierPage);
    }

    private void initComponents() {
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout());
        this.tfName = new FixedLengthTextField();
        this.tfSortOrder = new IntegerTextField(10);
        this.tfNumberOfColumns = new IntegerTextField(10);
        this.tfNumberOfRows = new IntegerTextField(10);
        this.tfButtonWidth = new IntegerTextField(6);
        this.tfButtonHeight = new IntegerTextField(6);
        this.tfNumberOfColumns.setText(Messages.getString("ModifierPageForm.0"));
        this.tfNumberOfRows.setText(Messages.getString("ModifierPageForm.0"));
        contentPanel.add(new JLabel(POSConstants.NAME));
        contentPanel.add((Component)this.tfName, "wrap");
        contentPanel.add(new JLabel(POSConstants.SORT_ORDER));
        contentPanel.add((Component)this.tfSortOrder, "grow,wrap");
        contentPanel.add(new JLabel(Messages.getString("ModifierPageForm.4")));
        contentPanel.add((Component)this.tfNumberOfColumns, "grow,wrap");
        contentPanel.add(new JLabel(Messages.getString("ModifierPageForm.6")));
        contentPanel.add((Component)this.tfNumberOfRows, "grow");
        contentPanel.add((Component)new JLabel(Messages.getString("ModifierPageForm.8")), "newline");
        contentPanel.add((Component)this.tfButtonWidth, "grow");
        contentPanel.add((Component)new JLabel(Messages.getString("ModifierPageForm.11")), "newline");
        contentPanel.add((Component)this.tfButtonHeight, "grow");
        this.cbFlexibleButtonSize = new JCheckBox(Messages.getString("ModifierPageForm.14"));
        contentPanel.add((Component)this.cbFlexibleButtonSize, "skip 1,newline,grow");
        this.add(contentPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuItemModifierPage menuItemModifierPage = (MenuItemModifierPage)this.getBean();
            MenuItemModifierPageDAO dao = new MenuItemModifierPageDAO();
            dao.saveOrUpdate(menuItemModifierPage);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
            return false;
        }
    }

    @Override
    protected void updateView() {
        MenuItemModifierPage menuItemModifierPage = (MenuItemModifierPage)this.getBean();
        if (menuItemModifierPage.getId() == null) {
            return;
        }
        this.tfName.setText(menuItemModifierPage.getName());
        this.tfSortOrder.setText(String.valueOf(menuItemModifierPage.getSortOrder()));
        this.tfNumberOfColumns.setText(String.valueOf(menuItemModifierPage.getCols()));
        this.tfNumberOfRows.setText(String.valueOf(menuItemModifierPage.getRows()));
        this.cbFlexibleButtonSize.setSelected(menuItemModifierPage.isFlixibleButtonSize());
        this.tfButtonWidth.setText(String.valueOf(menuItemModifierPage.getButtonWidth()));
        this.tfButtonHeight.setText(String.valueOf(menuItemModifierPage.getButtonHeight()));
    }

    @Override
    protected boolean updateModel() {
        MenuItemModifierPage menuItemModifierPage = (MenuItemModifierPage)this.getBean();
        String name = this.tfName.getText();
        if (POSUtil.isBlankOrNull(name)) {
            POSMessageDialog.showError(this, POSConstants.NAME_REQUIRED);
            return false;
        }
        int buttonWidth = this.tfButtonWidth.getInteger();
        if (buttonWidth < 30) {
            POSMessageDialog.showError(this, Messages.getString("ModifierPageForm.16"));
            return false;
        }
        int buttonHeight = this.tfButtonHeight.getInteger();
        if (buttonHeight < 30) {
            POSMessageDialog.showError(this, Messages.getString("ModifierPageForm.17"));
            return false;
        }
        menuItemModifierPage.setName(name);
        menuItemModifierPage.setSortOrder(this.tfSortOrder.getInteger());
        menuItemModifierPage.setCols(this.tfNumberOfColumns.getInteger());
        menuItemModifierPage.setRows(this.tfNumberOfRows.getInteger());
        menuItemModifierPage.setFlixibleButtonSize(this.cbFlexibleButtonSize.isSelected());
        menuItemModifierPage.setButtonWidth(buttonWidth);
        menuItemModifierPage.setButtonHeight(buttonHeight);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuItemModifierPage menuItemModifierPage = (MenuItemModifierPage)this.getBean();
        if (menuItemModifierPage.getId() == null) {
            return Messages.getString("ModifierPageForm.18");
        }
        return Messages.getString("ModifierPageForm.19");
    }
}

