/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DatabaseUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutionException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingWorker;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class DatabaseConfigurationDialog
extends POSDialog
implements ActionListener {
    private static final String CREATE_DATABASE = "CD";
    private static final String UPDATE_DATABASE = "UD";
    private static final String SAVE = "SAVE";
    private static final String CANCEL = "cancel";
    private static final String TEST = "test";
    private POSTextField tfServerAddress;
    private POSTextField tfServerPort;
    private POSTextField tfDatabaseName;
    private POSTextField tfUserName;
    private POSPasswordField tfPassword;
    private PosButton btnTestConnection;
    private PosButton btnCreateDb;
    private PosButton btnUpdateDb;
    private PosButton btnExit;
    private PosButton btnSave;
    private JComboBox databaseCombo;
    private TitlePanel titlePanel;
    private JLabel lblServerAddress;
    private JLabel lblServerPort;
    private JLabel lblDbName;
    private JLabel lblUserName;
    private JLabel lblDbPassword;
    private boolean connectionSuccess;

    public DatabaseConfigurationDialog() throws HeadlessException {
        this.setFieldValues();
        this.addUIListeners();
    }

    @Override
    protected void initUI() {
        Database database;
        this.getContentPane().setLayout((LayoutManager)new MigLayout("fill", "[][fill, grow]", ""));
        this.titlePanel = new TitlePanel();
        this.tfServerAddress = new POSTextField();
        this.tfServerPort = new POSTextField();
        this.tfDatabaseName = new POSTextField();
        this.tfUserName = new POSTextField();
        this.tfPassword = new POSPasswordField();
        this.databaseCombo = new JComboBox<Database>(Database.values());
        String databaseProviderName = AppConfig.getDatabaseProviderName();
        if (StringUtils.isNotEmpty((String)databaseProviderName) && (database = Database.getByProviderName(databaseProviderName)) != null) {
            this.databaseCombo.setSelectedItem((Object)database);
        }
        this.getContentPane().add((Component)this.titlePanel, "span, grow, wrap");
        this.getContentPane().add(new JLabel(Messages.getString("DatabaseConfigurationDialog.8")));
        this.getContentPane().add((Component)this.databaseCombo, "grow, wrap");
        this.lblServerAddress = new JLabel(Messages.getString("DatabaseConfigurationDialog.10") + ":");
        this.getContentPane().add(this.lblServerAddress);
        this.getContentPane().add((Component)this.tfServerAddress, "grow, wrap");
        this.lblServerPort = new JLabel(Messages.getString("DatabaseConfigurationDialog.13") + ":");
        this.getContentPane().add(this.lblServerPort);
        this.getContentPane().add((Component)this.tfServerPort, "grow, wrap");
        this.lblDbName = new JLabel(Messages.getString("DatabaseConfigurationDialog.16") + ":");
        this.getContentPane().add(this.lblDbName);
        this.getContentPane().add((Component)this.tfDatabaseName, "grow, wrap");
        this.lblUserName = new JLabel(Messages.getString("DatabaseConfigurationDialog.19") + ":");
        this.getContentPane().add(this.lblUserName);
        this.getContentPane().add((Component)this.tfUserName, "grow, wrap");
        this.lblDbPassword = new JLabel(Messages.getString("DatabaseConfigurationDialog.22") + ":");
        this.getContentPane().add(this.lblDbPassword);
        this.getContentPane().add((Component)this.tfPassword, "grow, wrap");
        this.getContentPane().add((Component)new JSeparator(), "span, grow, gaptop 10");
        this.btnTestConnection = new PosButton(Messages.getString("TestConnection"));
        this.btnTestConnection.setActionCommand(TEST);
        this.btnSave = new PosButton(Messages.getString("DatabaseConfigurationDialog.27"));
        this.btnSave.setActionCommand(SAVE);
        this.btnExit = new PosButton(Messages.getString("Cancel"));
        this.btnExit.setActionCommand(CANCEL);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("inset 0, fill", "grow", ""));
        this.btnCreateDb = new PosButton(Messages.getString("DatabaseConfigurationDialog.29"));
        this.btnCreateDb.setActionCommand(CREATE_DATABASE);
        this.btnUpdateDb = new PosButton(Messages.getString("UPDATE_DATABASE"));
        this.btnUpdateDb.setActionCommand(UPDATE_DATABASE);
        buttonPanel.add(this.btnUpdateDb);
        buttonPanel.add(this.btnCreateDb);
        buttonPanel.add(this.btnTestConnection);
        buttonPanel.add(this.btnSave);
        buttonPanel.add(this.btnExit);
        this.getContentPane().add((Component)buttonPanel, "span, grow");
    }

    private void addUIListeners() {
        this.btnTestConnection.addActionListener(this);
        this.btnCreateDb.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.btnExit.addActionListener(this);
        this.btnUpdateDb.addActionListener(this);
        this.databaseCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Database selectedDb = (Database)((Object)DatabaseConfigurationDialog.this.databaseCombo.getSelectedItem());
                if (selectedDb == Database.DERBY_SINGLE) {
                    DatabaseConfigurationDialog.this.setFieldsVisible(false);
                    return;
                }
                DatabaseConfigurationDialog.this.setFieldsVisible(true);
                String databasePort = AppConfig.getDatabasePort();
                if (StringUtils.isEmpty((String)databasePort)) {
                    databasePort = selectedDb.getDefaultPort();
                }
                DatabaseConfigurationDialog.this.tfServerPort.setText(databasePort);
            }
        });
    }

    private void setFieldValues() {
        Database selectedDb = (Database)((Object)this.databaseCombo.getSelectedItem());
        if (selectedDb == null) {
            selectedDb = Database.DERBY_SINGLE;
        }
        String databaseURL = AppConfig.getDatabaseHost();
        this.tfServerAddress.setText(databaseURL);
        String databasePort = AppConfig.getDatabasePort();
        if (StringUtils.isEmpty((String)databasePort)) {
            databasePort = selectedDb.getDefaultPort();
        }
        this.tfServerPort.setText(databasePort);
        this.tfDatabaseName.setText(AppConfig.getDatabaseName());
        this.tfUserName.setText(AppConfig.getDatabaseUser());
        this.tfPassword.setText(AppConfig.getDatabasePassword());
        if (selectedDb == Database.DERBY_SINGLE) {
            this.setFieldsVisible(false);
        } else {
            this.setFieldsVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block13: {
            try {
                String command = e.getActionCommand();
                if (CANCEL.equalsIgnoreCase(command)) {
                    this.dispose();
                    return;
                }
                DbInfo dbInfo = this.createDbInfo();
                if (TEST.equalsIgnoreCase(command)) {
                    try {
                        DatabaseUtil.checkConnection(dbInfo.connectionString, dbInfo.hibernateDialect, dbInfo.driverClass, dbInfo.user, dbInfo.pass);
                    }
                    catch (DatabaseConnectionException e1) {
                        POSMessageDialog.showError(this, Messages.getString("DatabaseConfigurationDialog.32"));
                        return;
                    }
                    this.connectionSuccess = true;
                    POSMessageDialog.showMessage(this, Messages.getString("DatabaseConfigurationDialog.31"));
                    break block13;
                }
                if (UPDATE_DATABASE.equals(command)) {
                    int i = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseConfigurationDialog.0"), POSConstants.CONFIRM);
                    if (i != 0) {
                        return;
                    }
                    Application.getInstance().setSystemInitialized(false);
                    this.saveConfig(dbInfo);
                    this.doUpdateDb(dbInfo);
                } else if (CREATE_DATABASE.equals(command)) {
                    int i = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseConfigurationDialog.33"));
                    if (i != 0) {
                        return;
                    }
                    Application.getInstance().setSystemInitialized(false);
                    this.saveConfig(dbInfo);
                    i = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("DatabaseConfigurationDialog.4"));
                    boolean generateSampleData = i == 0;
                    this.doCreateDb(dbInfo, generateSampleData);
                } else if (SAVE.equalsIgnoreCase(command)) {
                    Application.getInstance().setSystemInitialized(false);
                    this.saveConfig(dbInfo);
                    Application.getInstance().initializeSystem();
                    this.setCanceled(false);
                    this.dispose();
                }
            }
            catch (Exception e2) {
                POSMessageDialog.showError(this, e2.getMessage(), e2);
            }
        }
    }

    private void doCreateDb(final DbInfo dbInfo, final boolean generateSampleData) {
        final BusyDialog waitDialog = new BusyDialog();
        waitDialog.setTitle("Creating database...");
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                boolean databaseCreated = DatabaseUtil.createDatabase(dbInfo.createDbConnectionString, dbInfo.hibernateDialect, dbInfo.driverClass, dbInfo.user, dbInfo.pass, generateSampleData);
                return databaseCreated;
            }

            @Override
            protected void done() {
                try {
                    Boolean databaseCreated = (Boolean)this.get();
                    waitDialog.dispose();
                    if (databaseCreated.booleanValue()) {
                        String message = String.format(Messages.getString("DatabaseConfigurationDialog.6"), "1111");
                        POSMessageDialog.showMessage(message);
                        ProcessUtil.restart();
                        DatabaseConfigurationDialog.this.connectionSuccess = true;
                    } else {
                        POSMessageDialog.showError(DatabaseConfigurationDialog.this, Messages.getString("DatabaseConfigurationDialog.36"));
                    }
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    POSMessageDialog.showMessage(cause.getMessage());
                }
                catch (Exception e) {
                    POSMessageDialog.showMessage(e.getMessage());
                }
                super.done();
            }
        };
        swingWorker.execute();
        waitDialog.setVisible(true);
    }

    private void doUpdateDb(final DbInfo dbInfo) {
        final BusyDialog waitDialog = new BusyDialog();
        waitDialog.setTitle("Updating database...");
        SwingWorker<Boolean, Void> swingWorker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                boolean databaseUpdated = DatabaseUtil.updateDatabase(dbInfo.connectionString, dbInfo.hibernateDialect, dbInfo.driverClass, dbInfo.user, dbInfo.pass);
                return databaseUpdated;
            }

            @Override
            protected void done() {
                try {
                    Boolean databaseUpdated = (Boolean)this.get();
                    waitDialog.dispose();
                    if (databaseUpdated.booleanValue()) {
                        DatabaseConfigurationDialog.this.connectionSuccess = true;
                        POSMessageDialog.showMessage(DatabaseConfigurationDialog.this, Messages.getString("DatabaseConfigurationDialog.2"));
                    } else {
                        POSMessageDialog.showError(DatabaseConfigurationDialog.this, Messages.getString("DatabaseConfigurationDialog.3"));
                    }
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    POSMessageDialog.showMessage(cause.getMessage());
                }
                catch (Exception e) {
                    POSMessageDialog.showMessage(e.getMessage());
                }
                super.done();
            }
        };
        swingWorker.execute();
        waitDialog.setVisible(true);
    }

    private void saveConfig(DbInfo dbInfo) {
        AppConfig.setDatabaseProviderName(dbInfo.providerName);
        AppConfig.setConnectString(dbInfo.connectionString);
        AppConfig.setDatabaseHost(dbInfo.databaseURL);
        AppConfig.setDatabasePort(dbInfo.databasePort);
        AppConfig.setDatabaseName(dbInfo.databaseName);
        AppConfig.setDatabaseUser(dbInfo.user);
        AppConfig.setDatabasePassword(dbInfo.pass);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(Messages.getString("DatabaseConfigurationDialog.37"));
        this.titlePanel.setTitle(title);
    }

    private void setFieldsVisible(boolean visible) {
        this.lblServerAddress.setVisible(visible);
        this.tfServerAddress.setVisible(visible);
        this.lblServerPort.setVisible(visible);
        this.tfServerPort.setVisible(visible);
        this.lblDbName.setVisible(visible);
        this.tfDatabaseName.setVisible(visible);
        this.lblUserName.setVisible(visible);
        this.tfUserName.setVisible(visible);
        this.lblDbPassword.setVisible(visible);
        this.tfPassword.setVisible(visible);
    }

    public static DatabaseConfigurationDialog show(Frame parent) {
        DatabaseConfigurationDialog dialog = new DatabaseConfigurationDialog();
        dialog.setTitle(Messages.getString("DatabaseConfigurationDialog.38"));
        if (parent != null) {
            dialog.setIconImage(parent.getIconImage());
        }
        dialog.pack();
        dialog.open();
        return dialog;
    }

    private DbInfo createDbInfo() {
        Database selectedDb = (Database)((Object)this.databaseCombo.getSelectedItem());
        DbInfo dbInfo = new DbInfo();
        dbInfo.providerName = selectedDb.getProviderName();
        dbInfo.databaseURL = this.tfServerAddress.getText();
        dbInfo.databasePort = this.tfServerPort.getText();
        dbInfo.databaseName = this.tfDatabaseName.getText();
        dbInfo.user = this.tfUserName.getText();
        dbInfo.pass = new String(this.tfPassword.getPassword());
        dbInfo.connectionString = selectedDb.getConnectString(dbInfo.databaseURL, dbInfo.databasePort, dbInfo.databaseName);
        dbInfo.createDbConnectionString = selectedDb.getCreateDbConnectString(dbInfo.databaseURL, dbInfo.databasePort, dbInfo.databaseName);
        dbInfo.hibernateDialect = selectedDb.getHibernateDialect();
        dbInfo.driverClass = selectedDb.getHibernateConnectionDriverClass();
        return dbInfo;
    }

    private class DbInfo {
        String providerName;
        String databaseURL;
        String databasePort;
        String databaseName;
        String user;
        String pass;
        String connectionString;
        String createDbConnectionString;
        String hibernateDialect;
        String driverClass;

        private DbInfo() {
        }
    }
}

