/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.MultiPrinterPane;
import com.floreantpos.config.ui.PrinterGroupView;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.KitchenStickerPaperSize;
import com.floreantpos.model.ext.PaperSize;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PrintConfigurationView
extends ConfigurationView {
    public static final String AUTO_PRINT_RECEIPT = "auto_print_receipt";
    private JComboBox<PaperSize> cbReportPageSize;
    private JComboBox<KitchenStickerPaperSize> cbKitStickerPageSize;
    private PosPrinters printers;
    private Terminal terminal;
    private JCheckBox cbAutoPrint;

    public PrintConfigurationView() {
        this(Application.getInstance().getTerminal());
    }

    public PrintConfigurationView(Terminal terminal) {
        this.terminal = terminal;
        this.printers = PosPrinters.load(terminal);
        this.initComponents();
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_PRINT;
    }

    @Override
    public void initialize() throws Exception {
        this.cbReportPageSize.setSelectedItem((Object)PaperSize.getDefaultPaperSize());
        String kitchenStickerProperty = this.terminal.getProperty("kitchen.sticker.paper_size");
        if (StringUtils.isNotEmpty((String)kitchenStickerProperty)) {
            KitchenStickerPaperSize kitchenStickerPaperSize = KitchenStickerPaperSize.fromName(kitchenStickerProperty);
            this.cbKitStickerPageSize.setSelectedItem((Object)kitchenStickerPaperSize);
        }
        this.cbAutoPrint.setSelected(this.terminal.isAutoPrintReceipt());
        this.setInitialized(true);
    }

    @Override
    public boolean save() throws Exception {
        TerminalDAO.getInstance().refresh(this.terminal);
        PaperSize selectedPaperSize = (PaperSize)((Object)this.cbReportPageSize.getSelectedItem());
        this.terminal.addProperty("report.paper_size", selectedPaperSize.name());
        KitchenStickerPaperSize kitchenStickerPaperSize = (KitchenStickerPaperSize)((Object)this.cbKitStickerPageSize.getSelectedItem());
        this.terminal.addProperty("kitchen.sticker.paper_size", kitchenStickerPaperSize.name());
        this.terminal.setAutoPrintReceipt(this.cbAutoPrint.isSelected());
        TerminalDAO.getInstance().update(this.terminal);
        return true;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[][grow,fill]", ""));
        JLabel jLabel1 = new JLabel();
        jLabel1.setText(Messages.getString("PrintConfigurationView.8"));
        MultiPrinterPane multiPrinterPane = new MultiPrinterPane(Messages.getString("PrintConfigurationView.1"), this.printers.getKitchenPrinters(), this.terminal);
        contentPanel.add((Component)multiPrinterPane, "cell 0 1 2 1, h 250!, grow");
        PrinterGroupView printerGroupView = new PrinterGroupView(Messages.getString("PrintConfigurationView.13"));
        printerGroupView.setPreferredSize(new Dimension(0, 400));
        contentPanel.add((Component)printerGroupView, "cell 0 2 2 1,grow,h 250!,wrap");
        JLabel lblTest = new JLabel();
        lblTest.setText(Messages.getString("PrintConfigurationView.10"));
        contentPanel.add((Component)lblTest, "cell 0 3, growx");
        this.cbReportPageSize = new JComboBox<PaperSize>(PaperSize.values());
        contentPanel.add(this.cbReportPageSize, "cell 1 3, w 250! ,wrap");
        JLabel lblKitchenStickerPazeSize = new JLabel(Messages.getString("PrintConfigurationView.100"));
        contentPanel.add((Component)lblKitchenStickerPazeSize, "cell 0 4, growx");
        this.cbKitStickerPageSize = new JComboBox<KitchenStickerPaperSize>(KitchenStickerPaperSize.values());
        contentPanel.add(this.cbKitStickerPageSize, "cell 1 4, w 250! ,wrap");
        this.cbAutoPrint = new JCheckBox(Messages.getString("PrintConfigurationView.16"));
        contentPanel.add((Component)this.cbAutoPrint, "cell 0 5,growx");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }
}

