/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Store;
import com.floreantpos.model.TipsReceivedBy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class TipsConfigurationView
extends ConfigurationView {
    private Store store;
    private JRadioButton chkDriver;
    private JRadioButton chkServerForDelivery;
    private JRadioButton chkCashierForDelivery;
    private JRadioButton chkServerForNonDelivery;
    private JRadioButton chkCashierForNonDelivery;

    public TipsConfigurationView(Store store) {
        this.store = store;
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("", "[][]", ""));
        JLabel lblTipsReceivedBy = new JLabel(Messages.getString("TipsConfigurationView.3"));
        JLabel lblDrvrSet = new JLabel(Messages.getString("TipsConfigurationView.4"));
        JLabel lblDrvrNotSet = new JLabel(Messages.getString("TipsConfigurationView.5"));
        ButtonGroup btnGrpDrvrSet = new ButtonGroup();
        this.chkDriver = new JRadioButton(TipsReceivedBy.Driver.name());
        this.chkServerForDelivery = new JRadioButton(TipsReceivedBy.Server.name());
        this.chkCashierForDelivery = new JRadioButton(TipsReceivedBy.Cashier.name());
        btnGrpDrvrSet.add(this.chkDriver);
        btnGrpDrvrSet.add(this.chkServerForDelivery);
        btnGrpDrvrSet.add(this.chkCashierForDelivery);
        ButtonGroup btnGrpDrvrNotSet = new ButtonGroup();
        this.chkServerForNonDelivery = new JRadioButton(TipsReceivedBy.Server.name());
        this.chkCashierForNonDelivery = new JRadioButton(TipsReceivedBy.Cashier.name());
        btnGrpDrvrNotSet.add(this.chkServerForNonDelivery);
        btnGrpDrvrNotSet.add(this.chkCashierForNonDelivery);
        contentPanel.add((Component)lblTipsReceivedBy, "wrap");
        contentPanel.add((Component)lblDrvrSet, "gapleft 20,wrap");
        contentPanel.add((Component)this.chkDriver, "skip 1, wrap");
        contentPanel.add((Component)this.chkServerForDelivery, "skip 1, wrap");
        contentPanel.add((Component)this.chkCashierForDelivery, "skip 1, wrap");
        contentPanel.add((Component)lblDrvrNotSet, "gapleft 20,,wrap");
        contentPanel.add((Component)this.chkServerForNonDelivery, "skip 1, wrap");
        contentPanel.add((Component)this.chkCashierForNonDelivery, "skip 1, wrap");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return true;
        }
        String tipsReceiverForDelivery = null;
        tipsReceiverForDelivery = this.chkDriver.isSelected() ? TipsReceivedBy.Driver.name() : (this.chkCashierForDelivery.isSelected() ? TipsReceivedBy.Cashier.name() : TipsReceivedBy.Server.name());
        this.store.addProperty("tips.receiver.delivery", tipsReceiverForDelivery);
        String tipsReceiverForNonDelivery = null;
        tipsReceiverForNonDelivery = this.chkCashierForNonDelivery.isSelected() ? TipsReceivedBy.Cashier.name() : TipsReceivedBy.Server.name();
        this.store.addProperty("tips.receiver.nonDelivery", tipsReceiverForNonDelivery);
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.setInitialized(true);
        TipsReceivedBy tipsReceiverForDelivery = this.store.getTipsReceivedByForDeliveryOrder();
        if (tipsReceiverForDelivery == TipsReceivedBy.Server) {
            this.chkServerForDelivery.setSelected(true);
        } else if (tipsReceiverForDelivery == TipsReceivedBy.Driver) {
            this.chkDriver.setSelected(true);
        } else if (tipsReceiverForDelivery == TipsReceivedBy.Cashier) {
            this.chkCashierForDelivery.setSelected(true);
        }
        TipsReceivedBy tipsReceiverForNonDelivery = this.store.getTipsReceivedByForNonDeliveryOrder();
        if (tipsReceiverForNonDelivery == TipsReceivedBy.Server) {
            this.chkServerForNonDelivery.setSelected(true);
        } else if (tipsReceiverForNonDelivery == TipsReceivedBy.Cashier) {
            this.chkCashierForNonDelivery.setSelected(true);
        }
    }

    @Override
    public String getName() {
        return Messages.getString("TipsConfigurationView.14");
    }
}

