/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer.clubmember;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.MemberPreferenceAction;
import com.floreantpos.customer.CustomerSelector;
import com.floreantpos.customer.clubmember.ClubMemberSelectionListener;
import com.floreantpos.customer.clubmember.HouseHoldMembersDialog;
import com.floreantpos.customer.clubmember.MemberDetailView;
import com.floreantpos.customer.clubmember.MemberHistoryView;
import com.floreantpos.customer.clubmember.MemberTable;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MemberType;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.ForeteesCustomerDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ColoredCircleRenderer;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.QuickCustomerForm;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.foretees.salesforce.sync.MemberSyncable;
import com.foretees.salesforce.sync.SFConnectionException;
import com.foretees.salesforce.sync.SFException;
import com.foretees.salesforce.sync.SFUtil;
import com.foretees.salesforce.sync.SyncDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class ClubMemberSelectionPane
extends CustomerSelector
implements IView {
    public static final String MEMBER_SELECTION_VIEW = "MEMBER_SELECTION_VIEW";
    private MemberTable memberTable;
    private POSTextField tfSearch;
    private PosButton btnHistory;
    private PosButton btnPrefferences;
    private PosButton btnHouseHoldMembers;
    private PosButton btnCancel;
    private JLabel lblPicture;
    private JLabel memberInfo;
    private JLabel lblMinimubBalance;
    private QwertyKeyPad qwertyKeyPad;
    private ClubMemberSelectionListener clubMemberSelectionListener;
    private TitlePanel titlePanel;
    private PosButton btnCreateNewCustomer;
    private BeanTableModel<Customer> tableModel;
    private PosButton btnNext;
    private PosButton btnPrevious;
    private JLabel lblNumberOfItem;
    private JComboBox cbRectype;

    public ClubMemberSelectionPane(ClubMemberSelectionListener clubMemberSelectionListener) {
        this.clubMemberSelectionListener = clubMemberSelectionListener;
        this.initUI();
        this.updateView(true);
    }

    public void initUI() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(0, 0, 10, 10));
        this.titlePanel = new TitlePanel();
        this.titlePanel.setTitle(Messages.getString("ClubMemberSelectionPane.1"));
        JPanel contentPanel = new JPanel(new BorderLayout(5, 5));
        contentPanel.setBorder(new EmptyBorder(10, 10, 0, 0));
        this.tableModel = new BeanTableModel(Customer.class, 50);
        this.tableModel.addColumn(Messages.getString("ClubMemberSelectionPane.2"), Customer.PROP_MEMBER_TYPE_NAME);
        this.tableModel.addColumn(Messages.getString("ClubMemberSelectionPane.3"), Customer.PROP_MEMBER_ID);
        this.tableModel.addColumn("", "colorPrefs");
        this.tableModel.addColumn(Messages.getString("ClubMemberSelectionPane.4"), "memberShipTypeName");
        this.tableModel.addColumn(Messages.getString("ClubMemberSelectionPane.5"), Customer.PROP_FIRST_NAME);
        this.tableModel.addColumn(Messages.getString("ClubMemberSelectionPane.6"), Customer.PROP_LAST_NAME);
        this.tableModel.addColumn(Messages.getString("ClubMemberSelectionPane.7"), Customer.PROP_EMAIL);
        this.tableModel.addColumn(Messages.getString("ClubMemberSelectionPane.8"), Customer.PROP_TAX_EXEMPT);
        this.tableModel.addColumn(Messages.getString("ClubMemberSelectionPane.9"), Customer.PROP_ACTIVE);
        this.tableModel.addColumn(Messages.getString("ClubMemberSelectionPane.10"), Customer.PROP_RESTRICTED_FROM_P_O_S);
        this.memberTable = new MemberTable();
        this.lblPicture = new JLabel("");
        this.memberInfo = new JLabel("");
        this.memberInfo.setFont(this.memberInfo.getFont().deriveFont(14.0f));
        this.lblMinimubBalance = new JLabel("");
        this.lblMinimubBalance.setFont(this.lblMinimubBalance.getFont().deriveFont(14.0f));
        this.btnHouseHoldMembers = new PosButton(Messages.getString("ClubMemberSelectionPane.11"));
        this.btnPrefferences = new PosButton(Messages.getString("ClubMemberSelectionPane.12"));
        this.btnHistory = new PosButton(Messages.getString("ClubMemberSelectionPane.13"));
        JPanel searchPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[][][grow][][]"));
        Dimension searchButtonSize = PosUIManager.getSize(100, 45);
        this.tfSearch = new POSTextField(16);
        this.tfSearch.setFocusCycleRoot(true);
        this.tfSearch.setFont(new Font("Tahoma", 0, 20));
        this.tfSearch.addActionListener(e -> {
            this.tableModel.setCurrentRowIndex(0);
            this.doSearchMember();
        });
        this.tfSearch.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String txtSearch = ClubMemberSelectionPane.this.tfSearch.getText();
                if (StringUtils.isNotEmpty((String)txtSearch) && txtSearch.length() > 2) {
                    ClubMemberSelectionPane.this.tableModel.setCurrentRowIndex(0);
                    ClubMemberSelectionPane.this.doSearchMember();
                }
            }

            @Override
            public void keyPressed(KeyEvent me) {
                if (me.getKeyCode() == 10) {
                    ClubMemberSelectionPane.this.tableModel.setCurrentRowIndex(0);
                    ClubMemberSelectionPane.this.doSearchMember();
                }
            }
        });
        PosSmallButton btnSearch = new PosSmallButton(Messages.getString("CustomerSelectionDialog.15"));
        btnSearch.setFocusable(false);
        btnSearch.addActionListener(e -> {
            this.tableModel.setCurrentRowIndex(0);
            this.doSearchMember();
        });
        PosButton btnKeyboard = new PosButton(IconFactory.getIcon("/images/", "keyboard.png"));
        btnKeyboard.addActionListener(e -> this.qwertyKeyPad.setCollapsed(!this.qwertyKeyPad.isCollapsed()));
        this.cbRectype = new JComboBox();
        this.cbRectype.setFocusable(false);
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement(Messages.getString("ClubMemberSelectionPane.14"));
        comboBoxModel.addElement((Object)MemberType.MEMBER);
        comboBoxModel.addElement((Object)MemberType.GUEST);
        comboBoxModel.addElement((Object)MemberType.RECIPROCAL_CLUB);
        comboBoxModel.addElement((Object)MemberType.EMPLOYEE);
        comboBoxModel.addElement((Object)MemberType.NON_MEMBER);
        this.cbRectype.setModel(comboBoxModel);
        ((JLabel)((Object)this.cbRectype.getRenderer())).setHorizontalAlignment(0);
        btnKeyboard.setPreferredSize(searchButtonSize);
        btnSearch.setPreferredSize(searchButtonSize);
        searchPanel.add((Component)new JLabel(Messages.getString("ClubMemberSelectionPane.15")), "");
        searchPanel.add((Component)this.cbRectype, "grow");
        searchPanel.add((Component)this.tfSearch, "grow");
        searchPanel.add((Component)btnKeyboard, "growy");
        searchPanel.add((Component)btnSearch, "growy");
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        this.memberTable.setModel(this.tableModel);
        this.memberTable.setFocusable(false);
        this.memberTable.setRowHeight(50);
        this.memberTable.getTableHeader().setPreferredSize(new Dimension(0, 30));
        this.memberTable.getSelectionModel().setSelectionMode(0);
        this.memberTable.getColumn(2).setCellRenderer(new ColoredCircleRenderer());
        this.memberTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    ClubMemberSelectionPane.this.doSelectMember();
                } else {
                    ClubMemberSelectionPane.this.memberSelected();
                }
            }
        });
        JPanel midPane = new JPanel(new BorderLayout(5, 5));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(50, 50));
        scrollPane.setFocusable(false);
        scrollPane.setViewportView((Component)((Object)this.memberTable));
        JPanel customerListPanel = new JPanel(new BorderLayout(5, 5));
        midPane.add((Component)searchPanel, "North");
        midPane.add((Component)scrollPane, "Center");
        this.qwertyKeyPad = new QwertyKeyPad();
        this.qwertyKeyPad.setCollapsed(false);
        this.qwertyKeyPad.setPreferredSize(new Dimension(200, 280));
        midPane.add((Component)((Object)this.qwertyKeyPad), "South");
        customerListPanel.add(midPane);
        JPanel centerRightPanel = new JPanel();
        centerRightPanel.setLayout((LayoutManager)new MigLayout("wrap 1, ins 0 5 1 0, fill", "fill", "fill"));
        centerRightPanel.setPreferredSize(new Dimension(230, 0));
        JPanel picturePanel = new JPanel((LayoutManager)new MigLayout("wrap 1, ins 0, fill", "fill", "fill"));
        picturePanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.lblPicture.setHorizontalAlignment(0);
        this.memberInfo.setHorizontalAlignment(0);
        this.lblMinimubBalance.setHorizontalAlignment(0);
        picturePanel.add(this.lblPicture);
        picturePanel.add(this.memberInfo);
        picturePanel.add(this.lblMinimubBalance);
        centerRightPanel.add(picturePanel);
        centerRightPanel.add(this.btnPrefferences);
        centerRightPanel.add(this.btnHistory);
        centerRightPanel.add(this.btnHouseHoldMembers);
        customerListPanel.add((Component)centerRightPanel, "East");
        centerPanel.add((Component)customerListPanel, "Center");
        this.btnHistory.addActionListener(e -> {
            if (!this.checkSelectedMember()) {
                return;
            }
            this.openMemberHistory();
        });
        this.btnPrefferences.addActionListener(ev -> this.doOpenPrefferences());
        this.btnHouseHoldMembers.addActionListener(e -> this.doSelectHouseHoldMember());
        this.btnHouseHoldMembers.setEnabled(false);
        contentPanel.add((Component)centerPanel, "Center");
        this.add(contentPanel);
        PosButton btnSelect = new PosButton(POSConstants.SELECT.toUpperCase());
        PosButton btnDetail = new PosButton(Messages.getString("ClubMemberSelectionDialog.49"));
        this.btnCancel = new PosButton(POSConstants.CANCEL.toUpperCase());
        btnSelect.addActionListener(e -> this.doSelectMember());
        btnDetail.addActionListener(e -> this.showMemberDetail());
        this.btnCancel.addActionListener(e -> {
            if (this.clubMemberSelectionListener != null) {
                this.clubMemberSelectionListener.memberSelectionCanceled();
            }
            this.tfSearch.setText("");
            this.closeDialog(true);
        });
        this.btnNext = new PosButton(POSConstants.CAPITAL_NEXT);
        this.btnPrevious = new PosButton(Messages.getString("ClubMemberSelectionPane.16"));
        this.btnNext.addActionListener(e -> {
            this.tableModel.setCurrentRowIndex(this.tableModel.getNextRowIndex());
            this.doSearchMember();
            this.setItemNumberText();
            this.btnPrevious.setEnabled(this.tableModel.hasPrevious());
            this.btnNext.setEnabled(this.tableModel.hasNext());
        });
        this.btnPrevious.addActionListener(e -> {
            this.tableModel.setCurrentRowIndex(this.tableModel.getPreviousRowIndex());
            this.doSearchMember();
            this.setItemNumberText();
            this.btnPrevious.setEnabled(this.tableModel.hasPrevious());
            this.btnNext.setEnabled(this.tableModel.hasNext());
        });
        this.lblNumberOfItem = new JLabel();
        PosButton btnSyncMember = new PosButton(Messages.getString("ClubMemberSelectionPane.17"));
        btnSyncMember.setPreferredSize(new Dimension(224, 0));
        btnSyncMember.addActionListener(e -> {
            this.doSyncCustomer();
            this.tableModel.setCurrentRowIndex(0);
            this.doSearchMember();
        });
        JPanel leftPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 0 0 0 10", "", ""));
        this.btnCreateNewCustomer = new PosButton(Messages.getString("CustomerSelectionDialog.25"));
        this.btnCreateNewCustomer.setFocusable(false);
        this.btnCreateNewCustomer.addActionListener(e -> this.doCreateNewCustomer());
        leftPanel.add((Component)this.btnCreateNewCustomer, "align right, split 4");
        leftPanel.add((Component)btnSelect, "");
        leftPanel.add((Component)btnDetail, "");
        leftPanel.add((Component)this.btnCancel, "");
        leftPanel.add((Component)this.lblNumberOfItem, "gapleft 20, align right,split 3");
        leftPanel.add((Component)this.btnPrevious, "w 100!");
        leftPanel.add((Component)this.btnNext, "w 100!");
        JPanel rightPanel = new JPanel((LayoutManager)new MigLayout("insets 0 0 0 0,fill", "grow,sg,fill", ""));
        rightPanel.add((Component)btnSyncMember, "grow");
        JPanel footerPanel = new JPanel(new BorderLayout());
        footerPanel.add((Component)leftPanel, "Center");
        footerPanel.add((Component)rightPanel, "East");
        this.add((Component)footerPanel, "South");
        this.setDefaultMemberPicture();
        this.setItemNumberText();
        this.btnPrevious.setEnabled(this.tableModel.hasPrevious());
        this.btnNext.setEnabled(this.tableModel.hasNext());
        this.resizeColumnWidth((JTable)((Object)this.memberTable));
    }

    private void doOpenPrefferences() {
        try {
            if (!this.checkSelectedMember()) {
                return;
            }
            Customer member = this.getSelectedMember();
            MemberPreferenceAction preferenceAction = new MemberPreferenceAction(member);
            preferenceAction.execute();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doSelectHouseHoldMember() {
        if (!this.checkSelectedMember()) {
            return;
        }
        try {
            JSONObject fullMember = SFUtil.getMemberById(this.memberTable.getSelectedMember().getId(), 1);
            Object obj = fullMember.get("AccountId");
            if (obj.equals(null)) {
                POSMessageDialog.showMessage(Messages.getString("ClubMemberSelectionPane.18"));
                return;
            }
            HouseHoldMembersDialog dialog = new HouseHoldMembersDialog(fullMember.get("AccountId").toString());
            dialog.setSize(Application.getPosWindow().getSize());
            dialog.open();
        }
        catch (SFConnectionException e1) {
            e1.printStackTrace();
        }
        catch (SFException e1) {
            e1.printStackTrace();
        }
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        int columnCount = table.getColumnCount();
        for (int column = 0; column < columnCount; ++column) {
            columnModel.getColumn(column).setPreferredWidth(this.getColumnWidth().get(column));
        }
    }

    private List<Integer> getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(40);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(200);
        columnWidth.add(200);
        columnWidth.add(100);
        columnWidth.add(10);
        columnWidth.add(10);
        columnWidth.add(10);
        columnWidth.add(10);
        return columnWidth;
    }

    private void setItemNumberText() {
        int totalNumber;
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.tableModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format("Showing %s to %s of %s", startNumber, endNumber, totalNumber));
    }

    private void closeDialog(boolean canceled) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof POSDialog) {
            ((POSDialog)windowAncestor).setCanceled(canceled);
            windowAncestor.dispose();
        }
    }

    protected void doCreateNewCustomer() {
        boolean setKeyPad = true;
        QuickCustomerForm form = new QuickCustomerForm(setKeyPad);
        form.enableCustomerFields(true);
        BeanEditorDialog dialog = new BeanEditorDialog(form);
        dialog.setResizable(false);
        dialog.open();
        if (!dialog.isCanceled()) {
            Customer selectedCustomer = (Customer)form.getBean();
            BeanTableModel model = (BeanTableModel)this.memberTable.getModel();
            model.addRow(selectedCustomer);
        }
    }

    private boolean checkSelectedMember() {
        String message;
        int option;
        Customer selectedMember = this.getSelectedMember();
        if (selectedMember == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ClubMemberSelectionPane.19"));
            return false;
        }
        if (!selectedMember.isActive().booleanValue() && (option = POSMessageDialog.showYesNoQuestionDialog(this, message = Messages.getString("ClubMemberSelectionPane.20"), POSConstants.CONFIRM)) != 0) {
            return false;
        }
        return selectedMember.isRestrictedFromPOS() == false || (option = POSMessageDialog.showYesNoQuestionDialog(this, message = Messages.getString("ClubMemberSelectionPane.21"), POSConstants.CONFIRM)) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMemberHistory() {
        try {
            Customer selectedMember = this.memberTable.getSelectedMember();
            if (DataProvider.get().getTicketToBeCreated() == null) {
                Ticket ticket = new Ticket(true);
                ticket.setOrderType(this.orderType);
                ticket.setCustomer(selectedMember);
                DataProvider.get().setTicketToBeCreated(ticket);
            }
            MemberHistoryView historyView = new MemberHistoryView(selectedMember.getId());
            POSDialog posDialog = new POSDialog();
            posDialog.setTitle(Messages.getString("ClubMemberSelectionPane.22"));
            posDialog.getContentPane().add(historyView);
            posDialog.openFullScreen();
            if (historyView.isTicketReordered()) {
                this.closeDialog(true);
            }
        }
        finally {
            DataProvider.get().setTicketToBeCreated(null);
        }
    }

    private void setDefaultMemberPicture() {
        this.lblPicture.setIcon(IconFactory.getIcon("/images/", "generic-profile-pic-v2.png"));
    }

    private void setMemberPicture() {
        this.lblPicture.setIcon(null);
        Customer member = this.memberTable.getSelectedMember();
        if (member.getImageId() != null) {
            ImageResource imageResource = ImageResourceDAO.getInstance().findById(member.getImageId());
            if (imageResource != null) {
                this.lblPicture.setIcon(imageResource.getScaledImage(210, 260));
            } else {
                this.lblPicture.setIcon(IconFactory.getIcon("/images/", "generic-profile-pic-v2.png"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSearchMember() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String name = this.tfSearch.getText();
            Object memberTypeObj = this.cbRectype.getSelectedItem();
            MemberType memberType = null;
            if (memberTypeObj instanceof MemberType) {
                memberType = (MemberType)((Object)memberTypeObj);
            }
            Store store = DataProvider.get().getStore();
            boolean hideInactiveMembers = store.getBooleanProperty("hideRestrictedMembers", false);
            ForeteesCustomerDAO.getInstance().findCustomer(name, memberType, this.tableModel, hideInactiveMembers, new String[0]);
            this.setItemNumberText();
            this.btnPrevious.setEnabled(this.tableModel.hasPrevious());
            this.btnNext.setEnabled(this.tableModel.hasNext());
            this.qwertyKeyPad.setCollapsed(true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public Customer getSelectedMember() {
        return this.memberTable.getSelectedMember();
    }

    private void doSyncCustomer() {
        try {
            MemberSyncable memberSyncable = new MemberSyncable();
            SyncDialog memberSyncDialog = new SyncDialog(memberSyncable);
            memberSyncable.setSyncView(memberSyncDialog);
            memberSyncDialog.pack();
            memberSyncDialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public void setCancelButtonVisible(boolean visible) {
        this.btnCancel.setVisible(visible);
        this.titlePanel.setVisible(visible);
    }

    protected void reset() {
        this.tfSearch.setText("");
        BeanTableModel model = (BeanTableModel)this.memberTable.getModel();
        model.setRows(new ArrayList());
    }

    private void memberSelected() {
        Customer selectedMember = this.memberTable.getSelectedMember();
        if (selectedMember != null) {
            this.setMemberPicture();
            selectedMember = CustomerDAO.getInstance().findById(selectedMember.getId());
            String memberBalance = NumberUtil.formatNumberAcceptNegative(selectedMember.getBalance());
            if (StringUtils.isEmpty((String)memberBalance)) {
                memberBalance = "0.0";
            }
            this.lblMinimubBalance.setText("<html><center>Current balance: " + CurrencyUtil.getCurrencySymbol() + memberBalance + "<br></center><html>");
            String memberId = selectedMember.getMemberId() != null ? selectedMember.getMemberId() : "";
            String firstName = selectedMember.getFirstName() != null ? selectedMember.getFirstName() : "";
            String lastName = selectedMember.getLastName() != null ? selectedMember.getLastName() : "";
            this.memberInfo.setText("<html> <center> <h3> " + firstName + " " + lastName + "</h3>" + memberId + "</center></html>");
        } else {
            this.setDefaultMemberPicture();
            this.lblMinimubBalance.setText("");
            this.memberInfo.setText("");
        }
    }

    @Override
    public void redererCustomers() {
        String customerId;
        this.memberTable.clearSelection();
        if (this.ticket != null && StringUtils.isNotEmpty((String)(customerId = this.ticket.getCustomerId()))) {
            BeanTableModel model = (BeanTableModel)this.memberTable.getModel();
            boolean existsCustomer = false;
            List rows = model.getRows();
            if (rows != null) {
                for (int i = 0; i < rows.size(); ++i) {
                    Customer member = (Customer)rows.get(i);
                    if (!member.getId().equals(customerId)) continue;
                    existsCustomer = true;
                    this.memberTable.getSelectionModel().addSelectionInterval(i, i);
                    break;
                }
            }
            if (!existsCustomer) {
                ArrayList<Customer> customers = new ArrayList<Customer>();
                Customer addedCustomer = this.ticket.getCustomer();
                if (addedCustomer != null) {
                    customers.add(addedCustomer);
                    if (rows != null) {
                        customers.addAll(rows);
                    }
                    model.removeAll();
                    model.setRows(customers);
                    this.memberTable.repaint();
                    this.memberTable.getSelectionModel().addSelectionInterval(0, 0);
                }
            }
        }
        this.updateView(true);
    }

    public void setFocus() {
        this.tfSearch.requestFocus();
    }

    @Override
    public Customer getSelectedCustomer() {
        return this.getCustomer();
    }

    @Override
    public void updateView(boolean update) {
        Store store = Application.getInstance().getStore();
        this.btnCreateNewCustomer.setVisible(store.hasCreateMemberPermission());
        this.tableModel.setCurrentRowIndex(0);
        this.doSearchMember();
    }

    public void clearSelection() {
        this.tfSearch.setText("");
        this.tableModel.removeAll();
        this.updateView(true);
    }

    @Override
    public String getViewName() {
        return MEMBER_SELECTION_VIEW;
    }

    @Override
    public Component getViewComponent() {
        return this;
    }

    @Override
    public void refresh() {
    }

    @Override
    public DataChangeListener getDataChangeListener() {
        return null;
    }

    private void doSelectMember() {
        try {
            if (!this.checkSelectedMember()) {
                return;
            }
            this.setCustomer(this.getSelectedMember());
            if (this.clubMemberSelectionListener != null) {
                this.clubMemberSelectionListener.clubMemberSelected(this.getSelectedMember());
            }
            this.tfSearch.setText("");
            this.closeDialog(false);
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage());
        }
    }

    private void showMemberDetail() {
        try {
            if (!this.checkSelectedMember()) {
                return;
            }
            MemberDetailView dialog = new MemberDetailView(this.memberTable.getSelectedMember());
            dialog.setSize(Application.getPosWindow().getSize());
            dialog.open();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage());
        }
    }
}

