/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer.clubmember;

import com.floreantpos.customer.clubmember.HouseHoldListTableModel;
import com.floreantpos.customer.clubmember.MemberDetailView;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.foretees.salesforce.sync.SFConnectionException;
import com.foretees.salesforce.sync.SFException;
import com.foretees.salesforce.sync.SFUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.json.JSONArray;
import org.json.JSONObject;

public class HouseHoldMembersDialog
extends POSDialog {
    private static Log logger = LogFactory.getLog(HouseHoldMembersDialog.class);
    private JXTable table;
    private HouseHoldListTableModel tableModel;
    private Customer selectedMember;

    public HouseHoldMembersDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle("Member");
        this.initComponents();
    }

    public HouseHoldMembersDialog(String accountId) {
        this.setTitle("Member ");
        this.initComponents();
        this.setMembers(accountId);
    }

    protected void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("ins 30 30 0 30", "[549px,grow]", "[grow][][shrink 0,fill][grow][grow]"));
        this.tableModel = new HouseHoldListTableModel();
        this.table = new JXTable();
        this.table.setModel((TableModel)this.tableModel);
        this.table.setFocusable(false);
        this.table.setRowHeight(60);
        this.table.setColumnControlVisible(true);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(60, 60));
        scrollPane.setFocusable(false);
        scrollPane.setViewportView((Component)this.table);
        JPanel centerPanel = new JPanel(new BorderLayout(0, 0));
        centerPanel.add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)centerPanel, "cell 0 1,grow, gapright 2px");
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("al center center,insets 0", "sg,fill", ""));
        PosButton btnSelect = new PosButton("SELECT");
        PosButton btnDetail = new PosButton("DETAIL");
        PosButton btnClose = new PosButton("CLOSE");
        btnSelect.setPreferredSize(new Dimension(100, 0));
        footerPanel.add((Component)btnSelect, "grow");
        footerPanel.add((Component)btnDetail, "grow");
        footerPanel.add((Component)btnClose, "grow");
        btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!HouseHoldMembersDialog.this.checkSelectedMember()) {
                    return;
                }
                CustomerDAO.getInstance().saveOrUpdate(HouseHoldMembersDialog.this.selectedMember);
                HouseHoldMembersDialog.this.setCanceled(false);
                HouseHoldMembersDialog.this.dispose();
            }
        });
        btnDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!HouseHoldMembersDialog.this.checkSelectedMember()) {
                    return;
                }
                MemberDetailView dialog = new MemberDetailView(HouseHoldMembersDialog.this.selectedMember);
                dialog.setSize(Application.getPosWindow().getSize());
                dialog.open();
            }
        });
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HouseHoldMembersDialog.this.setCanceled(true);
                HouseHoldMembersDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)footerPanel, "cell 0 2,grow, gapright 2px");
    }

    private boolean checkSelectedMember() {
        if (this.selectedMember == null) {
            POSMessageDialog.showMessage("Please select a member first");
            return false;
        }
        return true;
    }

    private void setMembers(String accountId) {
        ArrayList<JSONObject> memberRecords = new ArrayList<JSONObject>();
        try {
            JSONArray houseHoldMembers = SFUtil.getHouseHoldMember(accountId, 1);
            if (houseHoldMembers != null) {
                for (int i = 0; i < houseHoldMembers.length(); ++i) {
                    JSONObject obj = (JSONObject)houseHoldMembers.get(i);
                    memberRecords.add(obj);
                }
            }
        }
        catch (SFConnectionException e) {
            logger.error((Object)e);
        }
        catch (SFException e) {
            logger.error((Object)e);
        }
        this.tableModel.setRows(memberRecords);
    }
}

