/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer.clubmember;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.foretees.salesforce.sync.SFConnectionException;
import com.foretees.salesforce.sync.SFException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.json.JSONObject;

public class MemberDetailView
extends POSDialog {
    public static final String VIEW_NAME = "MEMBER_DETAIL_VIEW";
    private static final SimpleDateFormat SFDCDATETIMEFORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private static SimpleDateFormat altDateTimeFormat = new SimpleDateFormat("M/d/yyyy h:mma EEEE");
    private Ticket ticket;
    private JSONObject member;
    public Integer reservationIndex;
    private Customer clubMember;
    private static MemberDetailView instance;
    private JTabbedPane tabbedPane;
    private JButton btnOpenTicket;
    private JPanel panelReservation;
    private JPanel panelClasses;
    private JPanel panelLessons;
    private JPanel panelSubscriptions;
    private JPanel jPanel5;
    private JPanel panelStorage;
    private JPanel jPanel7;
    private JPanel headerPanel;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane8;
    private JLabel lblMemName;
    private JLabel lblMemNum;
    private JLabel lblMemberStatus;
    private JTable tableClasses;
    private JTable tableLessons;
    private JTable tableReservations;
    private JTable tableStorages;
    private JTable tableSubscriptions;
    private List<JSONObject> reservations;
    private ReservationListModel reservationListModel;
    private List<JSONObject> lessons;
    private LessonListModel lessonListModel;
    private List<JSONObject> classes;
    private ClassListModel classListModel;
    private List<JSONObject> subscriptions;
    private SubscriptionListModel subscriptionListModel;
    private List<JSONObject> storages;
    private StorageListModel storagesListModel;

    public MemberDetailView() {
        this.initComponents();
        this.reservationListModel = new ReservationListModel();
        this.tableReservations.setModel(this.reservationListModel);
        this.lessonListModel = new LessonListModel();
        this.tableLessons.setModel(this.lessonListModel);
        this.classListModel = new ClassListModel();
        this.tableClasses.setModel(this.classListModel);
        this.subscriptionListModel = new SubscriptionListModel();
        this.tableSubscriptions.setModel(this.subscriptionListModel);
        this.storagesListModel = new StorageListModel();
        this.tableStorages.setModel(this.storagesListModel);
    }

    public MemberDetailView(Customer clubMember) {
        this.clubMember = clubMember;
        this.initComponents();
        this.reservationListModel = new ReservationListModel();
        this.tableReservations.setModel(this.reservationListModel);
        this.lessonListModel = new LessonListModel();
        this.tableLessons.setModel(this.lessonListModel);
        this.classListModel = new ClassListModel();
        this.tableClasses.setModel(this.classListModel);
        this.subscriptionListModel = new SubscriptionListModel();
        this.tableSubscriptions.setModel(this.subscriptionListModel);
        this.storagesListModel = new StorageListModel();
        this.tableStorages.setModel(this.storagesListModel);
        try {
            this.doSearch();
        }
        catch (SFConnectionException e) {
            e.printStackTrace();
        }
        catch (SFException e) {
            e.printStackTrace();
        }
    }

    private void clearSelections() {
        if (!this.tableReservations.hasFocus()) {
            this.tableReservations.clearSelection();
        }
        if (!this.tableLessons.hasFocus()) {
            this.tableLessons.clearSelection();
        }
        if (!this.tableClasses.hasFocus()) {
            this.tableClasses.clearSelection();
        }
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public void doSearch() throws SFConnectionException, SFException {
    }

    public static synchronized MemberDetailView getInstance() {
        if (instance == null) {
            instance = new MemberDetailView();
        }
        return instance;
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.jPanel5 = new JPanel();
        this.btnOpenTicket = new JButton();
        this.jPanel7 = new JPanel();
        this.panelReservation = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.tableReservations = new JTable();
        this.panelSubscriptions = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.tableSubscriptions = new JTable();
        this.panelLessons = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.tableLessons = new JTable();
        this.panelStorage = new JPanel();
        this.jScrollPane8 = new JScrollPane();
        this.tableStorages = new JTable();
        this.panelClasses = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.tableClasses = new JTable();
        this.headerPanel = new JPanel();
        this.lblMemName = new JLabel();
        this.lblMemberStatus = new JLabel();
        this.lblMemNum = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanel7.setPreferredSize(new Dimension(15000, 15000));
        this.jPanel7.setLayout(new GridLayout(3, 2));
        this.panelReservation.setBorder(BorderFactory.createTitledBorder(null, "Sports", 2, 0));
        this.tableReservations.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.tableReservations.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MemberDetailView.this.tableReservationsFocusGained(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.tableReservations);
        GroupLayout jPanel1Layout = new GroupLayout(this.panelReservation);
        this.panelReservation.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -1, 641, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -2, 0, Short.MAX_VALUE));
        this.jPanel7.add(this.panelReservation);
        this.panelSubscriptions.setBorder(BorderFactory.createTitledBorder(null, "Subscriptions", 2, 0));
        this.tableSubscriptions.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jScrollPane6.setViewportView(this.tableSubscriptions);
        GroupLayout jPanel4Layout = new GroupLayout(this.panelSubscriptions);
        this.panelSubscriptions.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane6, -1, 641, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane6, -1, 115, Short.MAX_VALUE));
        this.jPanel7.add(this.panelSubscriptions);
        this.panelLessons.setBorder(BorderFactory.createTitledBorder(null, "Lessons", 2, 0));
        this.tableLessons.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.tableLessons.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MemberDetailView.this.tableLessonsFocusGained(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.tableLessons);
        GroupLayout jPanel3Layout = new GroupLayout(this.panelLessons);
        this.panelLessons.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 641, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 115, Short.MAX_VALUE));
        this.jPanel7.add(this.panelLessons);
        this.panelStorage.setBorder(BorderFactory.createTitledBorder(null, "Storage", 2, 0));
        this.tableStorages.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jScrollPane8.setViewportView(this.tableStorages);
        GroupLayout jPanel6Layout = new GroupLayout(this.panelStorage);
        this.panelStorage.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane8, -1, 641, Short.MAX_VALUE));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane8, -1, 115, Short.MAX_VALUE));
        this.jPanel7.add(this.panelStorage);
        this.panelClasses.setBorder(BorderFactory.createTitledBorder(null, "Classes", 2, 0));
        this.tableClasses.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.tableClasses.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MemberDetailView.this.tableClassesFocusGained(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.tableClasses);
        GroupLayout jPanel2Layout = new GroupLayout(this.panelClasses);
        this.panelClasses.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -1, 641, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -1, 115, Short.MAX_VALUE));
        this.jPanel7.add(this.panelClasses);
        this.headerPanel.setPreferredSize(new Dimension(1306, 50));
        this.headerPanel.setLayout(new GridLayout(2, 2));
        this.lblMemName.setText("Member Name");
        this.headerPanel.add(this.lblMemName);
        this.lblMemberStatus.setText("Member Status");
        this.headerPanel.add(this.lblMemberStatus);
        this.lblMemNum.setText("Member Id");
        this.headerPanel.add(this.lblMemNum);
        this.tabbedPane.addTab("RESERVATION", this.panelReservation);
        this.tabbedPane.addTab("SUBSCRIPTIONS", this.panelSubscriptions);
        this.tabbedPane.addTab("LESSONS", this.panelLessons);
        this.tabbedPane.addTab("STORAGE", this.panelStorage);
        this.tabbedPane.addTab("CLASSES", this.panelClasses);
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.headerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel mainPanel = new JPanel(new BorderLayout());
        TitledBorder centerBorder = BorderFactory.createTitledBorder("Member Info");
        centerBorder.setTitleJustification(2);
        mainPanel.setBorder(centerBorder);
        mainPanel.add((Component)this.headerPanel, "North");
        mainPanel.add((Component)this.tabbedPane, "Center");
        this.add((Component)mainPanel, "Center");
    }

    private void btnOpenTicketActionPerformed(ActionEvent evt) {
        this.openTicket();
    }

    private void btnSelectReservationActionPerformed(ActionEvent evt) {
        this.openTicket();
    }

    private void tableClassesFocusGained(FocusEvent evt) {
        this.clearSelections();
    }

    private void tableReservationsFocusGained(FocusEvent evt) {
        this.clearSelections();
    }

    private void tableLessonsFocusGained(FocusEvent evt) {
        this.clearSelections();
    }

    private void openTicket() {
        OrderView.getInstance().setCurrentTicket(this.ticket);
        if (this.reservationIndex != null) {
            OrderView.getInstance().getTicketView().selectRow(this.reservationIndex);
        }
        RootView.getInstance().showView("ORDER_VIEW");
    }

    private JSONObject getSelectedReservation() {
        int row = this.tableReservations.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.reservations.get(row);
    }

    private JSONObject getSelectedLesson() {
        int row = this.tableLessons.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.lessons.get(row);
    }

    private JSONObject getSelectedClass() {
        int row = this.tableClasses.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.classes.get(row);
    }

    public static String formatSFDCDateTime(String str) {
        try {
            Date dateTime = SFDCDATETIMEFORMAT.parse(str);
            return altDateTimeFormat.format(dateTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatSFDCDate(String str) {
        try {
            Date dateTime = SFDCDATETIMEFORMAT.parse(str);
            return altDateTimeFormat.format(dateTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    class StorageListModel
    extends AbstractTableModel {
        String[] cn = new String[]{"Number", "Type", "Start Date", "End Date"};

        StorageListModel() {
        }

        public JSONObject get(int index) {
            return (JSONObject)MemberDetailView.this.storages.get(index);
        }

        public void add(JSONObject object) {
            if (MemberDetailView.this.storages == null) {
                MemberDetailView.this.storages = new ArrayList();
            }
            Boolean found = false;
            for (JSONObject existingObject : MemberDetailView.this.storages) {
                if (!existingObject.getString("Id").equals(object.getString("Id"))) continue;
                found = true;
            }
            if (!found.booleanValue()) {
                MemberDetailView.this.storages.add(object);
            }
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            if (MemberDetailView.this.storages == null) {
                return;
            }
            MemberDetailView.this.storages.remove(index);
            this.fireTableDataChanged();
        }

        public void remove(JSONObject object) {
            if (MemberDetailView.this.storages == null) {
                return;
            }
            MemberDetailView.this.storages.remove(object);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (MemberDetailView.this.storages == null) {
                return 0;
            }
            return MemberDetailView.this.storages.size();
        }

        @Override
        public int getColumnCount() {
            return this.cn.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cn[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            JSONObject jobjClass = (JSONObject)MemberDetailView.this.storages.get(rowIndex);
            try {
                switch (columnIndex) {
                    case 0: {
                        return jobjClass.getJSONObject("Storage__r").getString("Name");
                    }
                    case 1: {
                        return jobjClass.getString("Type__c");
                    }
                    case 2: {
                        return MemberDetailView.formatSFDCDate(jobjClass.getString("Start_Date__c"));
                    }
                    case 3: {
                        return MemberDetailView.formatSFDCDate(jobjClass.getString("End_Date__c"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    class SubscriptionListModel
    extends AbstractTableModel {
        String[] cn = new String[]{"Name", "Category", "Effective Date"};

        SubscriptionListModel() {
        }

        public JSONObject get(int index) {
            return (JSONObject)MemberDetailView.this.subscriptions.get(index);
        }

        public void add(JSONObject object) {
            if (MemberDetailView.this.subscriptions == null) {
                MemberDetailView.this.subscriptions = new ArrayList();
            }
            Boolean found = false;
            for (JSONObject existingObject : MemberDetailView.this.subscriptions) {
                if (!existingObject.getString("Id").equals(object.getString("Id"))) continue;
                found = true;
            }
            if (!found.booleanValue()) {
                MemberDetailView.this.subscriptions.add(object);
            }
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            if (MemberDetailView.this.subscriptions == null) {
                return;
            }
            MemberDetailView.this.subscriptions.remove(index);
            this.fireTableDataChanged();
        }

        public void remove(JSONObject object) {
            if (MemberDetailView.this.subscriptions == null) {
                return;
            }
            MemberDetailView.this.subscriptions.remove(object);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (MemberDetailView.this.subscriptions == null) {
                return 0;
            }
            return MemberDetailView.this.subscriptions.size();
        }

        @Override
        public int getColumnCount() {
            return this.cn.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cn[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            JSONObject jobjClass = (JSONObject)MemberDetailView.this.subscriptions.get(rowIndex);
            try {
                switch (columnIndex) {
                    case 0: {
                        return jobjClass.getString("Name");
                    }
                    case 1: {
                        return jobjClass.getJSONObject("Category__r").getString("Name");
                    }
                    case 2: {
                        return MemberDetailView.formatSFDCDate(jobjClass.getString("Start_Date__c"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    class ClassListModel
    extends AbstractTableModel {
        String[] cn = new String[]{"Name", "Start Time", "Status"};

        ClassListModel() {
        }

        public JSONObject get(int index) {
            return (JSONObject)MemberDetailView.this.classes.get(index);
        }

        public void add(JSONObject object) {
            if (MemberDetailView.this.classes == null) {
                MemberDetailView.this.classes = new ArrayList();
            }
            Boolean found = false;
            for (JSONObject existingObject : MemberDetailView.this.classes) {
                if (!existingObject.getString("Id").equals(object.getString("Id"))) continue;
                found = true;
            }
            if (!found.booleanValue()) {
                MemberDetailView.this.classes.add(object);
            }
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            if (MemberDetailView.this.classes == null) {
                return;
            }
            MemberDetailView.this.classes.remove(index);
            this.fireTableDataChanged();
        }

        public void remove(JSONObject object) {
            if (MemberDetailView.this.classes == null) {
                return;
            }
            MemberDetailView.this.classes.remove(object);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (MemberDetailView.this.classes == null) {
                return 0;
            }
            return MemberDetailView.this.classes.size();
        }

        @Override
        public int getColumnCount() {
            return this.cn.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cn[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            JSONObject jobjClass = (JSONObject)MemberDetailView.this.classes.get(rowIndex);
            try {
                switch (columnIndex) {
                    case 0: {
                        return jobjClass.getString("Name");
                    }
                    case 1: {
                        return MemberDetailView.formatSFDCDateTime(jobjClass.getString("StartTime__c"));
                    }
                    case 2: {
                        return jobjClass.getString("Status__c");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    class LessonListModel
    extends AbstractTableModel {
        String[] cn = new String[]{"Name", "Start Time", "Status"};

        LessonListModel() {
        }

        public JSONObject get(int index) {
            return (JSONObject)MemberDetailView.this.lessons.get(index);
        }

        public void add(JSONObject object) {
            if (MemberDetailView.this.lessons == null) {
                MemberDetailView.this.lessons = new ArrayList();
            }
            Boolean found = false;
            for (JSONObject existingObject : MemberDetailView.this.lessons) {
                if (!existingObject.getString("Id").equals(object.getString("Id"))) continue;
                found = true;
            }
            if (!found.booleanValue()) {
                MemberDetailView.this.lessons.add(object);
            }
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            if (MemberDetailView.this.lessons == null) {
                return;
            }
            MemberDetailView.this.lessons.remove(index);
            this.fireTableDataChanged();
        }

        public void remove(JSONObject object) {
            if (MemberDetailView.this.lessons == null) {
                return;
            }
            MemberDetailView.this.lessons.remove(object);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (MemberDetailView.this.lessons == null) {
                return 0;
            }
            return MemberDetailView.this.lessons.size();
        }

        @Override
        public int getColumnCount() {
            return this.cn.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cn[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            JSONObject lesson = (JSONObject)MemberDetailView.this.lessons.get(rowIndex);
            try {
                switch (columnIndex) {
                    case 0: {
                        return lesson.getString("Name");
                    }
                    case 1: {
                        return MemberDetailView.formatSFDCDateTime(lesson.getString("StartTime__c"));
                    }
                    case 2: {
                        return lesson.getString("Status__c");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    class ReservationListModel
    extends AbstractTableModel {
        String[] cn = new String[]{"Name", "Start Time", "Status", "Solo"};

        ReservationListModel() {
        }

        public JSONObject get(int index) {
            return (JSONObject)MemberDetailView.this.reservations.get(index);
        }

        public void add(JSONObject object) {
            if (MemberDetailView.this.reservations == null) {
                MemberDetailView.this.reservations = new ArrayList();
            }
            Boolean found = false;
            for (JSONObject existingObject : MemberDetailView.this.reservations) {
                if (!existingObject.getString("Id").equals(object.getString("Id"))) continue;
                found = true;
            }
            if (!found.booleanValue()) {
                MemberDetailView.this.reservations.add(object);
            }
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            if (MemberDetailView.this.reservations == null) {
                return;
            }
            MemberDetailView.this.reservations.remove(index);
            this.fireTableDataChanged();
        }

        public void remove(JSONObject object) {
            if (MemberDetailView.this.reservations == null) {
                return;
            }
            MemberDetailView.this.reservations.remove(object);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (MemberDetailView.this.reservations == null) {
                return 0;
            }
            return MemberDetailView.this.reservations.size();
        }

        @Override
        public int getColumnCount() {
            return this.cn.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cn[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            JSONObject reservation = (JSONObject)MemberDetailView.this.reservations.get(rowIndex);
            try {
                switch (columnIndex) {
                    case 0: {
                        return reservation.getString("Name");
                    }
                    case 1: {
                        return MemberDetailView.formatSFDCDateTime(reservation.getString("StartTime__c"));
                    }
                    case 2: {
                        return reservation.getString("Status__c");
                    }
                    case 3: {
                        if (reservation.getBoolean("Practice__c")) {
                            return "Yes";
                        }
                        return "";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

