/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.db.update;

import com.floreantpos.PosLog;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class UpdateDBTo225 {
    public void update() throws Exception {
        try {
            List<VoidItem> voidItems = VoidItemDAO.getInstance().findAll();
            if (voidItems == null || voidItems.isEmpty()) {
                return;
            }
            HashMap<String, ArrayList<VoidItem>> ticketVoidItemMap = new HashMap<String, ArrayList<VoidItem>>();
            for (VoidItem voidItem : voidItems) {
                ArrayList<VoidItem> ticketVoidItems = (ArrayList<VoidItem>)ticketVoidItemMap.get(voidItem.getTicketId());
                if (ticketVoidItems == null) {
                    ticketVoidItems = new ArrayList<VoidItem>();
                    ticketVoidItemMap.put(voidItem.getTicketId(), ticketVoidItems);
                }
                ticketVoidItems.add(voidItem);
            }
            Transaction transaction = null;
            try (Session session = TicketItemDAO.getInstance().createNewSession();){
                transaction = session.beginTransaction();
                for (String ticketId : ticketVoidItemMap.keySet()) {
                    List ticketVoidItems;
                    Ticket ticket = TicketDAO.getInstance().get(ticketId, session);
                    if (ticket == null || (ticketVoidItems = (List)ticketVoidItemMap.get(ticketId)) == null || ticketVoidItems.size() <= 0) continue;
                    List<TicketItem> ticketItems = ticket.getTicketItems();
                    block17: for (TicketItem ticketItem : ticketItems) {
                        for (VoidItem voidItem : ticketVoidItems) {
                            if (!ticketItem.isVoided().booleanValue() || ticketItem.getMenuItemId() == null || !ticketItem.getMenuItemId().equals(voidItem.getMenuItemId()) || voidItem.getTicketId() == null || !voidItem.getTicketId().equals(ticket.getId())) continue;
                            ticketItem.setItemReturned(ticketItem.isReturned());
                            ticketItem.setVoidReason(voidItem.getVoidReason());
                            ticketItem.addProperty("wasted", String.valueOf(voidItem.isItemWasted()));
                            ticketItem.addProperty("voidedByUserId", voidItem.getVoidByUserId());
                            TicketItemDAO.getInstance().update(ticketItem, session);
                            continue block17;
                        }
                    }
                }
                transaction.commit();
            }
            catch (Exception e) {
                if (transaction != null) {
                    try {
                        transaction.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        catch (Exception e) {
            String errMsg = "Could not update voided ticket items";
            PosLog.error(this.getClass(), errMsg, e);
        }
    }
}

