/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.db.update;

import com.floreantpos.PosLog;
import com.floreantpos.model.MenuDiscountRelation;
import com.floreantpos.model.dao.MenuDiscountRelationDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.util.DatabaseUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UpdateDBTo232 {
    private String dbConnectString;
    private String user;
    private String password;
    private long INCREMENT = 10000L;
    private List<MenuDiscountRelation> discountRelations = new ArrayList<MenuDiscountRelation>();

    public UpdateDBTo232(String dbConnectString, String user, String password) {
        this.dbConnectString = dbConnectString;
        this.user = user;
        this.password = password;
    }

    public void update() throws Exception {
        try (Connection connection = DriverManager.getConnection(this.dbConnectString, this.user, this.password);){
            DatabaseMetaData metaData = connection.getMetaData();
            this.doConvertMenuItemDiscountToMenuDiscountRelation(metaData);
            this.doConvertMenuGroupDiscountToMenuDiscountRelation(metaData);
            this.doConvertMenuCategoryDiscountToMenuDiscountRelation(metaData);
            this.doConvertOrderTypeDiscountToMenuDiscountRelation(metaData);
            if (!this.discountRelations.isEmpty()) {
                for (MenuDiscountRelation menuDiscountRelation : this.discountRelations) {
                    MenuDiscountRelationDAO.getInstance().saveOrUpdate(menuDiscountRelation);
                }
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private void doConvertMenuItemDiscountToMenuDiscountRelation(DatabaseMetaData metaData) throws SQLException {
        String menuItemDiscountTable = DatabaseUtil.getActualTableName(metaData, "MENUITEM_DISCOUNT");
        String menuItemDiscountId = DatabaseUtil.getActualColumnName(metaData, menuItemDiscountTable, "DISCOUNT_ID");
        String menuItemId = DatabaseUtil.getActualColumnName(metaData, menuItemDiscountTable, "MENUITEM_ID");
        long count = this.getRowCount(menuItemDiscountTable);
        if (count == 0L) {
            return;
        }
        long startIndex = 0L;
        do {
            TerminalDAO dao;
            List list;
            if ((list = (dao = TerminalDAO.getInstance()).executeSqlQuery("select " + menuItemDiscountId + "," + menuItemId + " from " + menuItemDiscountTable, startIndex, this.INCREMENT)) == null || list.size() <= 0) {
                return;
            }
            for (Object[] object : list) {
                int index = 0;
                MenuDiscountRelation discountRelation = new MenuDiscountRelation();
                discountRelation.setDiscountId(String.valueOf(object[index++]));
                discountRelation.setMenuitemId(String.valueOf(object[index++]));
                this.discountRelations.add(discountRelation);
            }
            startIndex += this.INCREMENT;
        } while ((count -= this.INCREMENT) > 0L);
    }

    private void doConvertMenuGroupDiscountToMenuDiscountRelation(DatabaseMetaData metaData) throws SQLException {
        String menuGroupDiscountTable = DatabaseUtil.getActualTableName(metaData, "MENUGROUP_DISCOUNT");
        String menuGroupDiscountId = DatabaseUtil.getActualColumnName(metaData, menuGroupDiscountTable, "DISCOUNT_ID");
        String menuGroupId = DatabaseUtil.getActualColumnName(metaData, menuGroupDiscountTable, "MENUGROUP_ID");
        long count = this.getRowCount(menuGroupDiscountTable);
        if (count == 0L) {
            return;
        }
        long startIndex = 0L;
        do {
            TerminalDAO dao;
            List list;
            if ((list = (dao = TerminalDAO.getInstance()).executeSqlQuery("select " + menuGroupDiscountId + "," + menuGroupId + " from " + menuGroupDiscountTable, startIndex, this.INCREMENT)) == null || list.size() <= 0) {
                return;
            }
            for (Object[] object : list) {
                int index = 0;
                MenuDiscountRelation discountRelation = new MenuDiscountRelation();
                discountRelation.setDiscountId(String.valueOf(object[index++]));
                discountRelation.setMenugroupId(String.valueOf(object[index++]));
                this.discountRelations.add(discountRelation);
            }
            startIndex += this.INCREMENT;
        } while ((count -= this.INCREMENT) > 0L);
    }

    private void doConvertMenuCategoryDiscountToMenuDiscountRelation(DatabaseMetaData metaData) throws SQLException {
        String menuCategoryDiscountTable = DatabaseUtil.getActualTableName(metaData, "MENUCATEGORY_DISCOUNT");
        String menuCategoryDiscountId = DatabaseUtil.getActualColumnName(metaData, menuCategoryDiscountTable, "DISCOUNT_ID");
        String menuCategoryId = DatabaseUtil.getActualColumnName(metaData, menuCategoryDiscountTable, "MENUCATEGORY_ID");
        long count = this.getRowCount(menuCategoryDiscountTable);
        if (count == 0L) {
            return;
        }
        long startIndex = 0L;
        do {
            TerminalDAO dao;
            List list;
            if ((list = (dao = TerminalDAO.getInstance()).executeSqlQuery("select " + menuCategoryDiscountId + "," + menuCategoryId + " from " + menuCategoryDiscountTable, startIndex, this.INCREMENT)) == null || list.size() <= 0) {
                return;
            }
            for (Object[] object : list) {
                int index = 0;
                MenuDiscountRelation discountRelation = new MenuDiscountRelation();
                discountRelation.setDiscountId(String.valueOf(object[index++]));
                discountRelation.setMenucategoryId(String.valueOf(object[index++]));
                this.discountRelations.add(discountRelation);
            }
            startIndex += this.INCREMENT;
        } while ((count -= this.INCREMENT) > 0L);
    }

    private void doConvertOrderTypeDiscountToMenuDiscountRelation(DatabaseMetaData metaData) throws SQLException {
        String orderTypeDiscountTable = DatabaseUtil.getActualTableName(metaData, "OT_DISCOUNT");
        String orderTypeDiscountId = DatabaseUtil.getActualColumnName(metaData, orderTypeDiscountTable, "DISCOUNT_ID");
        String orderTypeId = DatabaseUtil.getActualColumnName(metaData, orderTypeDiscountTable, "OT_ID");
        long count = this.getRowCount(orderTypeDiscountTable);
        if (count == 0L) {
            return;
        }
        long startIndex = 0L;
        do {
            TerminalDAO dao;
            List list;
            if ((list = (dao = TerminalDAO.getInstance()).executeSqlQuery("select " + orderTypeDiscountId + "," + orderTypeId + " from " + orderTypeDiscountTable, startIndex, this.INCREMENT)) == null || list.size() <= 0) {
                return;
            }
            for (Object[] object : list) {
                int index = 0;
                MenuDiscountRelation discountRelation = new MenuDiscountRelation();
                discountRelation.setDiscountId(String.valueOf(object[index++]));
                discountRelation.setOrderTypeId(String.valueOf(object[index++]));
                this.discountRelations.add(discountRelation);
            }
            startIndex += this.INCREMENT;
        } while ((count -= this.INCREMENT) > 0L);
    }

    private long getRowCount(String tableName) {
        TerminalDAO dao = TerminalDAO.getInstance();
        List list2 = dao.executeSqlQuery("select count(*) from " + tableName);
        long count = 0L;
        if (list2 != null && list2.size() > 0) {
            count = ((Number)list2.get(0)).longValue();
        }
        PosLog.debug(UpdateDBTo232.class, "Found row count " + count + " from " + tableName);
        return count;
    }
}

