/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.PosLog;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.ui.FloorPlanView;
import com.floreantpos.floorplan.ui.StatusManagementDialog;
import com.floreantpos.floorplan.ui.TableBookingForm;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class FloorBookingView
extends JPanel {
    private BookingInfo tableBookingInfo;
    private JLabel lblCustomerInfo;
    private JLabel lblBookingDate;
    private SimpleDateFormat dt = new SimpleDateFormat("hh:mm a");
    private JButton btnStatus;
    private FloorPlanView mapTableSelectionView;
    private StatusManagementDialog dialog;
    private PosButton btnSettings;
    private PosButton btnModify;
    private PosButton btnTimer;
    private PosButton btnMobile;

    public FloorBookingView(BookingInfo tableBookingInfo, FloorPlanView mapTableSelectionView) {
        this.tableBookingInfo = tableBookingInfo;
        this.mapTableSelectionView = mapTableSelectionView;
        this.initComponents();
        this.updateView();
    }

    private void initComponents() {
        try {
            this.setLayout((LayoutManager)new MigLayout("fillx"));
            this.setPreferredSize(PosUIManager.getSize(200, 0));
            StringBuilder reservationNo = new StringBuilder(this.tableBookingInfo.getBookingId());
            reservationNo.insert(4, '-');
            reservationNo.insert(7, '-');
            TitledBorder titledBorder = BorderFactory.createTitledBorder(null, Messages.getString("FloorBookingView.2") + reservationNo, 4, 0);
            this.setBorder(titledBorder);
            this.lblCustomerInfo = new JLabel();
            this.lblBookingDate = new JLabel("");
            this.btnStatus = new JButton();
            this.btnSettings = new PosButton();
            this.btnModify = new PosButton();
            this.btnTimer = new PosButton();
            this.btnMobile = new PosButton();
            BufferedImage imgSettings = ImageIO.read(this.getClass().getResource("/com/floreantpos/floorlayout/settings.png"));
            this.btnSettings.setIcon(new ImageIcon(imgSettings));
            BufferedImage imgModify = ImageIO.read(this.getClass().getResource("/com/floreantpos/floorlayout/modify.png"));
            this.btnModify.setIcon(new ImageIcon(imgModify));
            BufferedImage imgTimer = ImageIO.read(this.getClass().getResource("/com/floreantpos/floorlayout/timer.png"));
            this.btnTimer.setIcon(new ImageIcon(imgTimer));
            BufferedImage imgMobile = ImageIO.read(this.getClass().getResource("/com/floreantpos/floorlayout/mobile.png"));
            this.btnMobile.setIcon(new ImageIcon(imgMobile));
            this.btnModify.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FloorBookingView.this.doShowBookingInfoDialog();
                    }
                    catch (Exception e2) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage());
                    }
                }
            });
            this.add((Component)this.lblCustomerInfo, "span, growx,wrap");
            this.add(this.lblBookingDate);
            JPanel iconPanel = new JPanel((LayoutManager)new MigLayout("fillx,insets 0 0 0 0"));
            iconPanel.add((Component)this.btnSettings, "growx");
            iconPanel.add((Component)this.btnModify, "growx");
            this.add((Component)iconPanel, "span, grow");
            this.btnSettings.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FloorBookingView.this.doShowStatusManagementDialog();
                    }
                    catch (Exception e2) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage());
                    }
                }
            });
        }
        catch (Exception e1) {
            PosLog.error(FloorBookingView.class, e1);
        }
    }

    private void updateView() {
        String tableNamesOrNumbers;
        if (this.tableBookingInfo == null) {
            return;
        }
        String text = "<html>";
        String guests = Messages.getString("FloorBookingView.14") + this.tableBookingInfo.getGuestCount();
        if (StringUtils.isNotEmpty((String)String.valueOf(this.tableBookingInfo.getGuestCount()))) {
            text = text + guests + "<br>";
        }
        if (this.tableBookingInfo.getCustomer() != null) {
            String name = Messages.getString("FloorBookingView.16") + this.tableBookingInfo.getCustomer().getName();
            String phone = Messages.getString("FloorBookingView.17") + this.tableBookingInfo.getCustomer().getMobileNo();
            if (StringUtils.isNotEmpty((String)this.tableBookingInfo.getCustomer().getName())) {
                text = text + name + "<br>";
            }
            if (StringUtils.isNotEmpty((String)this.tableBookingInfo.getCustomer().getMobileNo())) {
                text = text + phone + "<br>";
            }
        }
        if (StringUtils.isNotEmpty((String)(tableNamesOrNumbers = this.tableBookingInfo.getBookedTableNamesOrNumbers()))) {
            tableNamesOrNumbers = Messages.getString("FloorBookingView.20") + tableNamesOrNumbers;
            text = text + tableNamesOrNumbers + "<br>";
        }
        String status = Messages.getString("FloorBookingView.22") + this.tableBookingInfo.getStatus();
        if (StringUtils.isNotEmpty((String)this.tableBookingInfo.getStatus())) {
            text = text + status;
        }
        text = text + "</html>";
        this.lblCustomerInfo.setText(text);
        this.lblBookingDate.setText(this.dt.format(this.tableBookingInfo.getFromDate()));
    }

    private void doShowStatusManagementDialog() {
        this.dialog = new StatusManagementDialog(this.tableBookingInfo, this.mapTableSelectionView);
        this.dialog.open();
    }

    private void doShowBookingInfoDialog() {
        BookingInfo cloneBookingInfo = this.tableBookingInfo.clone(this.tableBookingInfo);
        TableBookingForm bookingForm = new TableBookingForm(cloneBookingInfo);
        BeanEditorDialog dialog = new BeanEditorDialog(bookingForm);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.mapTableSelectionView.createCustomerBookingInfoPanel();
    }
}

