/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.ItemReorderAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.ui.FloorPlanView;
import com.floreantpos.floorplan.ui.StatusManagementDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.Store;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.ReorderType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ImageComponent;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ShopTableButton;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.floorplan.UiRenderer;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.payment.SplitedTicketSelectionDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.StaleStateException;

public class FloorView
extends JPanel
implements MouseListener,
MouseMotionListener,
RefreshableView,
UiRenderer {
    private JLayeredPane floorPanel = new JLayeredPane();
    private PosScrollPane scrollPane;
    private Map<Integer, ShopTableButton> tableButtonMap = new HashMap<Integer, ShopTableButton>();
    public Set<Integer> addedTableListModel = new HashSet<Integer>();
    public List<Integer> removeTableListModel = new ArrayList<Integer>();
    private FloorPlanView mapTableSelectionView;
    private ShopFloor floor;
    private int pressedX;
    private int pressedY;
    private Point dragLocation;
    private boolean rearrange;

    public FloorView(FloorPlanView mapTableSelectionView, ShopFloor floor) {
        this.mapTableSelectionView = mapTableSelectionView;
        this.floor = floor;
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(new EmptyBorder(8, 5, 5, 5));
        this.createLayoutPanel();
    }

    private void createLayoutPanel() {
        this.floorPanel.setOpaque(true);
        this.floorPanel.setBackground(Color.white);
        this.floorPanel.setAutoscrolls(true);
        JPanel floorPanelCon = new JPanel(new FlowLayout(3));
        floorPanelCon.setOpaque(true);
        floorPanelCon.setBackground(Color.WHITE);
        floorPanelCon.add(this.floorPanel);
        this.scrollPane = new PosScrollPane(floorPanelCon);
        this.scrollPane.setBorder(null);
        this.scrollPane.setViewportBorder(null);
        this.scrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(35, 35));
        this.scrollPane.getHorizontalScrollBar().setPreferredSize(PosUIManager.getSize(35, 35));
        this.add((Component)this.scrollPane, "Center");
    }

    public void renderFloor() {
        this.floorPanel.removeAll();
        if (this.floor == null) {
            return;
        }
        Session session = null;
        try {
            session = ShopFloorDAO.getInstance().createNewSession();
            this.floor = ShopFloorDAO.getInstance().get(this.floor.getId(), session);
            this.renderTables(session);
            this.setFloorBackground();
            this.revalidate();
            this.repaint();
        }
        finally {
            ShopFloorDAO.getInstance().closeSession(session);
        }
    }

    @Override
    public void render() {
        this.renderFloor();
    }

    private void setFloorBackground() {
        ImageIcon image = this.floor.getImage();
        JLabel imageComponent = null;
        Dimension floorSize = this.floor.getFloorSize();
        this.floorPanel.setPreferredSize(floorSize);
        this.floorPanel.setOpaque(true);
        if (this.hasBackgroundColor()) {
            this.floorPanel.setBackground(this.floor.getBackgroundColor());
        } else {
            this.floorPanel.setBackground(Color.WHITE);
        }
        if (image != null) {
            if (floorSize.width < image.getIconWidth()) {
                floorSize.width = image.getIconWidth();
            }
            if (floorSize.height < image.getIconHeight()) {
                floorSize.height = image.getIconHeight();
            }
            imageComponent = new JLabel(image);
            imageComponent.setBounds(0, 0, image.getIconWidth(), image.getIconHeight());
            imageComponent.addMouseListener(this);
            imageComponent.addMouseMotionListener(this);
            this.floorPanel.add(imageComponent);
            this.floorPanel.moveToBack(imageComponent);
        }
    }

    private boolean hasBackgroundColor() {
        Color color = this.floor.getBackgroundColor();
        return color != null;
    }

    public void renderTables(Session session) {
        for (Component c : this.floorPanel.getComponents()) {
            if (c instanceof ImageComponent) continue;
            this.floorPanel.remove(c);
        }
        Set<ShopTable> tables = this.floor.getTables();
        if (tables == null || tables.isEmpty()) {
            return;
        }
        Store store = DataProvider.get().getStore();
        for (ShopTable shopTable : tables) {
            if (shopTable.getShopTableStatus().getTableStatus().equals((Object)TableStatus.Disable) || shopTable.isDeleted().booleanValue()) continue;
            if (StringUtils.isEmpty((String)shopTable.getTicketId())) {
                shopTable.setTableStatus(TableStatus.Available);
            }
            ShopTableButton tableButton = this.tableButtonMap.get(shopTable.getId());
            shopTable.setShopTableStatus(ShopTableStatusDAO.getInstance().get(shopTable.getId()));
            if (tableButton == null) {
                tableButton = new ShopTableButton(shopTable);
                tableButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            if (!FloorView.this.rearrange) {
                                FloorView.this.addTable(e);
                            }
                        }
                        catch (PosException e2) {
                            POSMessageDialog.showError(e2.getMessage());
                        }
                        catch (Exception e2) {
                            POSMessageDialog.showError(e2.getMessage(), e2);
                        }
                    }
                });
                tableButton.addMouseListener(this);
                tableButton.addMouseMotionListener(this);
                this.tableButtonMap.put(shopTable.getId(), tableButton);
            } else {
                tableButton.setShopTable(shopTable);
            }
            this.floorPanel.add(tableButton);
            tableButton.update(store);
        }
        this.floorPanel.revalidate();
        this.floorPanel.repaint();
        this.clearSelection();
    }

    public void updateTables() {
        this.clearSelection();
        Set<ShopTable> tables = this.floor.getTables();
        if (tables == null || tables.isEmpty()) {
            return;
        }
        for (ShopTable shopTable : tables) {
            ShopTableButton tableButton = this.tableButtonMap.get(shopTable.getId());
            if (tableButton == null) continue;
            tableButton.update();
            tableButton.repaint();
            this.floorPanel.repaint();
            this.doImageMoveToBack();
        }
    }

    public void fireAddedTableListChanged() {
        if (this.addedTableListModel == null || this.addedTableListModel.isEmpty()) {
            return;
        }
        for (Integer tableNo : this.addedTableListModel) {
            ShopTableButton tableButton = this.tableButtonMap.get(tableNo);
            if (tableButton == null) continue;
            tableButton.setBackground(Color.GREEN);
            tableButton.setForeground(Color.BLACK);
        }
    }

    private void doImageMoveToBack() {
        Component[] components;
        for (Component component : components = this.getFloorPanel().getComponents()) {
            if (!(component instanceof ImageComponent)) continue;
            this.floorPanel.moveToBack(component);
        }
    }

    private void addTable(ActionEvent e) throws Exception {
        ShopTableButton button = (ShopTableButton)e.getSource();
        if (this.mapTableSelectionView.isTicketTransferMode() && button.getShopTable().getTableStatus().equals((Object)TableStatus.Booked)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("FloorView.12"));
            return;
        }
        ShopTable storedShopTable = button.getShopTable();
        ShopTableStatus shopTaleStatus = storedShopTable.getShopTableStatus();
        if (!TerminalDAO.getInstance().isVersionEqual(ShopTableStatus.class, shopTaleStatus.getId(), shopTaleStatus.getVersion())) {
            POSMessageDialog.showMessage(Messages.getString("FloorView.14"));
            return;
        }
        int tableNumber = button.getId();
        ShopTable shopTable = ShopTableDAO.getInstance().getByNumber(tableNumber);
        if (shopTable == null) {
            POSMessageDialog.showMessage(Messages.getString("FloorView.14"));
            return;
        }
        shopTaleStatus = shopTable.getShopTableStatus();
        if (shopTable.getTableStatus() == null) {
            shopTable.setTableStatus(TableStatus.Available);
        }
        if (!this.mapTableSelectionView.shouldRelease() && shopTable.getTableStatus().equals((Object)TableStatus.Booked)) {
            if (this.mapTableSelectionView.shouldGroup()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorView.2"));
                return;
            }
            if (shopTable.getCurrentBookingId() == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorView.17"));
                return;
            }
            BookingInfo bookingInfo = BookingInfoDAO.getInstance().findById(shopTable.getCurrentBookingId());
            if (bookingInfo == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("FloorView.21"));
                return;
            }
            StatusManagementDialog dialog = new StatusManagementDialog(bookingInfo, this.mapTableSelectionView);
            dialog.open();
            return;
        }
        button.setShopTable(shopTable);
        button.initializeUser();
        button.initializeTicket();
        shopTable.setReArrange(storedShopTable.isReArrange());
        if (shopTable.isReArrange()) {
            return;
        }
        if (this.mapTableSelectionView.shouldGroup()) {
            if (this.mapTableSelectionView.isTicketTransferMode()) {
                if (this.addedTableListModel.contains(button.getId())) {
                    this.addedTableListModel.remove(button.getId());
                    Store store = DataProvider.get().getStore();
                    button.setTicket(null);
                    if (shopTable.getTableStatus().equals((Object)TableStatus.Booked)) {
                        button.setBackground(store.getTableBookBGColor());
                        button.setForeground(store.getTableBookForeColor());
                    } else if (shopTable.getTableStatus().equals((Object)TableStatus.Seat)) {
                        button.setBackground(store.getTableSeatBGColor());
                        button.setForeground(store.getTableSeatForeColor());
                    } else if (shopTable.getTableStatus().equals((Object)TableStatus.Serving)) {
                        button.setBackground(store.getTableServingBGColor());
                        button.setForeground(store.getTableServingForeColor());
                    } else {
                        button.setBackground(store.getTableFreeBGColor());
                        button.setForeground(store.getTableFreeForeColor());
                    }
                    this.floorPanel.repaint();
                    this.floorPanel.revalidate();
                    return;
                }
                this.doAddBtnWithListModel(button);
                return;
            }
            if (this.addedTableListModel.contains(button.getId())) {
                this.doRemoveBtnWithListModel(button);
            } else {
                this.doAddBtnWithListModel(button);
            }
            return;
        }
        if (shopTaleStatus.hasMultipleTickets() && !this.mapTableSelectionView.shouldRelease() && !this.mapTableSelectionView.shouldReorder()) {
            if (this.mapTableSelectionView.isTicketTransferMode()) {
                this.addedTableListModel.add(button.getId());
                this.closeDialog(false);
            } else {
                this.showSplitTickets(shopTaleStatus);
            }
            return;
        }
        if (this.mapTableSelectionView.shouldHoldFire()) {
            this.performHoldFireTicket(button, shopTable);
            return;
        }
        if (this.mapTableSelectionView.shouldGuestCheck()) {
            this.showGuestCheckTicket(button, shopTable);
            return;
        }
        if (this.mapTableSelectionView.shouldSplitCheck()) {
            this.doSplitCheckTicket(button, shopTable);
            return;
        }
        if (this.mapTableSelectionView.shouldSettle()) {
            this.doSettleTicket(button, shopTable);
            return;
        }
        if (this.mapTableSelectionView.shouldRelease()) {
            this.doReleaseTable(button, shopTable);
            return;
        }
        if (this.mapTableSelectionView.shouldReorder()) {
            ReorderType reorderType = this.mapTableSelectionView.getReorderType();
            if (reorderType != null && reorderType == ReorderType.TICKET_REORDER) {
                this.addedTableListModel.add(shopTable.getId());
                this.closeDialog(false);
            } else {
                this.showSplitTickets(shopTaleStatus);
            }
            return;
        }
        if (!this.mapTableSelectionView.isComplete() && shopTable.getTableStatus().equals((Object)TableStatus.Serving)) {
            if (!button.hasUserAccess()) {
                return;
            }
            if (this.mapTableSelectionView.isCreateNewTicket()) {
                this.editTicket(button.getTicket());
                this.closeDialog(false);
            }
        }
        if (!this.mapTableSelectionView.isComplete() && shopTable.getTableStatus().equals((Object)TableStatus.Serving) && !this.mapTableSelectionView.shouldGroup()) {
            if (!button.hasUserAccess()) {
                return;
            }
            if (this.mapTableSelectionView.isCreateNewTicket()) {
                this.editTicket(button.getTicket());
                this.closeDialog(false);
            }
            return;
        }
        if (this.mapTableSelectionView.isSeat() && !this.mapTableSelectionView.shouldGroup()) {
            if (this.addedTableListModel.contains(button.getId())) {
                return;
            }
            if (button.getShopTable().getTableStatus().equals((Object)TableStatus.Serving)) {
                return;
            }
            button.setBackground(Color.green);
            button.setForeground(Color.black);
            this.addedTableListModel.add(button.getId());
            return;
        }
        if (this.mapTableSelectionView.isComplete() && !this.mapTableSelectionView.shouldGroup()) {
            this.doSettleTicket(button, shopTable);
            return;
        }
        if (!this.mapTableSelectionView.shouldGroup()) {
            this.addedTableListModel.clear();
            if (!this.addedTableListModel.contains(button.getId())) {
                this.addedTableListModel.add(button.getId());
            }
            this.closeDialog(false);
            if (this.mapTableSelectionView.isCreateNewTicket()) {
                this.doCreateNewTicket();
            }
        }
    }

    private void doAddBtnWithListModel(ShopTableButton button) {
        button.setBackground(Color.GREEN);
        button.setForeground(Color.BLACK);
        if (!this.addedTableListModel.contains(button.getId())) {
            this.addedTableListModel.add(button.getId());
        }
    }

    private void doRemoveBtnWithListModel(ShopTableButton button) {
        if (this.addedTableListModel.contains(button.getId())) {
            this.addedTableListModel.remove(button.getId());
            button.update();
        }
    }

    private void showSplitTickets(ShopTableStatus shopTaleStatus) {
        ArrayList<Ticket> splitTickets = new ArrayList<Ticket>();
        String action = "";
        if (this.mapTableSelectionView.shouldHoldFire()) {
            action = POSConstants.SEND_TO_KITCHEN;
        } else if (this.mapTableSelectionView.shouldGuestCheck()) {
            action = POSConstants.ORDER_INFO;
        } else if (this.mapTableSelectionView.shouldSettle()) {
            action = POSConstants.SETTLE;
        } else if (this.mapTableSelectionView.shouldSplitCheck()) {
            action = POSConstants.SPLIT_TICKET;
        } else if (this.mapTableSelectionView.shouldReorder()) {
            action = POSConstants.REORDER_TICKET_BUTTON_TEXT;
        } else {
            action = POSConstants.EDIT;
            splitTickets.add(null);
        }
        for (String ticketId : shopTaleStatus.getListOfTicketNumbers()) {
            splitTickets.add(TicketDAO.getInstance().loadFullTicket(ticketId));
        }
        if (splitTickets.size() == 1 && this.mapTableSelectionView.shouldReorder()) {
            ItemReorderAction itemReorderAction = new ItemReorderAction((Ticket)splitTickets.get(0));
            itemReorderAction.execute();
            this.clearSelection();
        } else {
            SplitedTicketSelectionDialog posDialog = new SplitedTicketSelectionDialog(splitTickets);
            List<ShopTable> selectedTables = this.getSelectedTables();
            if (selectedTables.isEmpty()) {
                ShopTableButton shopTableButton = this.tableButtonMap.get(shopTaleStatus.getId());
                selectedTables.add(shopTableButton.getShopTable());
            }
            posDialog.setSelectedTables(selectedTables);
            posDialog.setOrderType(this.mapTableSelectionView.getOrderType());
            posDialog.setSelectedAction(action);
            posDialog.setSize(PosUIManager.getSize(800, 600));
            posDialog.open();
            this.clearSelection();
            if (!posDialog.isCanceled()) {
                for (ShopTable shopTable : selectedTables) {
                    ShopTableButton tableButton = this.tableButtonMap.get(shopTable.getId());
                    ShopTableStatus shopTableStatus = tableButton.getShopTable().getShopTableStatus();
                    ShopTableStatusDAO.getInstance().refresh(shopTableStatus);
                    tableButton.update();
                }
            }
        }
        if (action.equals(POSConstants.EDIT)) {
            this.closeDialog(false);
        }
    }

    private void doReleaseTables() {
        List<Integer> tableNumbers;
        Ticket ticket = this.mapTableSelectionView.getTicket();
        if (ticket != null && (tableNumbers = ticket.getTableNumbers()) != null && !tableNumbers.isEmpty()) {
            this.removeTableListModel.addAll(tableNumbers);
        }
        ShopTableDAO.getInstance().updateTableStatus(this.removeTableListModel, null, null, false);
    }

    private boolean editTicket(Ticket ticket) {
        if (ticket == null) {
            return false;
        }
        this.closeDialog(false);
        TicketDAO.getInstance().loadFullTicket(ticket);
        OrderView.getInstance().setCurrentTicket(ticket);
        RootView.getInstance().showView("ORDER_VIEW");
        return true;
    }

    private void doSettleTicket(ShopTableButton button, ShopTable shopTable) {
        if (shopTable.getTableStatus().equals((Object)TableStatus.Serving)) {
            if (!button.hasUserAccess()) {
                return;
            }
            this.showTicketSettleDialog(button.getTicket());
            this.closeDialog(false);
            this.clearSelection();
            return;
        }
        POSMessageDialog.showMessage(Messages.getString("FloorView.23"));
        this.clearSelection();
    }

    private void doReleaseTable(ShopTableButton button, ShopTable shopTable) {
        if (shopTable.getTableStatus().equals((Object)TableStatus.Serving)) {
            if (!button.hasUserAccess()) {
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("FloorView.28"), Messages.getString("FloorView.29"));
            if (option != 0) {
                this.clearSelection();
                return;
            }
            this.doSetTableAvailable(shopTable);
            return;
        }
        if (shopTable.getTableStatus().equals((Object)TableStatus.Seat)) {
            BookingInfo bookingInfo;
            if (!button.hasUserAccess()) {
                return;
            }
            String message = Messages.getString("FloorView.22");
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), message, Messages.getString("FloorView.29"));
            if (option != 0) {
                this.clearSelection();
                return;
            }
            String bookingInfoId = shopTable.getCurrentBookingId();
            if (StringUtils.isNotEmpty((String)bookingInfoId) && (bookingInfo = BookingInfoDAO.getInstance().findById(bookingInfoId)) != null) {
                List<ShopTable> shopTables = bookingInfo.getTables();
                if (shopTables != null && shopTables.contains(shopTable)) {
                    shopTables.remove(shopTable);
                }
                BookingInfoDAO.getInstance().update(bookingInfo);
            }
            this.doSetTableAvailable(shopTable);
            return;
        }
        if (shopTable.getTableStatus().equals((Object)TableStatus.Booked)) {
            String message = Messages.getString("FloorView.15");
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
            this.clearSelection();
            return;
        }
        POSMessageDialog.showMessage(Messages.getString("FloorView.23"));
        this.clearSelection();
    }

    private void doSetTableAvailable(ShopTable shopTable) {
        shopTable.setTableStatus(TableStatus.Available);
        shopTable.removeProperty("RES_NO");
        shopTable.removeProperty("shop.table_customer.id");
        shopTable.setCurrentBookingId(null);
        shopTable.setCustomerName(null);
        this.removeTableListModel.add(shopTable.getId());
        ShopTableDAO.getInstance().updateTableStatus(this.removeTableListModel, null, null, false);
        ShopTableDAO.getInstance().saveOrUpdate(shopTable);
        this.closeDialog(false);
        this.clearSelection();
        this.renderFloor();
    }

    private void doReorderTicket(ShopTableButton button, ShopTable shopTable) {
        if (shopTable.getTableStatus().equals((Object)TableStatus.Serving)) {
            if (!button.hasUserAccess()) {
                return;
            }
            this.showReorderDialog(button.getTicket());
            this.closeDialog(false);
            this.clearSelection();
            return;
        }
        POSMessageDialog.showMessage(Messages.getString("FloorView.23"));
        this.clearSelection();
    }

    private void doSplitCheckTicket(ShopTableButton button, ShopTable shopTable) {
        if (shopTable.getTableStatus().equals((Object)TableStatus.Serving)) {
            if (!button.hasUserAccess()) {
                return;
            }
            this.splitCheckTicketView(button.getTicket());
            this.closeDialog(false);
            this.clearSelection();
            return;
        }
        POSMessageDialog.showMessage(Messages.getString("FloorView.23"));
        this.clearSelection();
    }

    private void showGuestCheckTicket(ShopTableButton button, ShopTable shopTable) throws Exception {
        if (shopTable.getTableStatus().equals((Object)TableStatus.Serving)) {
            if (!button.hasUserAccess()) {
                return;
            }
            this.showOrderView(button.getTicket());
            this.closeDialog(false);
            this.clearSelection();
            return;
        }
        POSMessageDialog.showMessage(Messages.getString("FloorView.23"));
        this.clearSelection();
    }

    private void performHoldFireTicket(ShopTableButton button, ShopTable shopTable) {
        try {
            if (shopTable.getTableStatus().equals((Object)TableStatus.Serving)) {
                if (!button.hasUserAccess()) {
                    return;
                }
                this.sendTicketOrderToKitchen(button.getTicket());
                this.closeDialog(false);
                this.clearSelection();
                return;
            }
            POSMessageDialog.showMessage(Messages.getString("FloorView.23"));
            this.clearSelection();
            return;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, e);
            return;
        }
    }

    public void clearSelection() {
        this.mapTableSelectionView.clearSelection();
        this.addedTableListModel.clear();
        this.removeTableListModel.clear();
    }

    private boolean showTicketSettleDialog(Ticket ticket) {
        if (ticket == null) {
            return false;
        }
        this.closeDialog(false);
        new SettleTicketAction(ticket).execute();
        this.renderFloor();
        return true;
    }

    private boolean showReorderDialog(Ticket ticket) {
        if (ticket == null) {
            return false;
        }
        this.closeDialog(false);
        new ItemReorderAction(ticket).execute();
        this.renderFloor();
        return true;
    }

    private boolean splitCheckTicketView(Ticket ticket) {
        if (ticket == null) {
            return false;
        }
        this.closeDialog(false);
        SplitTicketAction action = new SplitTicketAction(ticket);
        action.execute();
        return true;
    }

    private boolean showOrderView(Ticket ticket) throws Exception {
        if (ticket == null) {
            return false;
        }
        this.closeDialog(false);
        Ticket ticketToEdit = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
        ticketsToShow.add(ticketToEdit);
        OrderInfoView view = new OrderInfoView(ticketsToShow);
        OrderInfoDialog dialog = new OrderInfoDialog(view);
        dialog.setSize(PosUIManager.getSize(400), PosUIManager.getSize(600));
        dialog.setDefaultCloseOperation(2);
        dialog.setLocationRelativeTo(Application.getPosWindow());
        dialog.setVisible(true);
        return true;
    }

    private boolean sendTicketOrderToKitchen(Ticket ticket) {
        if (ticket == null) {
            return false;
        }
        this.closeDialog(false);
        Ticket ticketToEdit = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        OrderView.getInstance().setCurrentTicket(ticketToEdit);
        if (ticketToEdit.needsKitchenPrint()) {
            try {
                OrderView.getInstance().getTicketView().sendTicketToKitchen();
                POSMessageDialog.showMessage(Messages.getString("FloorView.37"));
            }
            catch (Exception e) {
                POSMessageDialog.showError("Failed to send to kitchen");
            }
        } else {
            POSMessageDialog.showMessage(Messages.getString("FloorView.38"));
        }
        return true;
    }

    private void closeDialog(boolean canceled) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof POSDialog) {
            ((POSDialog)windowAncestor).setCanceled(canceled);
            windowAncestor.dispose();
        }
    }

    public boolean doGroupAction() {
        if (this.addedTableListModel == null || this.addedTableListModel.isEmpty()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("FloorView.39"));
            return false;
        }
        if (this.mapTableSelectionView.isCreateNewTicket()) {
            this.doCreateNewTicket();
        }
        this.closeDialog(false);
        return true;
    }

    public void doCreateNewTicket() {
        try {
            List<ShopTable> selectedTables = this.getSelectedTables();
            if (selectedTables.isEmpty()) {
                this.clearSelection();
                return;
            }
            Customer customer = null;
            if (selectedTables.size() == 1) {
                for (ShopTable shopTable : selectedTables) {
                    String customerId = shopTable.getProperty("shop.table_customer.id");
                    if (!StringUtils.isNotBlank((String)customerId)) continue;
                    customer = CustomerDAO.getInstance().load(customerId);
                }
            }
            OrderServiceFactory.getOrderService().createNewTicket(this.mapTableSelectionView.getOrderType(), selectedTables, customer);
            this.clearSelection();
        }
        catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
            // empty catch block
        }
    }

    public JLayeredPane getFloorPanel() {
        return this.floorPanel;
    }

    public List<ShopTable> getSelectedTables() {
        ArrayList<ShopTable> tables = new ArrayList<ShopTable>();
        for (Integer tableId : this.addedTableListModel) {
            ShopTableButton shopTableButton = this.tableButtonMap.get(tableId);
            if (shopTableButton == null) continue;
            tables.add(shopTableButton.getShopTable());
        }
        return tables;
    }

    public ShopFloor getFloor() {
        return this.floor;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        try {
            if (!this.rearrange) {
                return;
            }
            Object object = e.getSource();
            if (object instanceof ShopTableButton) {
                ShopTableButton tableBtn = (ShopTableButton)e.getSource();
                int x = e.getX() - this.pressedX + tableBtn.getLocation().x;
                int y = e.getY() - this.pressedY + tableBtn.getLocation().y;
                int floorWidth = this.floorPanel.getBounds().width - 40;
                int floorHeight = this.floorPanel.getBounds().height - 40;
                if (x < 0 || x > floorWidth) {
                    return;
                }
                if (y < 0 || y > floorHeight) {
                    return;
                }
                tableBtn.getShopTable().setX(x);
                tableBtn.getShopTable().setY(y);
                ShopTableDAO.getInstance().saveOrUpdate(tableBtn.getShopTable());
                tableBtn.setLocation(x, y);
                this.repaint();
            } else if (object instanceof ImageComponent) {
                ImageComponent imageComponent = (ImageComponent)object;
                this.floorPanel.moveToBack(imageComponent);
                Dimension preferredSize = imageComponent.getSize();
                if (this.getCursor().getType() == 11 && this.dragLocation.getX() <= (double)(this.getWidth() - 5)) {
                    int w = (int)(preferredSize.getWidth() + (e.getPoint().getX() - this.dragLocation.getX()));
                    imageComponent.setSize(w, (int)preferredSize.getHeight());
                    this.floor.setWidth(w);
                } else if (this.getCursor().getType() == 9 && this.dragLocation.getY() <= (double)(this.getHeight() - 5)) {
                    int h = (int)(preferredSize.getHeight() + (e.getPoint().getY() - this.dragLocation.getY()));
                    imageComponent.setSize((int)preferredSize.getWidth(), h);
                    this.floor.setHeight(h);
                }
                ShopFloorDAO.getInstance().saveOrUpdate(this.floor);
                this.dragLocation = e.getPoint();
                imageComponent.revalidate();
                imageComponent.repaint();
            }
        }
        catch (StaleStateException exception) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("FloorView.24"), e2);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Object object = e.getSource();
        this.dragLocation = e.getPoint();
        if (!this.rearrange) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (object instanceof ImageComponent) {
            ImageComponent imageComponent = (ImageComponent)object;
            Point dragLocation = e.getPoint();
            Dimension preferredSize = imageComponent.getSize();
            if (dragLocation.x >= preferredSize.width - 10 && dragLocation.x <= preferredSize.width - 2) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (dragLocation.y >= preferredSize.height - 10 && dragLocation.y <= preferredSize.height - 2) {
                this.setCursor(Cursor.getPredefinedCursor(9));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressedX = e.getX();
        this.pressedY = e.getY();
        this.dragLocation = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public boolean isRearrange() {
        return this.rearrange;
    }

    public void setRearrange(boolean rearrange) {
        this.rearrange = rearrange;
    }

    @Override
    public void refresh() {
        try {
            if (this.floor == null || this.floor.getId() == null) {
                return;
            }
            this.floor = ShopFloorDAO.getInstance().get(this.floor.getId());
            ShopFloorDAO.getInstance().initializeTables(this.floor);
            this.renderFloor();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }
}

