/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.action.OnlineTableBookingAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.swing.PosButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class PopUpWindow
extends JFrame {
    private JLabel lblCallerId;
    private JPanel contentPanel;
    private PosButton btnMaximum;
    private PosButton btnMinimize;
    private PosButton btnClose;
    private String msg;

    public PopUpWindow(String msg) {
        this.setLayout((LayoutManager)new MigLayout("fill,inset 5, hidemode 3", "fill,grow", ""));
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.msg = msg;
        this.positionWindow(330, 130);
        this.setFocusable(true);
        this.setUndecorated(true);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.lblCallerId = new JLabel();
        this.btnMinimize = new PosButton(IconFactory.getIcon("/images/", "minimize.png"));
        this.btnMaximum = new PosButton(IconFactory.getIcon("/images/", "maximize.png"));
        this.btnClose = new PosButton(IconFactory.getIcon("/images/", "close.png"));
        CallerHeaderPanel headerPanel = new CallerHeaderPanel();
        headerPanel.add((Component)this.btnMinimize, "split 3,w 20!,h 20!, grow, right");
        headerPanel.add((Component)this.btnMaximum, "w 20!,h 20!");
        headerPanel.add((Component)this.btnClose, "w 20!,h 20!");
        headerPanel.setBackground(new Color(44, 44, 44));
        this.getContentPane().setBackground(new Color(44, 44, 44));
        this.add((Component)headerPanel, "grow,wrap");
        Font font = new Font("Verdana", 1, 16);
        Color color = Color.WHITE;
        this.contentPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,inset 0,fill", "fill,grow", ""));
        JSeparator sep = new JSeparator();
        sep.setBackground(Color.white);
        sep.setForeground(Color.white);
        this.contentPanel.add((Component)sep, "cell 0 0 3 1,grow,span");
        JLabel lblMessage = new JLabel();
        lblMessage.setText(msg);
        lblMessage.setFont(font);
        lblMessage.setForeground(color);
        this.btnMinimize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpWindow.this.contentPanel.setVisible(false);
                PopUpWindow.this.positionWindow(330, 25);
            }
        });
        this.btnMaximum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpWindow.this.contentPanel.setVisible(true);
                PopUpWindow.this.positionWindow(330, 130);
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpWindow.this.setVisible(false);
                PopUpWindow.this.dispose();
            }
        });
        PosButton btnUpdate = new PosButton(Messages.getString("PopUpWindow.18"));
        btnUpdate.setForeground(color);
        btnUpdate.setFont(new Font("Verdana", 1, 12));
        btnUpdate.setBorder(new RoundedBorder(10));
        btnUpdate.setBackground(new Color(77, 201, 92));
        btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Application.getCurrentUser() != null) {
                    new OnlineTableBookingAction().execute();
                }
                PopUpWindow.this.dispose();
            }
        });
        PosButton btnCancel = new PosButton(Messages.getString("PopUpWindow.20"));
        btnCancel.setForeground(color);
        btnCancel.setBorder(new RoundedBorder(10));
        btnCancel.setBackground(new Color(130, 188, 8));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopUpWindow.this.setVisible(false);
                PopUpWindow.this.dispose();
            }
        });
        this.contentPanel.add((Component)lblMessage, "cell 1 0,gaptop 2, span 2");
        this.contentPanel.add((Component)btnUpdate, "cell 2 3,split 2,h 30!");
        this.contentPanel.add((Component)btnCancel, "cell 2 4,h 30!");
        this.contentPanel.setBackground(new Color(44, 44, 44));
        this.setAlwaysOnTop(true);
        this.add((Component)this.contentPanel, "grow");
    }

    public void setMaximize(boolean maximize) {
        this.setVisible(true);
        this.contentPanel.setVisible(maximize);
    }

    private void positionWindow(int width, int height) {
        this.setSize(width, height);
        Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        int x = screenSize.width - width;
        int y = screenSize.height - height;
        this.setLocation(x, y);
    }

    public static void main(String[] arg) {
        new PopUpWindow(Messages.getString("PopUpWindow.28")).setVisible(true);
    }

    public class CallerHeaderPanel
    extends JPanel {
        Customer customer;

        CallerHeaderPanel() {
            this.setLayout((LayoutManager)new MigLayout("fill, alignx right", "", ""));
        }

        public void setCustomer(Customer customer) {
            this.customer = customer;
        }
    }

    private static class RoundedBorder
    implements Border {
        private int radius;

        RoundedBorder(int radius) {
            this.radius = radius;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.radius + 1, this.radius + 1, this.radius + 2, this.radius);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.drawRoundRect(x, y, width - 1, height - 1, this.radius, this.radius);
        }
    }
}

