/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.dao.ShopTableTypeDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleObjectStateException;

public class ShopTableTypeForm
extends BeanEditor<ShopTableType> {
    private JTextArea tfTableTypeDescription;
    private FixedLengthTextField tfTableTypeName;
    private JPanel tableTypeCentralPanel = new JPanel();
    private JLabel typeName;
    private JLabel description;

    public ShopTableTypeForm() {
        this.tableTypeCentralPanel.setLayout((LayoutManager)new MigLayout());
        this.tfTableTypeName = new FixedLengthTextField(40);
        this.tfTableTypeDescription = new JTextArea(10, 30);
        this.tfTableTypeDescription.setDocument(new FixedLengthDocument(120));
        this.typeName = new JLabel(Messages.getString("ShopTableTypeForm.1"));
        this.description = new JLabel(Messages.getString("ShopTableTypeForm.2"));
        this.tableTypeCentralPanel.add(this.typeName);
        this.tableTypeCentralPanel.add((Component)this.tfTableTypeName, "wrap");
        this.tableTypeCentralPanel.add((Component)this.description, "top");
        this.tableTypeCentralPanel.add((Component)new JScrollPane(this.tfTableTypeDescription), "wrap,grow");
        this.add(this.tableTypeCentralPanel);
    }

    public void setFieldsEditable(boolean editable) {
        this.tfTableTypeName.setEditable(editable);
        this.tfTableTypeDescription.setEditable(editable);
    }

    public void setOnlyStatusEnable() {
        this.tfTableTypeName.setEditable(false);
        this.tfTableTypeDescription.setEditable(false);
    }

    @Override
    public void createNew() {
        this.setBean(new ShopTableType());
    }

    @Override
    public boolean delete() {
        try {
            ShopTableType bean2 = (ShopTableType)this.getBean();
            if (bean2 == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTabeTypeForm.2"), Messages.getString("ShopTabeTypeForm.3"));
            if (option != 0) {
                return false;
            }
            ShopTableTypeDAO.getInstance().delete(bean2);
            this.tfTableTypeDescription.setText("");
            this.tfTableTypeName.setText("");
            return true;
        }
        catch (PosException x) {
            DetailsInfoDialog dialog = new DetailsInfoDialog(x.getMessage(), x.getDetails());
            dialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
        }
        return false;
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.updateView();
        this.tfTableTypeName.setEnabled(enable);
        this.tfTableTypeDescription.setEnabled(enable);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            ShopTableType tableType = (ShopTableType)this.getBean();
            ShopTableTypeDAO.getInstance().saveOrUpdate(tableType);
            this.updateView();
            return true;
        }
        catch (IllegalModelStateException tableType) {
        }
        catch (StaleObjectStateException e) {
            BOMessageDialog.showError(this, Messages.getString("ShopTabeTypeForm.4"));
        }
        return false;
    }

    @Override
    protected void updateView() {
        ShopTableType tableType = (ShopTableType)this.getBean();
        if (tableType == null) {
            return;
        }
        this.tfTableTypeName.setText(tableType.getName());
        this.tfTableTypeDescription.setText(tableType.getDescription());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        ShopTableType tableType = (ShopTableType)this.getBean();
        if (tableType == null) {
            tableType = new ShopTableType();
            this.setBean(tableType, false);
        }
        String name = this.tfTableTypeName.getText().trim();
        String description2 = this.tfTableTypeDescription.getText();
        if (StringUtils.isBlank((String)name)) {
            String message = Messages.getString("ShopTableTypeForm.3");
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
            return false;
        }
        tableType.setName(name);
        tableType.setDescription(description2);
        return true;
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("ShopTableTypeForm.0");
    }
}

