/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.dao.FloorplanDAO;
import com.floreantpos.main.Application;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.Store;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSComboBox;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXMonthView;

public class TableBookingForm
extends BeanEditor<BookingInfo>
implements ActionListener {
    private JLabel tables;
    private IntegerTextField txtGuestCount;
    private JXDatePicker tbStartDate;
    private JXDatePicker tbEndDate;
    private POSComboBox cStartHour;
    private POSComboBox cStartMin;
    private POSComboBox cEndHour;
    private POSComboBox cEndMin;
    private PosButton btnSelectCustomer;
    private JTextField txtSelectedCustomer;
    protected String searchParameter;
    protected Date stardDateForSearchBooking;
    protected Date endDateForSearchBooking;
    private Customer customer;
    private final int TF_HEIGHT = 30;
    private final int TB_HEIGHT = 40;
    private final int TB_WIDTH = 40;
    private final int FONT_SIZE = 15;
    private final int COMBO_WIDTH = 100;
    private List<ShopTable> selectedTableList;
    private JLabel lblTotalCapacity;
    private JLabel lblSelectedCapacity;
    private long selectedCapacity = 0L;
    private JPanel tableSelectionPanel;
    private Long totalCapacity;
    private PosButton btnRefresh;
    private ArrayList<ShopTable> removedTableList;
    private Store store;
    private boolean isDetailsMode;

    public TableBookingForm(BookingInfo tableBookingInfo) {
        this(tableBookingInfo, false);
    }

    public TableBookingForm(BookingInfo tableBookingInfo, boolean isDetailsMode) {
        this.isDetailsMode = isDetailsMode;
        this.setPreferredSize(PosUIManager.getSize(800, 550));
        this.initComponents();
        this.initData();
        this.setBean(tableBookingInfo);
        this.updateRefreshButton(false);
    }

    private void initData() {
        this.store = DataProvider.get().getStore();
        this.tables.setText(Messages.getString("TableBookingForm.54"));
        this.tbStartDate.setDate(new Date());
        this.tbEndDate.setDate(new Date());
        this.setStartHour();
        this.cStartMin.setSelectedIndex(0);
        this.cEndMin.setSelectedIndex(0);
        this.txtSelectedCustomer.setText("");
        this.txtGuestCount.setText("2");
    }

    private Long getTotalCapacity() {
        return ShopTableDAO.getInstance().getTotalCapacity(this.getStartDate(), this.getEndDate(), (BookingInfo)this.getBean());
    }

    private void initComponents() {
        this.txtSelectedCustomer = new JTextField();
        this.btnSelectCustomer = new PosButton(Messages.getString("TableBookingForm.25"));
        this.tbStartDate = UiUtil.getCurrentMonthStart();
        this.tbStartDate.setDate(new Date());
        Calendar calendar = this.tbStartDate.getMonthView().getCalendar();
        calendar.setTime(new Date());
        this.tbStartDate.setPreferredSize(PosUIManager.getSize(0, 40));
        JButton btnTbStartDate = (JButton)this.tbStartDate.getComponent(1);
        btnTbStartDate.setPreferredSize(PosUIManager.getSize(40, 0));
        JXMonthView monthViewStartDate = this.tbStartDate.getMonthView();
        monthViewStartDate.setLowerBound(calendar.getTime());
        monthViewStartDate.setFont(new Font(monthViewStartDate.getFont().getName(), 0, 15));
        this.tbStartDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBookingForm.this.tbEndDate.setDate(TableBookingForm.this.tbStartDate.getDate());
            }
        });
        this.tbEndDate = UiUtil.getCurrentMonthEnd();
        this.tbEndDate.setDate(new Date());
        this.tbStartDate.addActionListener((ActionListener)this);
        this.tbEndDate.addActionListener((ActionListener)this);
        this.tbEndDate.setPreferredSize(PosUIManager.getSize(0, 40));
        JButton btnTbEndDate = (JButton)this.tbEndDate.getComponent(1);
        btnTbEndDate.setPreferredSize(PosUIManager.getSize(40, 0));
        JXMonthView monthViewEndDate = this.tbEndDate.getMonthView();
        monthViewEndDate.setLowerBound(calendar.getTime());
        monthViewEndDate.setFont(new Font(monthViewEndDate.getFont().getName(), 0, 15));
        Vector<Integer> hours = new Vector<Integer>();
        for (int i = 0; i <= 23; ++i) {
            hours.add(i);
        }
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout((LayoutManager)new MigLayout("fillx", " [][grow][]", ""));
        JLabel from = new JLabel(Messages.getString("TableBookingForm.0"));
        JLabel startDate = new JLabel(Messages.getString("TableBookingForm.1"));
        JLabel startHours = new JLabel(Messages.getString("TableBookingForm.2"));
        JLabel startMin = new JLabel(Messages.getString("TableBookingForm.3"));
        JLabel to = new JLabel(Messages.getString("TableBookingForm.4"));
        JLabel endDate = new JLabel(Messages.getString("TableBookingForm.5"));
        JLabel endHours = new JLabel(Messages.getString("TableBookingForm.6"));
        JLabel endMin = new JLabel(Messages.getString("TableBookingForm.7"));
        JLabel customer = new JLabel(Messages.getString("TableBookingForm.8"));
        this.tables = new JLabel();
        JLabel guestCount = new JLabel("Guest count");
        this.txtGuestCount = new IntegerTextField();
        this.txtGuestCount.setText(Messages.getString("TableBookingForm.69"));
        this.txtGuestCount.setEditable(false);
        DefaultComboBoxModel<Integer> stMinModel = new DefaultComboBoxModel<Integer>();
        stMinModel.addElement(0);
        stMinModel.addElement(15);
        stMinModel.addElement(30);
        stMinModel.addElement(45);
        DefaultComboBoxModel<Integer> etMinModel = new DefaultComboBoxModel<Integer>();
        etMinModel.addElement(0);
        etMinModel.addElement(15);
        etMinModel.addElement(30);
        etMinModel.addElement(45);
        this.cStartHour = new POSComboBox();
        this.cStartHour.setPreferredSize(PosUIManager.getSize(100, 0));
        this.cStartHour.setModel(new DefaultComboBoxModel(hours));
        this.cStartMin = new POSComboBox();
        this.cStartMin.setPreferredSize(PosUIManager.getSize(100, 0));
        this.cStartMin.setModel(stMinModel);
        this.cEndHour = new POSComboBox();
        this.cEndHour.setPreferredSize(PosUIManager.getSize(100, 0));
        this.cEndHour.setModel(new DefaultComboBoxModel(hours));
        this.cEndHour.setSelectedIndex(1);
        this.cEndMin = new POSComboBox();
        this.cEndMin.setPreferredSize(PosUIManager.getSize(100, 0));
        this.cEndMin.setModel(etMinModel);
        this.cStartHour.addActionListener(this);
        this.cStartMin.addActionListener(this);
        this.cEndHour.addActionListener(this);
        this.cEndMin.addActionListener(this);
        this.cStartHour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer selectedItem = (Integer)TableBookingForm.this.cStartHour.getSelectedItem();
                selectedItem = selectedItem == 23 ? Integer.valueOf(0) : Integer.valueOf(selectedItem + 1);
                TableBookingForm.this.cEndHour.setSelectedItem(selectedItem);
            }
        });
        topPanel.add((Component)from, "right");
        topPanel.add((Component)startDate, "split 6");
        topPanel.add((Component)this.tbStartDate, "gapright 10");
        topPanel.add(startHours);
        topPanel.add((Component)this.cStartHour, "gapright 10");
        topPanel.add(startMin);
        topPanel.add((Component)this.cStartMin, "gapright 10, wrap");
        topPanel.add((Component)to, "right");
        topPanel.add((Component)endDate, "split 6");
        topPanel.add((Component)this.tbEndDate, "gapright 10");
        topPanel.add(endHours);
        topPanel.add((Component)this.cEndHour, "gapright 10");
        topPanel.add(endMin);
        topPanel.add((Component)this.cEndMin, "gapright 10, wrap");
        this.btnSelectCustomer.setPreferredSize(PosUIManager.getSize(0, 30));
        this.txtSelectedCustomer.setPreferredSize(PosUIManager.getSize(0, 30));
        this.txtGuestCount.setPreferredSize(PosUIManager.getSize(0, 30));
        this.txtSelectedCustomer.setEditable(false);
        this.txtGuestCount.addActionListener(this);
        this.txtSelectedCustomer.addActionListener(this);
        PosButton btnGuestCount = new PosButton(Messages.getString("TableBookingForm.75"));
        btnGuestCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBookingForm.this.doSelectGuestCount();
            }
        });
        btnGuestCount.setPreferredSize(PosUIManager.getSize(0, 30));
        topPanel.add((Component)guestCount, "right");
        topPanel.add((Component)this.txtGuestCount, "split 2, grow");
        topPanel.add((Component)btnGuestCount, "wrap");
        topPanel.add((Component)customer, "right");
        topPanel.add((Component)this.txtSelectedCustomer, "split 2, grow");
        topPanel.add((Component)this.btnSelectCustomer, "wrap");
        int fontSize = 18;
        JLabel lblTotalCapTxt = new JLabel(Messages.getString("TableBookingForm.76"));
        Font fontCommon = new Font(lblTotalCapTxt.getFont().getFontName(), 0, PosUIManager.getSize(fontSize));
        lblTotalCapTxt.setFont(fontCommon);
        this.lblTotalCapacity = new JLabel();
        JLabel lblSelCapTxt = new JLabel(Messages.getString("TableBookingForm.79"));
        this.lblSelectedCapacity = new JLabel();
        Font font = new Font(lblSelCapTxt.getFont().getFontName(), 1, PosUIManager.getSize(fontSize));
        this.lblTotalCapacity.setFont(font);
        this.lblSelectedCapacity.setFont(font);
        lblSelCapTxt.setFont(fontCommon);
        topPanel.add((Component)lblTotalCapTxt, "split 5, skip 1");
        topPanel.add((Component)this.lblTotalCapacity, "");
        topPanel.add((Component)lblSelCapTxt, "");
        topPanel.add((Component)this.lblSelectedCapacity, "");
        this.btnRefresh = new PosButton(Messages.getString("TableBookingForm.84"));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBookingForm.this.doRefresh();
            }
        });
        topPanel.add((Component)this.btnRefresh, "gapleft 10, wrap");
        this.add((Component)topPanel, "North");
        PosScrollPane jScrollPane = new PosScrollPane(this.createTableSelectionPanel());
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createTitledBorder(null, Messages.getString("TableBookingForm.86"), 4, 0)));
        this.add((Component)jScrollPane, "Center");
        this.initActionHandlers();
    }

    protected void doRefresh() {
        try {
            Component[] components;
            if (this.tbStartDate.getDate() == null || this.tbEndDate.getDate() == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.30"));
                return;
            }
            Date clStartDate = this.getStartDate();
            Date clEndDate = this.getEndDate();
            if (clStartDate.getTime() < this.getTodaysDateTime()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.31"));
                return;
            }
            if (clStartDate.getTime() > clEndDate.getTime()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.32"));
                return;
            }
            if (this.txtGuestCount.getText().equals("")) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.88"));
                return;
            }
            List<ShopTable> bookedTableList = this.setTotalCapacity();
            for (Component component : components = this.tableSelectionPanel.getComponents()) {
                if (!(component instanceof TableButton)) continue;
                TableButton tableButton = (TableButton)component;
                tableButton.setSelected(false);
            }
            this.selectedTableList.clear();
            this.selectedCapacity = 0L;
            this.lblSelectedCapacity.setText(this.selectedCapacity + "");
            BookingInfo bookingInfo = (BookingInfo)this.getBean();
            for (Component component : components) {
                if (!(component instanceof TableButton)) continue;
                TableButton tableButton = (TableButton)component;
                ShopTable shopTable = tableButton.getTable();
                if (bookedTableList.contains(shopTable)) {
                    if (bookingInfo.getId() != null && bookingInfo.getTables().contains(shopTable) && this.isContain(bookingInfo)) {
                        tableButton.setSelected(false);
                        this.updateButtonView(tableButton, shopTable);
                        continue;
                    }
                    this.setButtonStatusBooked(tableButton, shopTable);
                    continue;
                }
                this.updateButtonView(tableButton, shopTable);
            }
            this.selectedTableList.clear();
            this.selectedCapacity = 0L;
            this.lblSelectedCapacity.setText(this.selectedCapacity + "");
            this.updateRefreshButton(false);
            if (bookingInfo != null && bookingInfo.getTables() != null && !bookingInfo.getTables().isEmpty()) {
                Collection commonBookedTables = CollectionUtils.intersection(bookedTableList, bookingInfo.getTables());
                if (commonBookedTables != null && !commonBookedTables.isEmpty()) {
                    List tablesToSelect = (List)CollectionUtils.subtract(bookingInfo.getTables(), (Collection)commonBookedTables);
                    if (tablesToSelect != null && !tablesToSelect.isEmpty()) {
                        this.doSelectTables(components, tablesToSelect);
                    } else if (this.isContain(bookingInfo)) {
                        this.doSelectTables(components, bookingInfo.getTables());
                    }
                } else {
                    this.doSelectTables(components, bookingInfo.getTables());
                }
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doSelectTables(Component[] components, List<ShopTable> tables) {
        this.selectedCapacity = 0L;
        for (Component component : components) {
            if (!(component instanceof TableButton)) continue;
            TableButton tableButton = (TableButton)component;
            ShopTable shopTable = tableButton.getTable();
            for (ShopTable shopTable2 : tables) {
                if (!shopTable.getId().equals(shopTable2.getId())) continue;
                tableButton.setSelected(true);
                this.selectedCapacity += (long)shopTable2.getCapacity().intValue();
                this.selectedTableList.add(shopTable);
            }
        }
        this.lblSelectedCapacity.setText(this.selectedCapacity + "");
    }

    private List<ShopTable> setTotalCapacity() {
        return this.setTotalCapacity(false);
    }

    private List<ShopTable> setTotalCapacity(boolean isUpdate) {
        List<ShopTable> bookedTableList = FloorplanDAO.getInstance().getAllBookedTablesByDate(this.getStartDate(), this.getEndDate());
        this.totalCapacity = this.getTotalCapacity();
        this.selectedCapacity = this.getSelectedCapacity();
        BookingInfo bookingInfo = (BookingInfo)this.getBean();
        if (this.selectedCapacity == 0L && !bookedTableList.isEmpty() && bookingInfo.getTables() != null && !bookingInfo.getTables().isEmpty()) {
            for (ShopTable shopTable : bookingInfo.getTables()) {
                this.selectedCapacity += (long)shopTable.getCapacity().intValue();
            }
        }
        this.lblTotalCapacity.setText(this.totalCapacity + ",");
        this.lblSelectedCapacity.setText(this.selectedCapacity + "");
        return bookedTableList;
    }

    private JPanel createTableSelectionPanel() {
        this.tableSelectionPanel = new JPanel(new WrapLayout(3));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        List<ShopTable> shopTables = ShopTableDAO.getInstance().findReservableTables();
        if (shopTables == null || shopTables.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.94"));
        }
        this.selectedTableList = new ArrayList<ShopTable>();
        this.removedTableList = new ArrayList();
        for (ShopTable shopTable : shopTables) {
            if (shopTable.getFloorId() == null) continue;
            ShopTableDAO.getInstance().initializeTypes(shopTable);
            TableButton tableButton = new TableButton(shopTable);
            this.tableSelectionPanel.add(tableButton);
        }
        return this.tableSelectionPanel;
    }

    public void initActionHandlers() {
        this.btnSelectCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBookingForm.this.addCustomerToBooking();
            }
        });
    }

    private void setStartHour() {
        Calendar cal = Calendar.getInstance();
        int hourOfTheDay = cal.get(11);
        int setHour = hourOfTheDay + 1;
        this.cStartHour.setSelectedItem(setHour);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            BookingInfo bookingInfo = (BookingInfo)this.getBean();
            BookingInfoDAO.getInstance().saveOrUpdate(bookingInfo);
            boolean isTableStatusUpdated = FloorplanDAO.getInstance().updateBookingStatus();
            if (isTableStatusUpdated) {
                OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "1");
            }
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("TableBookingForm.20"));
            return false;
        }
    }

    @Override
    protected void updateView() {
        try {
            Integer hour;
            BookingInfo bookingInfo = (BookingInfo)this.getBean();
            if (bookingInfo == null) {
                return;
            }
            if (bookingInfo.getId() == null) {
                this.doRefresh();
                return;
            }
            this.txtGuestCount.setText(bookingInfo.getGuestCount().toString());
            this.customer = bookingInfo.getCustomer();
            if (this.customer != null) {
                this.txtSelectedCustomer.setText(this.customer.toString());
            }
            if (bookingInfo.getTables() != null) {
                this.selectedTableList.addAll(bookingInfo.getTables());
            }
            if (bookingInfo.getFromDate() != null) {
                Calendar startCalendar = Calendar.getInstance();
                startCalendar.setTime(bookingInfo.getFromDate());
                this.tbStartDate.setDate(startCalendar.getTime());
                hour = startCalendar.get(11);
                this.cStartHour.setSelectedItem(hour);
                this.cStartMin.setSelectedItem(startCalendar.get(12));
            }
            if (bookingInfo.getToDate() != null) {
                Calendar endCalendar = Calendar.getInstance();
                endCalendar.setTime(bookingInfo.getToDate());
                this.tbEndDate.setDate(endCalendar.getTime());
                hour = endCalendar.get(11);
                this.cEndHour.setSelectedItem(hour);
                this.cEndMin.setSelectedItem(endCalendar.get(12));
            }
            if (this.customer == null) {
                this.txtSelectedCustomer.setText("");
            } else {
                this.txtSelectedCustomer.setText(this.customer.toString());
            }
            this.updateButton();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Collection commonTables;
        BookingInfo objTableBooking = (BookingInfo)this.getBean();
        if (this.tbStartDate.getDate() == null || this.tbEndDate.getDate() == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.30"));
            return false;
        }
        Date clStartDate = this.getStartDate();
        Date clEndDate = this.getEndDate();
        if (clStartDate.getTime() < this.getTodaysDateTime()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.31"));
            return false;
        }
        if (clStartDate.getTime() >= clEndDate.getTime()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.32"));
            return false;
        }
        if (this.txtGuestCount.getText().equals("")) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.96"));
            return false;
        }
        List<ShopTable> bookedTableList = FloorplanDAO.getInstance().getAllBookedTablesByDate(this.getStartDate(), this.getEndDate());
        boolean isContain = false;
        List<BookingInfo> bookingInfoByDate = BookingInfoDAO.getInstance().getAllBookingInfoByDate(this.getStartDate(), this.getEndDate());
        for (BookingInfo bookingInfo2 : bookingInfoByDate) {
            if (!objTableBooking.equals(bookingInfo2)) continue;
            isContain = true;
            break;
        }
        if (!(commonTables = CollectionUtils.intersection(this.selectedTableList, bookedTableList)).isEmpty() && commonTables != null && !isContain) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.97"));
            return false;
        }
        if (clStartDate == null || clEndDate == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("TableBookingForm.73"));
            return false;
        }
        Integer startHour = (Integer)this.cStartHour.getSelectedItem();
        Integer startMin = (Integer)this.cStartMin.getSelectedItem();
        Integer endHour = (Integer)this.cEndHour.getSelectedItem();
        Integer endMin = (Integer)this.cEndMin.getSelectedItem();
        if (this.txtGuestCount.getText().isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.98"));
            return false;
        }
        int guest = Integer.parseInt(this.txtGuestCount.getText());
        if (guest == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.99"));
            return false;
        }
        boolean isTotalCapacityChecked = false;
        if (this.totalCapacity < (long)guest) {
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.100"), Messages.getString("TableBookingForm.101"));
            if (option != 0) {
                return false;
            }
            isTotalCapacityChecked = true;
        }
        int maxCapacity = 0;
        int minCapacity = 0;
        if (this.selectedTableList != null && this.selectedTableList.size() != 0 && !isTotalCapacityChecked) {
            int option;
            for (ShopTable shopTable : this.selectedTableList) {
                maxCapacity += shopTable.getCapacity().intValue();
                minCapacity += shopTable.getMinCapacity().intValue();
            }
            if (maxCapacity < guest && (option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.102"), Messages.getString("TableBookingForm.101"))) != 0) {
                return false;
            }
            if (minCapacity > guest && (option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.104"), Messages.getString("TableBookingForm.101"))) != 0) {
                return false;
            }
        }
        objTableBooking.setStartHour(startHour);
        objTableBooking.setStartMin(startMin);
        objTableBooking.setEndHour(endHour);
        objTableBooking.setEndMin(endMin);
        objTableBooking.setFromDate(this.getStartDate());
        objTableBooking.setToDate(this.getEndDate());
        objTableBooking.setGuestCount(guest);
        String customerName = this.txtSelectedCustomer.getText();
        if (!customerName.equals("")) {
            objTableBooking.setCustomer(this.getCustomer());
        }
        if (objTableBooking.getStatus() == null) {
            objTableBooking.setStatus("open");
        }
        objTableBooking.setUser(Application.getCurrentUser());
        objTableBooking.setTables(this.selectedTableList);
        if (objTableBooking.getBookingId() == null) {
            this.doSetBookingId(objTableBooking);
        }
        return true;
    }

    private void doSetBookingId(BookingInfo objTableBooking) {
        try {
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            int month = calendar.get(2);
            int day = calendar.get(5);
            Random random = new Random();
            String randomCharacter = String.format("%04d", random.nextInt(10000));
            String bookingId = year % 100 + "" + (month < 10 ? "0" : "") + month + "" + (day < 10 ? "0" : "") + day + "" + randomCharacter;
            boolean isFound = true;
            while (isFound) {
                BookingInfo bookingInfo = BookingInfoDAO.getInstance().get(bookingId);
                if (bookingInfo == null) {
                    isFound = false;
                    break;
                }
                randomCharacter = RandomStringUtils.randomAlphabetic((int)4);
                bookingId = year + month + day + randomCharacter;
            }
            objTableBooking.setBookingId(bookingId);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private Date getStartDate() {
        if (this.tbStartDate.getDate() == null) {
            return null;
        }
        Calendar clStartDate = Calendar.getInstance();
        clStartDate.setTime(this.tbStartDate.getDate());
        Integer hour = (Integer)this.cStartHour.getSelectedItem();
        clStartDate.set(10, hour);
        clStartDate.set(12, (Integer)this.cStartMin.getSelectedItem());
        return clStartDate.getTime();
    }

    private Date getEndDate() {
        if (this.tbEndDate.getDate() == null) {
            return null;
        }
        Calendar clEndDate = Calendar.getInstance();
        clEndDate.setTime(this.tbEndDate.getDate());
        Integer hour = (Integer)this.cEndHour.getSelectedItem();
        clEndDate.set(10, hour);
        clEndDate.set(12, (Integer)this.cEndMin.getSelectedItem());
        return clEndDate.getTime();
    }

    private long getTodaysDateTime() {
        Calendar startDate = Calendar.getInstance();
        startDate.setLenient(false);
        startDate.setTime(new Date());
        return startDate.getTime().getTime();
    }

    @Override
    public void cancel() {
        this.tables.setText(Messages.getString("TableBookingForm.10"));
    }

    @Override
    public void clearFields() {
        this.txtGuestCount.setText("0");
        this.tbStartDate.setDate(new Date());
        this.tbEndDate.setDate(new Date());
        this.cEndHour.setSelectedIndex(1);
        this.setStartHour();
        this.cStartMin.setSelectedIndex(0);
        this.cEndMin.setSelectedIndex(0);
        this.txtSelectedCustomer.setText("");
    }

    @Override
    public String getDisplayText() {
        BookingInfo bookingInfo = (BookingInfo)this.getBean();
        if (bookingInfo == null || bookingInfo.getId() == null) {
            return Messages.getString("TableBookingForm.116");
        }
        if (this.isDetailsMode) {
            return Messages.getString("TableBookingForm.117") + bookingInfo.getBookingId();
        }
        return Messages.getString("TableBookingForm.118") + bookingInfo.getBookingId();
    }

    @Override
    public void edit() {
        BookingInfo bookingInfo = (BookingInfo)this.getBean();
        if (bookingInfo == null) {
            return;
        }
        List<ShopTable> tables = bookingInfo.getTables();
        if (tables == null || tables.size() == 0) {
            return;
        }
    }

    private void addCustomerToBooking() {
        CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(Application.getInstance().getCurrentOrderType());
        dialog.setCreateNewTicket(false);
        dialog.updateView(true);
        dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        dialog.setSize(PosUIManager.getSize(1020, 650));
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        Customer customer = dialog.getSelectedCustomer();
        if (customer != null) {
            this.setCustomer(customer);
        }
    }

    public void setCustomer(Customer customer) {
        String lastName;
        String firstName = !customer.getFirstName().isEmpty() ? customer.getFirstName() : "";
        String string = lastName = !customer.getLastName().isEmpty() ? customer.getLastName() : "";
        if (!firstName.isEmpty() || !lastName.isEmpty()) {
            this.txtSelectedCustomer.setText(firstName + "" + lastName);
        } else if (!customer.getMobileNo().isEmpty()) {
            this.txtSelectedCustomer.setText(customer.getMobileNo());
        } else {
            this.txtSelectedCustomer.setText(customer.getLoyaltyNo());
        }
        this.customer = customer;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    private void updateButton() {
        List<ShopTable> bookedTableList = this.setTotalCapacity(true);
        Component[] components = this.tableSelectionPanel.getComponents();
        BookingInfo bookingInfo = (BookingInfo)this.getBean();
        boolean isContain = false;
        List<BookingInfo> bookingInfoByDate = BookingInfoDAO.getInstance().getAllBookingInfoByDate(this.getStartDate(), this.getEndDate());
        for (BookingInfo bookingInfo2 : bookingInfoByDate) {
            if (!bookingInfo.equals(bookingInfo2)) continue;
            isContain = true;
            break;
        }
        for (Component component : components) {
            if (!(component instanceof TableButton)) continue;
            TableButton tableButton = (TableButton)component;
            ShopTable shopTable = tableButton.getTable();
            if (bookedTableList.contains(shopTable)) {
                if (bookingInfo.getId() != null && bookingInfo.getTables().contains(shopTable) && isContain) {
                    tableButton.setSelected(true);
                    this.updateButtonView(tableButton, shopTable);
                    continue;
                }
                this.setButtonStatusBooked(tableButton, shopTable);
                continue;
            }
            this.updateButtonView(tableButton, shopTable);
        }
    }

    private void updateButtonView(TableButton tableButton, ShopTable shopTable) {
        try {
            TableStatus tableStatus;
            String tableType = StringUtils.isNotEmpty((String)shopTable.getTypesAsString()) ? "<br/>Type: " + shopTable.getTypesAsString() + "" : "";
            int priSize = PosUIManager.getSize(this.store.getTablePrimaryFontSize());
            int secSize = PosUIManager.getSize(this.store.getTableSecondaryFontSize());
            String text = "<div style='font-size:" + priSize + "px;'>" + shopTable.getTableNumber() + "</div>";
            Color freeForeColor = this.store.getTableFreeForeColor();
            Color freeBgColor = this.store.getTableFreeBGColor();
            ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
            if (shopTableStatus == null) {
                return;
            }
            String seatTimeStr = shopTableStatus.getProperty("seat.time");
            boolean isTimeOver = false;
            if (StringUtils.isNotEmpty((String)seatTimeStr)) {
                Date seatTime = ShopTable.bookingDateFormat.parse(seatTimeStr);
                long diffInMillies = Math.abs(this.getStartDate().getTime() - seatTime.getTime());
                long diff = TimeUnit.HOURS.convert(diffInMillies, TimeUnit.MILLISECONDS);
                if (diff >= 1L) {
                    isTimeOver = true;
                }
            }
            if ((tableStatus = shopTable.getTableStatus()).equals((Object)TableStatus.Serving)) {
                long diffInMillies;
                long diff;
                Date lastTicketCreateTime = shopTableStatus.getLastTicketCreateTime();
                if (lastTicketCreateTime != null && (diff = TimeUnit.HOURS.convert(diffInMillies = Math.abs(this.getStartDate().getTime() - lastTicketCreateTime.getTime()), TimeUnit.MILLISECONDS)) >= 1L) {
                    isTimeOver = true;
                }
                if (isTimeOver) {
                    tableButton.setBackground(freeBgColor);
                    tableButton.setForeground(freeForeColor);
                }
            } else if (tableStatus.equals((Object)TableStatus.Available)) {
                tableButton.setBackground(freeBgColor);
                tableButton.setForeground(freeForeColor);
            } else {
                tableButton.setBackground(freeBgColor);
                tableButton.setForeground(freeForeColor);
            }
            if (tableButton.isSelected()) {
                tableButton.setBackground(Color.GREEN);
                tableButton.setForeground(Color.BLACK);
                text = text + "<div style='font-size:" + secSize + "px; color:black;'>" + shopTable.getShopTableStatus().getTableStatus().name() + "</div>";
            } else {
                tableButton.setBackground(freeBgColor);
                tableButton.setForeground(freeForeColor);
                text = text + "<div style='font-size:" + secSize + "px; color:red;'>" + shopTable.getShopTableStatus().getTableStatus().name() + "</div>";
            }
            tableButton.setText("<html><body><center>" + text + Messages.getString("TableBookingForm.161") + shopTable.getMinCapacity() + "<br/>Max: " + shopTable.getCapacity() + tableType + "</center></body></html>");
            tableButton.setEnabled(true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void setButtonStatusBooked(TableButton tableButton, ShopTable shopTable) {
        String tableType = StringUtils.isNotEmpty((String)shopTable.getTypesAsString()) ? "<br/>Type: " + shopTable.getTypesAsString() + "" : "";
        int priSize = PosUIManager.getSize(DataProvider.get().getStore().getTablePrimaryFontSize());
        String text = "<div style='font-size:" + priSize + "px;'>" + shopTable.getTableNumber() + "</div>";
        tableButton.setText("<html><body><center>" + text + Messages.getString("TableBookingForm.171") + shopTable.getMinCapacity() + "<br/>Max: " + shopTable.getCapacity() + tableType + "<br/>Booked</center></body></html>");
        tableButton.setEnabled(false);
    }

    private int getSelectedCapacity() {
        int selectedCapacity = 0;
        if (this.selectedTableList == null || this.selectedTableList.isEmpty()) {
            return selectedCapacity;
        }
        for (ShopTable shopTable : this.selectedTableList) {
            selectedCapacity += shopTable.getCapacity().intValue();
        }
        return selectedCapacity;
    }

    private void updateRefreshButton(boolean isUpdate) {
        if (this.btnRefresh == null) {
            return;
        }
        if (isUpdate) {
            this.btnRefresh.setBackground(Color.YELLOW);
        } else {
            this.btnRefresh.setBackground(this.getBackground());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateRefreshButton(true);
    }

    private void doSelectGuestCount() {
        try {
            NumberSelectionDialog2 dialog = new NumberSelectionDialog2();
            dialog.setTitle(Messages.getString("TableBookingForm.174"));
            dialog.setFloatingPoint(false);
            dialog.setValue(this.txtGuestCount.getInteger());
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            int guestCount = (int)dialog.getValue();
            this.txtGuestCount.setText(String.valueOf(guestCount));
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private boolean isContain(BookingInfo bookingInfo) {
        boolean isContain = false;
        List<BookingInfo> bookingInfoByDate = BookingInfoDAO.getInstance().getAllBookingInfoByDate(this.getStartDate(), this.getEndDate());
        for (BookingInfo bookingInfo2 : bookingInfoByDate) {
            if (!bookingInfo.equals(bookingInfo2)) continue;
            isContain = true;
            break;
        }
        return isContain;
    }

    private class TableButton
    extends POSToggleButton
    implements ActionListener {
        private ShopTable table;

        TableButton(ShopTable table) {
            this.table = table;
            this.setBorder(null);
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            this.setFont(this.getFont().deriveFont(1, PosUIManager.getFontSize(12)));
            int priSize = PosUIManager.getSize(DataProvider.get().getStore().getTablePrimaryFontSize());
            String text = "<div style='font-size:" + priSize + "px;'>" + table.getTableNumber() + "</div>";
            String tableType = StringUtils.isNotEmpty((String)table.getTypesAsString()) ? "<br/>Type: " + table.getTypesAsString() + "" : "";
            this.setText("<html><body><center>" + text + "Min: " + table.getMinCapacity() + "<br/>Max: " + table.getCapacity() + tableType + "</center></body></html>");
            this.setPreferredSize(PosUIManager.getSize(120, 120));
            this.addActionListener(this);
        }

        public ShopTable getTable() {
            return this.table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                POSToggleButton button = (POSToggleButton)e.getSource();
                Store store = DataProvider.get().getStore();
                Color freeForeColor = store.getTableFreeForeColor();
                Color freeBgColor = store.getTableFreeBGColor();
                int priSize = PosUIManager.getSize(store.getTablePrimaryFontSize());
                int secSize = PosUIManager.getSize(store.getTableSecondaryFontSize());
                String tableType = StringUtils.isNotEmpty((String)this.table.getTypesAsString()) ? "<br/>Type: " + this.table.getTypesAsString() + "" : "";
                String text = "<div style='font-size:" + priSize + "px;'>" + this.table.getTableNumber() + "</div>";
                if (button.isSelected()) {
                    if (TableBookingForm.this.selectedTableList.contains(this.table)) {
                        return;
                    }
                    this.setBackground(Color.GREEN);
                    this.setForeground(Color.BLACK);
                    text = text + "<div style='font-size:" + secSize + "px; color:black;'>" + this.table.getShopTableStatus().getTableStatus().name() + "</div>";
                    TableBookingForm.this.selectedTableList.add(this.table);
                    TableBookingForm.this.removedTableList.remove(this.table);
                    TableBookingForm.this.selectedCapacity = TableBookingForm.this.selectedCapacity + (long)this.table.getCapacity().intValue();
                    TableBookingForm.this.lblSelectedCapacity.setText(TableBookingForm.this.selectedCapacity + "");
                } else {
                    this.setBackground(freeBgColor);
                    this.setForeground(freeForeColor);
                    text = text + "<div style='font-size:" + secSize + "px; color:red;'>" + this.table.getShopTableStatus().getTableStatus().name() + "</div>";
                    TableBookingForm.this.selectedTableList.remove(this.table);
                    if (!TableBookingForm.this.removedTableList.contains(this.table)) {
                        TableBookingForm.this.removedTableList.add(this.table);
                    }
                    TableBookingForm.this.selectedCapacity = TableBookingForm.this.selectedCapacity - (long)this.table.getCapacity().intValue();
                    TableBookingForm.this.lblSelectedCapacity.setText(TableBookingForm.this.selectedCapacity + "");
                }
                button.setText("<html><body><center>" + text + Messages.getString("TableBookingForm.144") + this.table.getMinCapacity() + "<br/>Max: " + this.table.getCapacity() + tableType + "</center></body></html>");
            }
            catch (Exception e2) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
            }
        }
    }
}

