/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui.booking;

import com.floreantpos.customer.CustomerListTableModel;
import com.floreantpos.customer.CustomerTable;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.ui.booking.BookingCustomerSelectionDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.forms.CustomerForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class BookingCustomerSelectionView
extends JPanel {
    private PosSmallButton btnCreateNewCustomer;
    private CustomerTable customerTable;
    private POSTextField tfMobile;
    private POSTextField tfLoyaltyNo;
    private POSTextField tfName;
    private PosSmallButton btnInfo;
    protected Customer selectedCustomer;
    private BookingCustomerSelectionDialog deliverySelectionDialog;

    public BookingCustomerSelectionView() {
        this.createUI();
    }

    public BookingCustomerSelectionView(BookingCustomerSelectionDialog deliverySelectionDialog) {
        this.deliverySelectionDialog = deliverySelectionDialog;
        this.createUI();
    }

    private void createUI() {
        this.setPreferredSize(new Dimension(690, 553));
        this.setLayout((LayoutManager)new MigLayout("", "[549px,grow]", "[grow][][shrink 0,fill][grow][grow]"));
        JPanel panel_4 = new JPanel();
        panel_4.setBorder(new TitledBorder(null, "OroCust 0.7", 4, 2, null, null));
        this.add((Component)panel_4, "cell 0 0,grow");
        panel_4.setLayout((LayoutManager)new MigLayout("", "[grow][][][]", "[grow][][][]"));
        JLabel lblNewLabel = new JLabel("");
        panel_4.add((Component)lblNewLabel, "cell 0 0 1 3,grow");
        JLabel lblByPhone = new JLabel(Messages.getString("BookingCustomerSelectionView.10"));
        panel_4.add((Component)lblByPhone, "cell 1 0");
        this.tfMobile = new POSTextField();
        panel_4.add((Component)this.tfMobile, "cell 2 0");
        this.tfMobile.setColumns(16);
        PosSmallButton psmlbtnSearch = new PosSmallButton();
        panel_4.add((Component)psmlbtnSearch, "cell 3 0 1 3,growy");
        psmlbtnSearch.setFocusable(false);
        psmlbtnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookingCustomerSelectionView.this.searchCustomer();
            }
        });
        psmlbtnSearch.setText(Messages.getString("BookingCustomerSelectionView.14"));
        JLabel lblByName = new JLabel(Messages.getString("BookingCustomerSelectionView.15"));
        panel_4.add((Component)lblByName, "cell 1 1,alignx trailing");
        this.tfLoyaltyNo = new POSTextField();
        panel_4.add((Component)this.tfLoyaltyNo, "cell 2 1");
        this.tfLoyaltyNo.setColumns(16);
        JLabel lblByEmail = new JLabel(Messages.getString("BookingCustomerSelectionView.18"));
        panel_4.add((Component)lblByEmail, "cell 1 2,alignx trailing");
        this.tfName = new POSTextField();
        panel_4.add((Component)this.tfName, "cell 2 2");
        this.tfName.setColumns(16);
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new EmptyBorder(10, 0, 0, 0));
        panel_4.add((Component)panel_2, "cell 0 3 4 1,growx");
        panel_2.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setFocusable(false);
        panel_2.add((Component)scrollPane, "Center");
        this.customerTable = new CustomerTable();
        this.customerTable.setModel(new CustomerListTableModel());
        this.customerTable.setFocusable(false);
        this.customerTable.setRowHeight(35);
        this.customerTable.getSelectionModel().setSelectionMode(0);
        this.customerTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BookingCustomerSelectionView.this.selectedCustomer = BookingCustomerSelectionView.this.customerTable.getSelectedCustomer();
                if (BookingCustomerSelectionView.this.selectedCustomer == null) {
                    BookingCustomerSelectionView.this.btnInfo.setEnabled(false);
                }
            }
        });
        scrollPane.setViewportView(this.customerTable);
        JPanel panel = new JPanel();
        panel_2.add((Component)panel, "South");
        this.btnInfo = new PosSmallButton();
        this.btnInfo.setFocusable(false);
        panel.add(this.btnInfo);
        this.btnInfo.setEnabled(false);
        this.btnInfo.setText(Messages.getString("BookingCustomerSelectionView.22"));
        PosSmallButton btnHistory = new PosSmallButton();
        btnHistory.setEnabled(false);
        btnHistory.setText(Messages.getString("BookingCustomerSelectionView.23"));
        panel.add(btnHistory);
        this.btnCreateNewCustomer = new PosSmallButton();
        this.btnCreateNewCustomer.setFocusable(false);
        panel.add(this.btnCreateNewCustomer);
        this.btnCreateNewCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookingCustomerSelectionView.this.createNewCustomer();
            }
        });
        this.btnCreateNewCustomer.setText(Messages.getString("BookingCustomerSelectionView.24"));
        PosSmallButton btnCancel = new PosSmallButton();
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookingCustomerSelectionView.this.deliverySelectionDialog.setCanceled(true);
                BookingCustomerSelectionView.this.deliverySelectionDialog.dispose();
            }
        });
        btnCancel.setText(Messages.getString("BookingCustomerSelectionView.25"));
        panel.add(btnCancel);
        PosSmallButton btnSelect = new PosSmallButton();
        btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BookingCustomerSelectionView.this.getCustomer() != null) {
                    BookingCustomerSelectionView.this.deliverySelectionDialog.getBookingInfo().setCustomer(BookingCustomerSelectionView.this.getCustomer());
                }
                BookingCustomerSelectionView.this.deliverySelectionDialog.setCanceled(true);
                BookingCustomerSelectionView.this.deliverySelectionDialog.dispose();
            }
        });
        btnSelect.setText(Messages.getString("BookingCustomerSelectionView.26"));
        panel.add(btnSelect);
        JPanel panel_3 = new JPanel(new BorderLayout());
        this.add((Component)panel_3, "cell 0 1,grow, gapright 2px");
        QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        panel_3.add((Component)((Object)qwertyKeyPad));
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookingCustomerSelectionView.this.searchCustomer();
            }
        });
        this.tfLoyaltyNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookingCustomerSelectionView.this.searchCustomer();
            }
        });
        this.tfMobile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookingCustomerSelectionView.this.searchCustomer();
            }
        });
    }

    protected void searchCustomer() {
        String mobile = this.tfMobile.getText();
        String name = this.tfName.getText();
        String loyalty = this.tfLoyaltyNo.getText();
        if (StringUtils.isEmpty((String)mobile) && StringUtils.isEmpty((String)loyalty) && StringUtils.isEmpty((String)name)) {
            List<Customer> list = CustomerDAO.getInstance().findAll();
            this.customerTable.setModel(new CustomerListTableModel(list));
            return;
        }
        List<Customer> list = CustomerDAO.getInstance().findBy(mobile, loyalty, name);
        this.customerTable.setModel(new CustomerListTableModel(list));
    }

    protected void createNewCustomer() {
        boolean setKeyPad = true;
        CustomerForm form = new CustomerForm(setKeyPad);
        form.enableCustomerFields(true);
        BeanEditorDialog dialog = new BeanEditorDialog(form);
        dialog.open();
        if (!dialog.isCanceled()) {
            this.selectedCustomer = (Customer)form.getBean();
            this.customerTable.setModel(new CustomerListTableModel(Arrays.asList(this.selectedCustomer)));
        }
    }

    public Customer getCustomer() {
        return this.selectedCustomer;
    }
}

