/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui.booking;

import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.dao.FloorplanDAO;
import com.floreantpos.floorplan.ui.booking.BookingTableSelectionDialog;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ImageComponent;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class BookingTableSelectionFloorView
extends JPanel {
    private BookingTableSelectionDialog dialog;
    private ShopFloor shopFloor;
    private JLayeredPane floorPanel;
    private List<ShopTable> addedTableListModel = new ArrayList<ShopTable>();
    private List<ShopTable> releasedListModel = new ArrayList<ShopTable>();
    private List<ShopTable> tables;
    private int totalCapacity;
    private Store store;

    public BookingTableSelectionFloorView(BookingTableSelectionDialog dialog, ShopFloor shopFloor) {
        this.dialog = dialog;
        this.shopFloor = shopFloor;
        this.store = DataProvider.get().getStore();
        this.setLayout(new BorderLayout(10, 10));
        this.createLayoutPanel();
        this.setFloorBackground();
    }

    private void createLayoutPanel() {
        this.floorPanel = new JLayeredPane();
        this.floorPanel.setOpaque(true);
        this.floorPanel.setBackground(Color.white);
        this.floorPanel.setAutoscrolls(true);
        this.add((Component)this.floorPanel, "Center");
    }

    private void setFloorBackground() {
        ImageIcon image = this.shopFloor.getImage();
        ImageComponent imageComponent = null;
        Dimension floorSize = this.shopFloor.getFloorSize();
        this.floorPanel.setPreferredSize(floorSize);
        this.floorPanel.setOpaque(true);
        if (image != null) {
            imageComponent = new ImageComponent();
            imageComponent.setImage(image.getImage());
            imageComponent.setBounds(0, 0, (int)floorSize.getWidth(), (int)floorSize.getHeight());
            this.floorPanel.add(imageComponent);
            if (this.hasBackgroundColor()) {
                this.floorPanel.setBackground(this.shopFloor.getBackgroundColor());
            } else {
                this.floorPanel.setBackground(Color.WHITE);
            }
        } else if (this.hasBackgroundColor()) {
            this.floorPanel.setBackground(this.shopFloor.getBackgroundColor());
        } else {
            this.floorPanel.setBackground(Color.WHITE);
        }
    }

    private boolean hasBackgroundColor() {
        Color color = this.shopFloor.getBackgroundColor();
        return color != null;
    }

    public void renderFloor() {
        if (this.shopFloor == null) {
            return;
        }
        this.renderTables();
        this.updateView();
    }

    private void renderTables() {
        this.floorPanel.removeAll();
        this.addedTableListModel.clear();
        this.tables = ShopTableDAO.getInstance().getByFloor(this.shopFloor);
        if (this.tables == null || this.tables.isEmpty()) {
            return;
        }
        int btnHeight = PosUIManager.getSize(this.store.getTableBtnHeight());
        int btnWidth = PosUIManager.getSize(this.store.getTableBtnWidth());
        this.doSortTables(this.tables);
        for (ShopTable shopTable : this.tables) {
            TableButton tableButton = new TableButton(shopTable);
            tableButton.setBounds(shopTable.getX(), shopTable.getY(), btnWidth, btnHeight);
            this.floorPanel.add(tableButton);
        }
        this.floorPanel.revalidate();
        this.floorPanel.repaint();
        this.revalidate();
        this.repaint();
    }

    private void doSortTables(List<ShopTable> tables) {
        Collections.sort(tables, new Comparator<ShopTable>(){

            @Override
            public int compare(ShopTable lhs, ShopTable rhs) {
                return lhs.getId().compareTo(rhs.getId());
            }
        });
    }

    public List<ShopTable> getSelectedTables() {
        return this.addedTableListModel;
    }

    public void updateView() {
        List<ShopTable> bookedTableList = FloorplanDAO.getInstance().getAllBookedTablesByDate(this.dialog.getStartDate(), this.dialog.getEndDate());
        Component[] components = this.floorPanel.getComponents();
        List<ShopTable> selectedTables = this.dialog.getSelectedTables();
        Color freeForeColor = this.store.getTableFreeForeColor();
        Color freeBgColor = this.store.getTableFreeBGColor();
        for (Component component : components) {
            if (!(component instanceof TableButton)) continue;
            TableButton tableButton = (TableButton)component;
            ShopTable shopTable = tableButton.getTable();
            if (selectedTables != null && selectedTables.contains(shopTable)) {
                if (!this.addedTableListModel.contains(shopTable)) {
                    this.addedTableListModel.add(shopTable);
                }
                tableButton.setSelected(true);
            }
            int priSize = PosUIManager.getSize(this.store.getTablePrimaryFontSize());
            int secSize = PosUIManager.getSize(this.store.getTableSecondaryFontSize());
            String text = "<div style='font-size:" + priSize + "px;'>" + shopTable.getTableNumber() + "</div>";
            if (tableButton.isSelected()) {
                tableButton.setBackground(Color.GREEN);
                tableButton.setForeground(Color.black);
                text = text + "<div style='font-size:" + secSize + "px; color:black;'>" + shopTable.getShopTableStatus().getTableStatus().name() + "</div>";
            } else {
                tableButton.setBackground(freeBgColor);
                tableButton.setForeground(freeForeColor);
                text = text + "<div style='font-size:" + secSize + "px; color:red;'>" + shopTable.getShopTableStatus().getTableStatus().name() + "</div>";
            }
            if (bookedTableList.contains(shopTable) && !this.addedTableListModel.contains(shopTable) && !this.releasedListModel.contains(shopTable)) {
                tableButton.setText("<html><body><center>" + text + Messages.getString("BookingTableSelectionFloorView.27") + shopTable.getCapacity() + "<br/>Booked</center></body></html>");
                tableButton.setEnabled(false);
                continue;
            }
            tableButton.setText("<html><body><center>" + text + Messages.getString("BookingTableSelectionFloorView.27") + shopTable.getCapacity() + "</center></body></html>");
            tableButton.setEnabled(true);
        }
    }

    public void clearSelection() {
        Component[] components;
        this.dialog.selectedCapacity = 0;
        this.addedTableListModel.clear();
        this.releasedListModel.clear();
        for (Component component : components = this.floorPanel.getComponents()) {
            if (!(component instanceof TableButton)) continue;
            TableButton tableButton = (TableButton)component;
            tableButton.setSelected(false);
        }
    }

    public List<ShopTable> getReleasedListModel() {
        return this.releasedListModel;
    }

    public void setReleasedListModel(List<ShopTable> releasedListModel) {
        this.releasedListModel = releasedListModel;
    }

    public int getTableTotalCapacity() {
        this.totalCapacity = 0;
        if (this.tables == null || this.tables.isEmpty()) {
            return 0;
        }
        for (ShopTable shopTable : this.tables) {
            this.totalCapacity += shopTable.getCapacity().intValue();
        }
        List<ShopTable> bookedTableList = FloorplanDAO.getInstance().getAllBookedTablesByDate(this.dialog.getStartDate(), this.dialog.getEndDate());
        if (bookedTableList != null && !bookedTableList.isEmpty()) {
            for (ShopTable shopTable : bookedTableList) {
                this.totalCapacity -= shopTable.getCapacity().intValue();
            }
        }
        if (this.totalCapacity < 0) {
            this.totalCapacity = 0;
        }
        return this.totalCapacity;
    }

    private class TableButton
    extends POSToggleButton
    implements ActionListener {
        private ShopTable table;

        TableButton(ShopTable table) {
            this.table = table;
            this.setBorder(null);
            this.setFont(this.getFont().deriveFont(1, PosUIManager.getFontSize(16)));
            int priSize = PosUIManager.getSize(BookingTableSelectionFloorView.this.store.getTablePrimaryFontSize());
            String text = "<div style='font-size:" + priSize + "px;'>" + table.getTableNumber() + "</div>";
            this.setText("<html><body><center>" + text + "Cap:" + table.getCapacity() + "</center></body></html>");
            this.setPreferredSize(PosUIManager.getSize(157, 138));
            this.addActionListener(this);
        }

        public ShopTable getTable() {
            return this.table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Store store = DataProvider.get().getStore();
                Color freeForeColor = store.getTableFreeForeColor();
                Color freeBgColor = store.getTableFreeBGColor();
                int priSize = PosUIManager.getSize(store.getTablePrimaryFontSize());
                int secSize = PosUIManager.getSize(store.getTableSecondaryFontSize());
                String text = "<div style='font-size:" + priSize + "px;'>" + this.table.getTableNumber() + "</div>";
                if (this.isSelected()) {
                    this.setBackground(Color.GREEN);
                    this.setForeground(Color.black);
                    text = text + "<div style='font-size:" + secSize + "px; color:black;'>" + this.table.getShopTableStatus().getTableStatus().name() + "</div>";
                    BookingTableSelectionFloorView.this.addedTableListModel.add(this.table);
                    ((BookingTableSelectionFloorView)BookingTableSelectionFloorView.this).dialog.selectedCapacity += this.table.getCapacity().intValue();
                    ((BookingTableSelectionFloorView)BookingTableSelectionFloorView.this).dialog.selectedTableCapacity.setText("" + ((BookingTableSelectionFloorView)BookingTableSelectionFloorView.this).dialog.selectedCapacity);
                } else {
                    this.setBackground(freeBgColor);
                    this.setForeground(freeForeColor);
                    text = text + "<div style='font-size:" + secSize + "px; color:red;'>" + this.table.getShopTableStatus().getTableStatus().name() + "</div>";
                    BookingTableSelectionFloorView.this.addedTableListModel.remove(this.table);
                    List<ShopTable> selectedTables = BookingTableSelectionFloorView.this.dialog.getSelectedTables();
                    if (selectedTables != null) {
                        selectedTables.remove(this.table);
                    }
                    BookingTableSelectionFloorView.this.releasedListModel.add(this.table);
                    ((BookingTableSelectionFloorView)BookingTableSelectionFloorView.this).dialog.selectedCapacity -= this.table.getCapacity().intValue();
                    ((BookingTableSelectionFloorView)BookingTableSelectionFloorView.this).dialog.selectedTableCapacity.setText("" + ((BookingTableSelectionFloorView)BookingTableSelectionFloorView.this).dialog.selectedCapacity);
                }
                this.setText("<html><body><center>" + text + Messages.getString("BookingTableSelectionFloorView.27") + this.table.getCapacity() + "</center></body></html>");
            }
            catch (Exception e2) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
            }
        }
    }
}

