/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui.configuration;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.model.ReservationShift;
import com.floreantpos.model.dao.ReservationShiftDAO;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ReservationShiftEntryDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class ReservationConfiguration
extends TransparentPanel {
    private IntegerTextField tfLeadHour;
    private IntegerTextField tfWaitTime;
    private IntegerTextField tfCleanUpTime;
    private IntegerTextField tfSeatTime;
    private ReservationShiftTableModel tableModel;
    private JTable table;
    private ReservationShift reservationShift;

    public ReservationConfiguration() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(null, Messages.getString("ReservationConfiguration.0"), 2, 2, null, null));
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JPanel topConfigPanel = new JPanel((LayoutManager)new MigLayout("", "[]30[][]", ""));
        int comboWidth = 70;
        JLabel lblMinLeadHour = new JLabel(Messages.getString("ReservationConfiguration.5"));
        this.tfLeadHour = new IntegerTextField();
        this.tfLeadHour.setPreferredSize(PosUIManager.getSize(comboWidth, 0));
        this.tfLeadHour.setFocusable(true);
        JLabel lblReservationWaitTime = new JLabel(Messages.getString("ReservationConfiguration.6"));
        this.tfWaitTime = new IntegerTextField();
        JLabel lblAvgSeatTime = new JLabel(Messages.getString("ReservationConfiguration.7"));
        this.tfSeatTime = new IntegerTextField();
        JLabel lblCleanUpTime = new JLabel(Messages.getString("ReservationConfiguration.8"));
        this.tfCleanUpTime = new IntegerTextField();
        topConfigPanel.add(lblMinLeadHour);
        topConfigPanel.add((Component)this.tfLeadHour, "grow");
        topConfigPanel.add((Component)new JLabel(Messages.getString("ReservationConfiguration.10")), "wrap");
        topConfigPanel.add(lblReservationWaitTime);
        topConfigPanel.add((Component)this.tfWaitTime, "grow");
        topConfigPanel.add((Component)new JLabel(Messages.getString("ReservationConfiguration.13")), "wrap");
        topConfigPanel.add(lblAvgSeatTime);
        topConfigPanel.add((Component)this.tfSeatTime, "grow");
        topConfigPanel.add((Component)new JLabel(Messages.getString("ReservationConfiguration.13")), "wrap");
        topConfigPanel.add(lblCleanUpTime);
        topConfigPanel.add((Component)this.tfCleanUpTime, "grow");
        topConfigPanel.add((Component)new JLabel(Messages.getString("ReservationConfiguration.13")), "wrap");
        topPanel.add((Component)topConfigPanel, "grow, wrap");
        topPanel.add((Component)this.createReservationTimeConfigPanel(), "grow");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnSave = new PosButton(Messages.getString("ReservationConfiguration.24"));
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReservationConfiguration.this.updateModel();
            }
        });
        buttonPanel.add(btnSave);
        this.add((Component)topPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            ReservationShift shift = (ReservationShift)this.tableModel.getRowData(index);
            ReservationShiftEntryDialog dialog = new ReservationShiftEntryDialog();
            dialog.setReservationShift(shift);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.tableModel.updateItem(index);
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private JPanel createReservationTimeConfigPanel() {
        JPanel reservationTimeConfigPanel = new JPanel(new BorderLayout(5, 5));
        reservationTimeConfigPanel.setBorder(new TitledBorder(null, Messages.getString("ReservationConfiguration.25"), 2, 2, null, null));
        List<ReservationShift> shifts = new ReservationShiftDAO().findAll();
        this.tableModel = new ReservationShiftTableModel(shifts);
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    ReservationConfiguration.this.editSelectedRow();
                }
            }
        });
        this.table.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReservationShiftEntryDialog dialog = new ReservationShiftEntryDialog();
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    ReservationConfiguration.this.reservationShift = dialog.getReservationShift();
                    ReservationConfiguration.this.tableModel.addItem(ReservationConfiguration.this.reservationShift);
                    ReservationConfiguration.this.table.repaint();
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReservationConfiguration.this.editSelectedRow();
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = ReservationConfiguration.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    ReservationShift priceShift = (ReservationShift)ReservationConfiguration.this.tableModel.getRowData(index);
                    if (ConfirmDeleteDialog.showMessage(ReservationConfiguration.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        ReservationShiftDAO.getInstance().releaseParentAndDelete(priceShift);
                        ReservationConfiguration.this.tableModel.deleteItem(index);
                    }
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        buttonPanel.add(addButton);
        buttonPanel.add(editButton);
        buttonPanel.add(deleteButton);
        reservationTimeConfigPanel.add((Component)new JScrollPane(this.table), "Center");
        reservationTimeConfigPanel.add((Component)buttonPanel, "South");
        return reservationTimeConfigPanel;
    }

    private void updateView() {
    }

    private void updateModel() {
        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReservationConfiguration.1"));
    }

    class ReservationShiftTableModel
    extends ListTableModel {
        ReservationShiftTableModel(List list) {
            super(new String[]{POSConstants.NAME, POSConstants.DESCRIPTION, Messages.getString("ReservationConfiguration.28"), POSConstants.START_TIME, POSConstants.END_TIME, Messages.getString("ReservationConfiguration.29")}, list);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ReservationShift shift = (ReservationShift)this.rows.get(rowIndex);
            if (shift == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return shift.getName();
                }
                case 1: {
                    return shift.getDescription();
                }
                case 2: {
                    return shift.getDayOfWeekAsString();
                }
                case 3: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getStartTime());
                }
                case 4: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getEndTime());
                }
                case 5: {
                    return shift.isEnable();
                }
            }
            return null;
        }
    }
}

