/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.SystemProperties;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.cronjob.OroCronJobManager;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Main;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.update.UpdateManager;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.dao.util.ForeteesCacheManager;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceRoyale;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import jiconfont.IconFont;
import jiconfont.icons.FontAwesome;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.xml.sax.SAXParseException;

public class Application {
    private static Log logger = LogFactory.getLog(Application.class);
    private boolean developmentMode = false;
    private PosWindow posWindow;
    private User currentUser;
    private RootView rootView;
    private static Application instance;
    private static SimpleDateFormat dateFormat;
    private static ImageIcon applicationIcon;
    private boolean systemInitialized;
    private boolean viewInitialized;
    private boolean headLess = false;
    private static final String PRODUCT_NAME = "ForeteesPOS";
    private UpdateManager updateManager;

    protected Application() {
    }

    public void start() {
        try {
            Terminal currentTerminal;
            SystemProperties.setSeatCustomerEnable(true);
            SystemProperties.setShowTableReservation(false);
            SystemProperties.setForeTees(true);
            DataProvider.set(new ForeteesCacheManager());
            this.updateManager = new UpdateManager();
            try {
                if (this.updateManager.checkHasRemainingUpdates()) {
                    return;
                }
                if (Main.isAnotherInstanceRunning()) {
                    POSMessageDialog.showError("Another instance of Foretees POS is running.");
                    System.exit(0);
                }
            }
            catch (Exception e) {
                POSMessageDialog.showError(null, e.getMessage(), e);
            }
            this.setApplicationLook();
            applicationIcon = new ImageIcon(this.getClass().getResource("/icons/icon.png"));
            this.posWindow = new PosWindow();
            this.posWindow.initComponents();
            this.posWindow.initTimers();
            this.posWindow.setTitle(Application.getTitle());
            this.posWindow.setIconImage(applicationIcon.getImage());
            this.posWindow.setupSizeAndLocation();
            if (TerminalConfig.isKioskMode()) {
                this.posWindow.enterFullScreenMode();
            }
            this.updateManager.setParentWindow(this.posWindow);
            this.posWindow.setVisible(true);
            this.rootView = RootView.getInstance();
            this.rootView.initDefaultViews();
            this.posWindow.getContentPane().add(this.rootView);
            this.initializeSystem();
            this.initMqtt();
            this.initSendGridConfig();
            this.rootView.addView(OrderView.getInstance());
            if (TerminalConfig.isCheckUpdateOnStartUp()) {
                this.checkForUpdate();
            }
            if ((currentTerminal = DataProvider.get().getCurrentTerminal()) != null && currentTerminal.isMasterTerminal().booleanValue()) {
                OroCronJobManager.getInstance().startGiftCardActivationStatusJob();
            }
        }
        catch (DatabaseConnectionException | SQLException | HibernateException e) {
            int option = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("Application.0"));
            if (option == 0) {
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
            logger.error((Object)e);
        }
    }

    private void initSendGridConfig() {
        Store store = DataProvider.get().getStore();
        String sendGridSenderEmail = store.getSendGridSenderEmail();
        String sendGridApiKey = store.getSendGridApiKey();
        if (StringUtils.isNotEmpty((String)sendGridSenderEmail)) {
            MailService.setSenderEmail(sendGridSenderEmail);
        }
        if (StringUtils.isNotEmpty((String)sendGridApiKey)) {
            MailService.setApiKey(sendGridApiKey);
        }
    }

    private void initMqtt() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OroMqttClient.getInstance().initMqttClient(Application.this.getMqttDeviceId());
                    Application.this.updateManager.subscribeToUpdateService();
                    Application.this.updateManager.publishIfNewUpdateAvailable();
                }
                catch (Exception e) {
                    PosLog.error(this.getClass(), e.getMessage());
                }
            }
        }).start();
    }

    public void checkForUpdate() {
        this.checkForUpdate(false);
    }

    public boolean checkForUpdate(boolean throwException) {
        try {
            return this.updateManager.checkForUpdate();
        }
        catch (Exception e) {
            if (throwException) {
                if (e instanceof MalformedURLException) {
                    throw new PosException(Messages.getString("UpdateServerUrlNotValid"));
                }
                if (e instanceof ConnectException) {
                    throw new PosException(Messages.getString("UpdateServerConnFailed"));
                }
                if (e instanceof FileNotFoundException) {
                    throw new PosException(Messages.getString("NoUpdateFileFound"));
                }
                if (e instanceof SAXParseException) {
                    throw new PosException(Messages.getString("UpdateInfoIsNotValid"));
                }
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    public String getUpdateServerURL() {
        String updateServerURL = null;
        Store store = DataProvider.get().getStore();
        if (store == null) {
            DatabaseUtil.initialize(this.getHibernateConfigurationFileName());
            store = StoreDAO.getRestaurant();
        }
        if (store != null) {
            updateServerURL = store.getProperty("update_server_url");
        }
        if (StringUtils.isEmpty(updateServerURL)) {
            updateServerURL = TerminalConfig.getUpdateServerURL();
        }
        if (StringUtils.isEmpty((String)updateServerURL)) {
            updateServerURL = "https://orodev.net/update/foreteespos";
        }
        return updateServerURL;
    }

    public void startInvisible() {
        try {
            this.setApplicationLook();
            applicationIcon = new ImageIcon(this.getClass().getResource("/icons/icon_updated.png"));
            this.posWindow = new PosWindow();
            this.posWindow.setTitle(Application.getTitle());
            this.posWindow.setIconImage(applicationIcon.getImage());
            this.rootView = RootView.getInstance();
            this.posWindow.getContentPane().add(this.rootView);
            this.initializeSystem();
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    public String getMqttDeviceId() {
        return VersionInfo.getAppName() + TerminalUtil.getSystemUID();
    }

    private void setApplicationLook() {
        try {
            PlasticXPLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceRoyale());
            UIManager.put("Button.background", new ColorUIResource(Color.WHITE));
            UIManager.put("ComboBox.background", new ColorUIResource(Color.WHITE));
            UIManager.put("ButtonUI", "com.floreantpos.swing.POSButtonUI");
            UIManager.put("ToggleButtonUI", "com.floreantpos.swing.POSToggleButtonUI");
            UIManager.put("OptionPane.yesButtonText", Messages.getString("Application.10"));
            UIManager.put("OptionPane.noButtonText", Messages.getString("Application.12"));
            UIManager.put("OptionPane.cancelButtonText", Messages.getString("Application.14"));
            UIManager.put("OptionPane.titleText", Messages.getString("Application.16"));
            UIManager.put("OptionPane.okButtonText", Messages.getString("Application.18"));
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            this.initializeFont();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializeSystem() throws Exception {
        if (this.isSystemInitialized()) {
            return;
        }
        try {
            this.posWindow.setGlassPaneVisible(true);
            this.updateManager.performDatabaseUpgrade();
            DatabaseUtil.initialize(this.getHibernateConfigurationFileName());
            DataProvider.get().initialize();
            if (!this.viewInitialized) {
                this.initPlugins();
                this.viewInitialized = true;
            }
            LoginView.getInstance().initializeOrderButtonPanel();
            Application.getPosWindow().updateView();
            this.setSystemInitialized(true);
        }
        finally {
            Application.getPosWindow().setGlassPaneVisible(false);
        }
    }

    public void initializeHeadless() {
        this.headLess = true;
        _RootDAO.initialize();
        DataProvider.get().initialize();
        this.initStore();
        this.refreshStore();
        this.setSystemInitialized(true);
    }

    private void initPlugins() {
        List plugins = ExtensionManager.getPlugins();
        for (FloreantPlugin floreantPlugin : plugins) {
            floreantPlugin.initUI(Application.getPosWindow());
        }
    }

    private void initStore() {
        try {
            Store store = DataProvider.get().getStore();
            if (!this.headLess) {
                if (store.isItemPriceIncludesTax().booleanValue()) {
                    this.posWindow.setStatus(Messages.getString("Application.41"));
                } else {
                    this.posWindow.setStatus(Messages.getString("Application.42"));
                }
                this.posWindow.setRestaurantName(store.getName());
            }
        }
        catch (Exception e) {
            throw new DatabaseConnectionException(e);
        }
    }

    public void refreshStore() {
        DataProvider.get().refreshStore();
    }

    public List<OrderType> getOrderTypes() {
        return DataProvider.get().getOrderTypes();
    }

    public static synchronized Application getInstance() {
        if (instance == null) {
            instance = new Application();
        }
        return instance;
    }

    public static void setInstance(Application application) {
        instance = application;
    }

    public synchronized void doLogin(User user) {
        this.doLogin(user, true);
    }

    public synchronized void doLogin(User user, boolean showDefaultView) {
        if (user == null) {
            return;
        }
        this.setCurrentUser(user);
        if (showDefaultView) {
            this.getRootView().showDefaultView();
        }
        this.posWindow.rendererUserInfo();
        this.posWindow.startAutoLogoffTimer();
    }

    public void doLogout() {
        RootView.getInstance().getHeaderPanel().setSelected_86(false);
        BackOfficeWindow window = POSUtil.getBackOfficeWindow();
        if (window != null && window.isVisible()) {
            window.dispose();
        }
        this.setCurrentUser(null);
        RootView.getInstance().showView(LoginView.getInstance());
        this.posWindow.rendererUserInfo();
        this.posWindow.stopAutoLogoffTimer();
    }

    public void doAutoLogout() {
        this.doLogout();
    }

    public void doAutoLogin(User user) {
        this.setCurrentUser(user);
    }

    public static User getCurrentUser() {
        return Application.getInstance().currentUser;
    }

    public void setCurrentUser(User currentUser) {
        this.currentUser = currentUser;
    }

    public RootView getRootView() {
        return this.rootView;
    }

    public void setRootView(RootView rootView) {
        this.rootView = rootView;
    }

    public static PosWindow getPosWindow() {
        return Application.getInstance().posWindow;
    }

    public Terminal getTerminal() {
        return DataProvider.get().getCurrentTerminal();
    }

    public synchronized Terminal refreshAndGetTerminal() {
        DataProvider.get().refreshCurrentTerminal();
        return DataProvider.get().getCurrentTerminal();
    }

    public static PosPrinters getPrinters() {
        return DataProvider.get().getPrinters();
    }

    public OrderType getCurrentOrderType() {
        return DataProvider.get().getOrderTypes().get(0);
    }

    public static String getTitle() {
        return VersionInfo.getAppName() + " " + VersionInfo.getVersion();
    }

    public static ImageIcon getApplicationIcon() {
        return applicationIcon;
    }

    public static void setApplicationIcon(ImageIcon applicationIcon) {
        Application.applicationIcon = applicationIcon;
    }

    public static String formatDate(Date date) {
        return dateFormat.format(date);
    }

    public boolean isSystemInitialized() {
        return this.systemInitialized;
    }

    public void setSystemInitialized(boolean systemInitialized) {
        this.systemInitialized = systemInitialized;
    }

    public Store getStore() {
        return DataProvider.get().getStore();
    }

    public static Outlet getOutlet() {
        return DataProvider.get().getOutlet();
    }

    public static File getWorkingDir() {
        File file = new File(Application.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return file.getParentFile();
    }

    public boolean isDevelopmentMode() {
        return this.developmentMode;
    }

    public void setDevelopmentMode(boolean developmentMode) {
        this.developmentMode = developmentMode;
    }

    public boolean isPriceIncludesTax() {
        Store store = this.getStore();
        if (store == null) {
            return false;
        }
        return POSUtil.getBoolean(store.isItemPriceIncludesTax());
    }

    public String getLocation() {
        File file = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        return file.getParent();
    }

    private void initializeFont() {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            FontUIResource f = (FontUIResource)value;
            String fontName = f.getFontName();
            fontName = "Sans";
            Font font = new Font(fontName, f.getStyle(), PosUIManager.getDefaultFontSize());
            UIManager.put(key, new FontUIResource(font));
        }
        IconFontSwing.register((IconFont)FontAwesome.getIconFont());
        IconFontSwing.register((IconFont)GoogleMaterialDesignIcons.getIconFont());
    }

    public void shutdownPOS() {
        int option = POSMessageDialog.showYesNoQuestionDialog(this.posWindow, POSConstants.CONFIRM_SHUTDOWN_MESSAGE, POSConstants.CONFIRM);
        if (option == 0) {
            this.posWindow.saveSizeAndLocation();
            _RootDAO.releaseConnection();
            System.exit(0);
        }
    }

    public String getProductName() {
        return PRODUCT_NAME;
    }

    public String getProductVersion() {
        return VersionInfo.getVersion();
    }

    public void refreshCurrentUser() {
        if (this.currentUser != null) {
            this.currentUser = UserDAO.getInstance().get(this.currentUser.getId());
        }
    }

    public String getHibernateConfigurationFileName() {
        return "foretees.hibernate.cfg.xml";
    }

    @Deprecated
    public static String getLengthUnit() {
        return "MILE";
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public boolean isCloudConnected() {
        return false;
    }

    public void setCloudConnected(boolean cloudConnected) {
    }

    public String getCurrentTerminalOutletId() {
        return StringUtils.isNotEmpty((String)this.getTerminal().getOutletId()) ? this.getTerminal().getOutletId() : this.getStore().getDefaultOutletId();
    }

    static {
        dateFormat = new SimpleDateFormat("dd MMM, yyyy");
    }
}

