/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.main.Application;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class Main {
    private static final String DEVELOPMENT_MODE = "developmentMode";

    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(DEVELOPMENT_MODE, true, "State if this is developmentMode");
        BasicParser parser = new BasicParser();
        CommandLine commandLine = parser.parse(options, args);
        String optionValue = commandLine.getOptionValue(DEVELOPMENT_MODE);
        System.setProperty("allowLocalItem", Boolean.FALSE.toString());
        Application application = Application.getInstance();
        if (optionValue != null) {
            application.setDevelopmentMode(Boolean.valueOf(optionValue));
        }
        application.start();
    }

    public static boolean isAnotherInstanceRunning() throws Error {
        String userHome = System.getProperty("user.home");
        File file = new File(userHome, "foreteespos.lock");
        try {
            FileChannel fc = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            FileLock lock = fc.tryLock();
            if (lock == null) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    public static void restart() throws IOException, InterruptedException, URISyntaxException {
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        File currentJar = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        if (!currentJar.getName().endsWith(".jar")) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        command.add("-jar");
        command.add(currentJar.getPath());
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.start();
        System.exit(0);
    }
}

