/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseBookingInfo;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import liquibase.util.StringUtils;
import org.apache.commons.lang.SerializationUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"userName", "customer", "user"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class BookingInfo
extends BaseBookingInfo
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String STATUS_CANCEL = "cancel";
    public static final String STATUS_CLOSE = "close";
    public static final String STATUS_NO_APR = "no appear";
    public static final String STATUS_SEAT = "seat";
    public static final String STATUS_DELAY = "delay";
    public static final String STATUS_OPEN = "open";
    public static final String STATUS_CONFIRM = "confirm";
    public static final String STATUS_EXPIRED = "expired";
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    @XmlTransient
    private String customerName;
    @XmlTransient
    private String customerPhone;
    @XmlTransient
    private String bookedTableNumbers;
    @XmlTransient
    private Customer customer;
    @XmlTransient
    private User user;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public BookingInfo() {
    }

    public BookingInfo(String id) {
        super(id);
    }

    @Override
    public String toString() {
        return this.getId().toString();
    }

    public void setUser(User user) {
        this.setUserId(user == null ? null : user.getId());
        this.user = user;
    }

    public User getUser() {
        String userId = this.getUserId();
        if (userId == null) {
            return null;
        }
        if (this.user != null && userId.equals(this.user.getId())) {
            return this.user;
        }
        return DataProvider.get().getUserById(userId);
    }

    public void setCustomer(Customer customer) {
        if (customer == null) {
            this.setCustomerId(null);
        } else {
            this.setCustomerId(customer.getId());
        }
        this.customer = customer;
    }

    @XmlTransient
    public Customer getCustomer() {
        String customerId = this.getCustomerId();
        if (customerId == null) {
            return null;
        }
        if (this.customer != null && customerId.equals(this.customer.getId())) {
            return this.customer;
        }
        return DataProvider.get().getCustomer(customerId);
    }

    public String getCustomerName() {
        Customer customer = this.getCustomer();
        if (customer == null) {
            return this.customerName;
        }
        if (StringUtils.isNotEmpty((String)customer.getFirstName())) {
            this.customerName = customer.getFirstName() + " ";
        }
        if (StringUtils.isNotEmpty((String)customer.getLastName())) {
            this.customerName = this.customerName + customer.getLastName();
        }
        return this.customerName;
    }

    public void setCustomerName(String customerInfo) {
        this.customerName = customerInfo;
    }

    public String getCustomerPhone() {
        Customer customer = this.getCustomer();
        if (customer == null) {
            return this.customerPhone;
        }
        if (StringUtils.isNotEmpty((String)customer.getMobileNo())) {
            this.customerPhone = customer.getMobileNo() + " ";
        }
        return this.customerPhone;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    public String getBookedTableNumbers() {
        if (this.bookedTableNumbers != null) {
            return this.bookedTableNumbers;
        }
        List<ShopTable> shopTables = this.getTables();
        if (shopTables == null || shopTables.isEmpty()) {
            return null;
        }
        String tableNumbers = "";
        Iterator<ShopTable> iterator = shopTables.iterator();
        while (iterator.hasNext()) {
            ShopTable shopTable = iterator.next();
            tableNumbers = tableNumbers + shopTable.getTableNumber();
            if (!iterator.hasNext()) continue;
            tableNumbers = tableNumbers + ", ";
        }
        return tableNumbers;
    }

    @XmlTransient
    public String getBookedTableNamesOrNumbers() {
        List<ShopTable> shopTables = this.getTables();
        if (shopTables == null || shopTables.isEmpty()) {
            return null;
        }
        String tableNamesOrNumbers = "";
        Iterator<ShopTable> iterator = shopTables.iterator();
        while (iterator.hasNext()) {
            ShopTable shopTable = iterator.next();
            tableNamesOrNumbers = tableNamesOrNumbers + shopTable.getNameOrNumber();
            if (!iterator.hasNext()) continue;
            tableNamesOrNumbers = tableNamesOrNumbers + ", ";
        }
        return tableNamesOrNumbers;
    }

    public void setBookedTableNumbers(String bookTableNumbers) {
        this.bookedTableNumbers = bookTableNumbers;
    }

    public BookingInfo clone(BookingInfo source) {
        return (BookingInfo)SerializationUtils.clone((Serializable)source);
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setProperties(String properties) {
        super.setProperties(properties);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
    }

    public void addProperty(String key, String value) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(key, value);
    }

    public String getProperty(String key) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(key) && !(jsonElement = this.propertiesContainer.get(key)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public void removeProperty(String propertyName) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(propertyName);
        }
    }
}

