/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.PosLog;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseMenuItemModifierSpec;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.ui.model.ModifierPricingRule;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

@XmlRootElement(name="menuItemModifierSpec")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"defaultModifiers", "modifiers", "modifierGroup"})
public class MenuItemModifierSpec
extends BaseMenuItemModifierSpec
implements TimedModel,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROP_PRICE_RULES = "priceRules";
    public static final String JSON_PROP_ENABLE_GROUP_PRICE = "enableGroupPricing";
    public static final String JSON_PROP_ENABLE_MODIFIER_GROUP_SETTINGS = "enableModifierGroupSettings";
    private transient JsonObject propertiesContainer;
    private ModifierGroup modifierGroup;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private Map<Integer, Double> priceMap;
    private ArrayList<ModifierPricingRule> pricingRules;

    public MenuItemModifierSpec() {
    }

    public MenuItemModifierSpec(String id) {
        super(id);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getUniqueId() {
        return ("menuitem_modifiergroup_" + this.toString() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @XmlTransient
    public List<MenuItemModifierPageItem> getMenuItemModifierPageItemsAsList() {
        return this.getMenuItemModifierPageItemsAsSet();
    }

    @XmlTransient
    public List<MenuItemModifierPageItem> getMenuItemModifierPageItemsAsSet() {
        Set<MenuItemModifierPage> modifierPages = this.getModifierPages();
        ArrayList<MenuItemModifierPageItem> menuItemModifierPageItems = new ArrayList<MenuItemModifierPageItem>();
        for (MenuItemModifierPage page : modifierPages) {
            List<MenuItemModifierPageItem> items = page.getPageItems();
            if (items == null) continue;
            Collections.sort(items, (item1, item2) -> item1.getCol().compareTo(item2.getCol()));
            Collections.sort(items, (item1, item2) -> item1.getRow().compareTo(item2.getRow()));
            for (MenuItemModifierPageItem pageItem : items) {
                menuItemModifierPageItems.add(pageItem);
            }
        }
        return menuItemModifierPageItems;
    }

    @XmlTransient
    public Set<MenuModifier> getModifiers() {
        Set<MenuItemModifierPage> modifierPages = this.getModifierPages();
        HashSet<MenuModifier> menuModifiers = new HashSet<MenuModifier>();
        if (modifierPages != null) {
            for (MenuItemModifierPage page : modifierPages) {
                if (page.getPageItems() == null) continue;
                for (MenuItemModifierPageItem pageItem : page.getPageItems()) {
                    MenuModifier modifier = pageItem.getMenuModifier();
                    if (modifier == null) continue;
                    modifier.setPageItemId(pageItem.getId());
                    menuModifiers.add(modifier);
                }
            }
        }
        return menuModifiers;
    }

    public boolean hasMenuItemModifierPageItem() {
        Set<MenuItemModifierPage> modifierPages = this.getModifierPages();
        if (modifierPages == null || modifierPages.isEmpty()) {
            return false;
        }
        for (MenuItemModifierPage menuItemModifierPage : modifierPages) {
            List<MenuItemModifierPageItem> pageItems = menuItemModifierPage.getPageItems();
            if (pageItems == null && pageItems.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getDisplayName() {
        return super.getName();
    }

    @XmlTransient
    @JsonIgnoreProperties
    public Set<MenuModifier> getDefaultModifiers() {
        HashSet<MenuModifier> defaultModifiers = new HashSet<MenuModifier>();
        List<DefaultMenuModifier> defaultModifierList = super.getDefaultModifierList();
        if (defaultModifierList != null) {
            for (DefaultMenuModifier defaultMenuModifier : defaultModifierList) {
                defaultModifiers.add(defaultMenuModifier.getModifier());
            }
        }
        return defaultModifiers;
    }

    public ModifierGroup getModifierGroup() {
        if (this.modifierGroup != null) {
            return this.modifierGroup;
        }
        String modifierGroupId = super.getModifierGroupId();
        if (StringUtils.isEmpty((String)modifierGroupId)) {
            return null;
        }
        this.modifierGroup = ModifierGroupDAO.getInstance().get(modifierGroupId);
        return this.modifierGroup;
    }

    public void setModifierGroup(ModifierGroup modifierGroup) {
        this.modifierGroup = modifierGroup;
        String modifierGroupId = null;
        if (modifierGroup != null) {
            modifierGroupId = modifierGroup.getId();
        }
        this.setModifierGroupId(modifierGroupId);
    }

    public MenuItemModifierSpec deepClone() throws Exception {
        List<DefaultMenuModifier> defaultModifierList2;
        MenuItemModifierSpec newSpec = new MenuItemModifierSpec();
        BeanUtils.copyProperties((Object)newSpec, (Object)this);
        newSpec.setId(null);
        newSpec.setInstruction(this.getInstruction());
        newSpec.setModifierPages(null);
        newSpec.setDefaultModifierList(null);
        Set<MenuItemModifierPage> modifierPages2 = this.getModifierPages();
        if (modifierPages2 != null) {
            for (MenuItemModifierPage menuItemModifierPage : modifierPages2) {
                newSpec.addTomodifierPages(menuItemModifierPage.deepClone());
            }
        }
        if ((defaultModifierList2 = this.getDefaultModifierList()) != null) {
            ArrayList<DefaultMenuModifier> list = new ArrayList<DefaultMenuModifier>(defaultModifierList2.size());
            for (DefaultMenuModifier defaultMenuModifier : defaultModifierList2) {
                DefaultMenuModifier d2 = new DefaultMenuModifier();
                BeanUtils.copyProperties((Object)d2, (Object)defaultMenuModifier);
                list.add(d2);
            }
            newSpec.setDefaultModifierList(list);
        }
        return newSpec;
    }

    @Override
    public Boolean getAutoShow() {
        return super.isAutoShow();
    }

    @Override
    public Boolean getEnable() {
        return super.isEnable();
    }

    @Override
    public Boolean getExclusive() {
        return super.isExclusive();
    }

    @Override
    public Boolean getJumpGroup() {
        return super.isJumpGroup();
    }

    @Override
    public Boolean getRequired() {
        return super.isRequired();
    }

    public boolean isEnableGroupPricing() {
        return this.hasProperty(JSON_PROP_ENABLE_GROUP_PRICE) && this.getBooleanProperty(JSON_PROP_ENABLE_GROUP_PRICE, false) != false;
    }

    public boolean hasPriceRules() {
        return this.isEnableGroupPricing() && this.hasProperty(JSON_PROP_PRICE_RULES);
    }

    public Double getPrice(Integer quantity) {
        if (!this.hasPriceRules()) {
            return null;
        }
        if (this.priceMap != null) {
            return this.priceMap.get(quantity);
        }
        this.priceMap = new HashMap<Integer, Double>();
        List priceList = this.getPriceRules();
        if (priceList != null && priceList.size() > 0) {
            for (ModifierPricingRule pricing : priceList) {
                for (int i = pricing.getFromQty().intValue(); i <= pricing.getToQty(); ++i) {
                    this.priceMap.put(i, pricing.getPrice());
                }
            }
        }
        return this.priceMap.get(quantity);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
        return this.propertiesContainer;
    }

    public List getPriceRules() {
        try {
            JsonNode arrayNode;
            String properties;
            if (this.pricingRules == null) {
                this.pricingRules = new ArrayList();
            }
            if (StringUtils.isEmpty((String)(properties = this.getProperties()))) {
                return this.pricingRules;
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode readTree = mapper.readTree(properties);
            if (readTree != null && (arrayNode = readTree.findValue(JSON_PROP_PRICE_RULES)) != null) {
                this.pricingRules = (ArrayList)mapper.readValue(arrayNode.toString(), (TypeReference)new TypeReference<List<ModifierPricingRule>>(){});
                return this.pricingRules;
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        return this.pricingRules;
    }

    public boolean isEnableModifierGroupSettings() {
        return this.getBooleanProperty(JSON_PROP_ENABLE_MODIFIER_GROUP_SETTINGS, false);
    }

    public void setModifierGroupSettings(boolean show) {
        this.addProperty(JSON_PROP_ENABLE_MODIFIER_GROUP_SETTINGS, String.valueOf(show));
    }
}

