/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseMenuModifier;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.GlobalIdGenerator;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"image", "properties", "modifierGroups"})
@XmlRootElement
public class MenuModifier
extends BaseMenuModifier
implements TimedModel,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient MenuItemModifierSpec menuItemModifierGroup;
    private String pageItemId;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public MenuModifier() {
    }

    public MenuModifier(String id) {
        super(id);
    }

    public TaxGroup getTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getTaxGroupId());
    }

    public void setTaxGroup(TaxGroup taxGroup) {
        String taxGroupId = null;
        if (taxGroup != null) {
            taxGroupId = taxGroup.getId();
        }
        super.setTaxGroupId(taxGroupId);
    }

    public MenuItemModifierSpec getMenuItemModifierGroup() {
        return this.menuItemModifierGroup;
    }

    public void setMenuItemModifierGroup(MenuItemModifierSpec menuItemModifierGroup) {
        this.menuItemModifierGroup = menuItemModifierGroup;
    }

    @Override
    public Integer getSortOrder() {
        return super.getSortOrder() == null ? 9999 : super.getSortOrder();
    }

    @Override
    public Integer getButtonColor() {
        Integer buttonColorCode = super.getButtonColor();
        if (buttonColorCode == null || buttonColorCode == 0 || buttonColorCode == -1316371) {
            buttonColorCode = Color.WHITE.getRGB();
        }
        return buttonColorCode;
    }

    @Override
    public Integer getTextColor() {
        Integer textColor = super.getTextColor();
        return textColor == 0 ? null : textColor;
    }

    @JsonIgnore
    public String getDisplayName() {
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal != null && terminal.isShowTranslatedName().booleanValue() && StringUtils.isNotEmpty((String)this.getTranslatedName())) {
            return this.getTranslatedName();
        }
        return super.getName();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getUniqueId() {
        return ("menu_modifier_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public double getPriceForSize(MenuItemSize size, boolean extra) {
        double defaultPrice = this.getPrice();
        if (size == null) {
            return defaultPrice;
        }
        List<PizzaModifierPrice> priceList = this.getPizzaModifierPriceList();
        if (priceList == null) {
            return defaultPrice;
        }
        for (PizzaModifierPrice pizzaModifierPrice : priceList) {
            if (!size.equals(pizzaModifierPrice.getSize())) continue;
            if (extra) {
                return pizzaModifierPrice.getExtraPrice();
            }
            return pizzaModifierPrice.getPrice();
        }
        return defaultPrice;
    }

    public double getPriceForMultiplier(Multiplier multiplier) {
        double defaultPrice = this.getPrice();
        if (multiplier == null || multiplier.isMain().booleanValue()) {
            return defaultPrice;
        }
        List<ModifierMultiplierPrice> priceList = this.getMultiplierPriceList();
        if (priceList == null || priceList.isEmpty()) {
            return defaultPrice * multiplier.getRate() / 100.0;
        }
        for (ModifierMultiplierPrice multiplierPrice : priceList) {
            if (!multiplier.getId().equals(multiplierPrice.getMultiplier().getId())) continue;
            return multiplierPrice.getPrice();
        }
        return defaultPrice * multiplier.getRate() / 100.0;
    }

    public double getPriceForSizeAndMultiplier(MenuItemSize size, boolean extra, Multiplier multiplier) {
        List<PizzaModifierPrice> priceList = this.getPizzaModifierPriceList();
        double regularPrice = 0.0;
        if (this.isPizzaModifier().booleanValue() && priceList != null) {
            for (PizzaModifierPrice pizzaModifierPrice : priceList) {
                List<ModifierMultiplierPrice> multiplierPriceList;
                if (size == null || !size.equals(pizzaModifierPrice.getSize()) || (multiplierPriceList = pizzaModifierPrice.getMultiplierPriceList()) == null) continue;
                Double multiplierPrice = null;
                for (ModifierMultiplierPrice price : multiplierPriceList) {
                    String priceTableMultiplierName = price.getMultiplier().getId();
                    if (priceTableMultiplierName.equals("Regular")) {
                        regularPrice = price.getPrice();
                        if (!multiplier.getId().equals("Regular")) continue;
                        return regularPrice;
                    }
                    if (!priceTableMultiplierName.equals(multiplier.getId())) continue;
                    multiplierPrice = price.getPrice();
                }
                if (multiplierPrice == null) continue;
                return multiplierPrice;
            }
        }
        return regularPrice * multiplier.getRate() / 100.0;
    }

    public List<TicketItemTax> getTaxByOrderType(OrderType type) {
        return this.getTaxByOrderType(type, null);
    }

    public List<TicketItemTax> getTaxByOrderType(OrderType type, TicketItem parentItem) {
        if (!this.isTaxable().booleanValue()) {
            return null;
        }
        if (this.isTaxSameAsItem() && parentItem != null) {
            return parentItem.getTaxes();
        }
        TaxGroup taxGroup = this.getTaxGroup();
        if (taxGroup == null) {
            return null;
        }
        ArrayList<TicketItemTax> ticketItemTaxes = new ArrayList<TicketItemTax>();
        List<Tax> taxes = taxGroup.getTaxes();
        if (taxes != null) {
            for (Tax tax : taxes) {
                TicketItemTax ticketItemTax = new TicketItemTax();
                ticketItemTax.setId(GlobalIdGenerator.generateGlobalId());
                ticketItemTax.setName(tax.getName());
                ticketItemTax.setSfName(tax.getSfName());
                ticketItemTax.setRate(tax.getRate());
                ticketItemTaxes.add(ticketItemTax);
            }
        }
        return ticketItemTaxes;
    }

    @XmlTransient
    public ImageIcon getImage() {
        ImageResource imageResource = DataProvider.get().getImageResource(this.getImageId());
        if (imageResource != null) {
            return imageResource.getButtonImage();
        }
        return null;
    }

    public void setPageItemId(String id) {
        this.pageItemId = id;
    }

    public String getPageItemId() {
        return this.pageItemId;
    }

    @XmlTransient
    public double getTotalTaxRate() {
        TaxGroup taxGroup = this.getTaxGroup();
        if (taxGroup != null) {
            return taxGroup.getTotalTaxRate();
        }
        return 0.0;
    }

    public void setTotalTaxRate(double totalTaxRate) {
    }

    public void setTaxSameAsItem(boolean b) {
        this.addProperty("tax.same.as.item", String.valueOf(b));
    }

    public boolean isTaxSameAsItem() {
        return this.getBooleanProperty("tax.same.as.item", false);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
        return this.propertiesContainer;
    }
}

