/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Address;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Store;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.TipsReceivedBy;
import com.floreantpos.model.base.BaseOutlet;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"properties", "departments", "tableServingBGColor", "tableServingForeColor", "tableBookForeColor", "tableBookBGColor", "tableFreeForeColor", "tableFreeBGColor", "tableSeatForeColor", "tableSeatBGColor"})
@XmlRootElement
public class Outlet
extends BaseOutlet
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;

    public Outlet() {
    }

    public Outlet(String id) {
        super(id);
    }

    @Override
    public String toString() {
        return super.getName();
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public TaxGroup getTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getTaxGroupId());
    }

    public void setTaxGroup(TaxGroup taxGroup) {
        String taxGroupId = null;
        if (taxGroup != null) {
            taxGroupId = taxGroup.getId();
        }
        super.setTaxGroupId(taxGroupId);
    }

    public Address getAddress() {
        if (StringUtils.isNotEmpty((String)this.getAddressId())) {
            return AddressDAO.getInstance().get(this.getAddressId());
        }
        return null;
    }

    public void setAddress(Address address) {
        String addressId = null;
        if (address != null) {
            addressId = address.getId();
        }
        super.setAddressId(addressId);
    }

    public Currency getCurrency() {
        return DataProvider.get().getCurrency(this.getCurrencyId());
    }

    public void setCurrency(Currency currency) {
        String currencyId = null;
        if (currency != null) {
            currencyId = currency.getId();
        }
        super.setCurrencyId(currencyId);
    }

    public boolean isAllwMemberbasedPOI() {
        String update = this.getProperty("inventory.allowMemberPOI");
        if (StringUtils.isEmpty((String)update)) {
            return false;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateOnHandBlncForSale() {
        String update = this.getProperty("inventory.updateOnHandBlnceForSale");
        if (StringUtils.isEmpty((String)update)) {
            return true;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateAvlBlncForSale() {
        String update = this.getProperty("inventory.updateAvlBlnceForSale");
        if (StringUtils.isEmpty((String)update)) {
            return true;
        }
        return Boolean.valueOf(update);
    }

    public boolean isAllwNegOnHandBlnce() {
        String update = this.getProperty("inventory.allowNegetiveOnHandBalance");
        if (StringUtils.isEmpty((String)update)) {
            return false;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateAvlBlncForPOCreated() {
        String update = this.getProperty("inventory.updateAvailBalanceForPurchaseOrderCreated");
        if (StringUtils.isEmpty((String)update)) {
            return false;
        }
        return Boolean.valueOf(update);
    }

    public boolean isUpdateOnHandBlncForPORec() {
        String update = this.getProperty("inventory.updateOnHandBalanceForPurchaseOrderReceived");
        if (StringUtils.isEmpty((String)update)) {
            return true;
        }
        return Boolean.valueOf(update);
    }

    public String getImageId() {
        String oldLogoResourceId;
        String storeLogoResourceId = this.getProperty("logo.imageid");
        if (StringUtils.isEmpty((String)storeLogoResourceId) && (oldLogoResourceId = this.getProperty("ticket.header.logo.imageid")) != null) {
            this.addProperty("logo.imageid", oldLogoResourceId);
            return oldLogoResourceId;
        }
        return storeLogoResourceId;
    }

    public boolean isInventoryAvgPricingMethod() {
        String property = this.getProperty("inventory.pricing.method");
        if (property == null) {
            return false;
        }
        return property.equals("avg");
    }

    public static String getWebServiceUrl() {
        Store store = DataProvider.get().getStore();
        return store.getProperty("web.service.url") + "/service/data/store/" + store.getProperty("web.service.schema");
    }

    public TipsReceivedBy getTipsReceivedByForDeliveryOrder() {
        try {
            String tipsReceiver = this.getProperty("tips.receiver.delivery");
            if (StringUtils.isNotEmpty((String)tipsReceiver)) {
                return TipsReceivedBy.valueOf(tipsReceiver);
            }
            return TipsReceivedBy.Server;
        }
        catch (Exception e) {
            throw new PosException(Messages.getString("Outlet.2"));
        }
    }

    public TipsReceivedBy getTipsReceivedByForNonDeliveryOrder() {
        try {
            String tipsReceiver = this.getProperty("tips.receiver.nonDelivery");
            if (StringUtils.isNotEmpty((String)tipsReceiver)) {
                return TipsReceivedBy.valueOf(tipsReceiver);
            }
            return TipsReceivedBy.Server;
        }
        catch (Exception e) {
            throw new PosException(Messages.getString("Outlet.2"));
        }
    }

    public double getOvertimeMarkup() {
        try {
            String overtimeMarkup = this.getProperty("overtime.markup");
            if (StringUtils.isNotEmpty((String)overtimeMarkup)) {
                return Double.parseDouble(overtimeMarkup);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    public boolean hasCreateMemberPermission() {
        try {
            String memberCreate = this.getProperty("member.create.permission");
            if (StringUtils.isNotEmpty((String)memberCreate)) {
                return Boolean.valueOf(memberCreate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean isAutoSyncCharges() {
        return this.getBooleanProperty("Charges.Automatically_Sync_Day", Boolean.FALSE);
    }

    public boolean isAllowPenyRounding() {
        try {
            String penyRoundAmnt = this.getProperty("store.peny.rounding");
            if (StringUtils.isNotEmpty((String)penyRoundAmnt)) {
                return Boolean.valueOf(penyRoundAmnt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int getCustomerMonitorDisplayOption() {
        try {
            String displayOptionString = this.getProperty("customer.monitor.display.option");
            if (StringUtils.isNotEmpty((String)displayOptionString)) {
                return Integer.parseInt(displayOptionString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int getCustomerMonitorDisplaySlideDuration() {
        try {
            String slideDurationString = this.getProperty("customer.monitor.slide.duration");
            if (StringUtils.isNotEmpty((String)slideDurationString)) {
                return Integer.parseInt(slideDurationString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 5;
    }

    public String getServerUrl() {
        try {
            String serverUrl = this.getProperty("update_server_url");
            if (StringUtils.isNotEmpty((String)serverUrl)) {
                return serverUrl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void setTablePrimaryFontSize(int priFont) {
        this.addProperty("floorplan.primaryFontSize", String.valueOf(priFont));
    }

    public int getTablePrimaryFontSize() {
        return this.getProperty("floorplan.primaryFontSize") == null ? 18 : Integer.valueOf(this.getProperty("floorplan.primaryFontSize"));
    }

    public void setTableSecondaryFontSize(int secFont) {
        this.addProperty("floorplan.secondaryFontSize", String.valueOf(secFont));
    }

    public int getTableSecondaryFontSize() {
        return this.getProperty("floorplan.secondaryFontSize") == null ? 10 : Integer.valueOf(this.getProperty("floorplan.secondaryFontSize"));
    }

    public void setTableBtnWidth(int btnWidth) {
        this.addProperty("floorplan.btnWidth", String.valueOf(btnWidth));
    }

    public int getTableBtnWidth() {
        return this.getProperty("floorplan.btnWidth") == null ? 100 : Integer.valueOf(this.getProperty("floorplan.btnWidth"));
    }

    public void setTableBtnHeight(int btnHeight) {
        this.addProperty("floorplan.btnHeight", String.valueOf(btnHeight));
    }

    public int getTableBtnHeight() {
        return this.getProperty("floorplan.btnHeight") == null ? 80 : Integer.valueOf(this.getProperty("floorplan.btnHeight"));
    }

    public void setTableSeatForeColor(Color seatForeColor) {
        this.addProperty("floorplan.seatForeColor", seatForeColor != null ? String.valueOf(seatForeColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableSeatForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.seatForeColor")) ? Color.BLACK : new Color(Integer.parseInt(this.getProperty("floorplan.seatForeColor")));
    }

    public void setTableSeatBGColor(Color seatBgColor) {
        this.addProperty("floorplan.seatBGColor", seatBgColor != null ? String.valueOf(seatBgColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableSeatBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.seatBGColor")) ? Color.ORANGE : new Color(Integer.parseInt(this.getProperty("floorplan.seatBGColor")));
    }

    public void setTableServingForeColor(Color servingForeColor) {
        this.addProperty("floorplan.servingForeColor", servingForeColor != null ? String.valueOf(servingForeColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableServingForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.servingForeColor")) ? Color.BLACK : new Color(Integer.parseInt(this.getProperty("floorplan.servingForeColor")));
    }

    public void setTableServingBGColor(Color servingBgColor) {
        this.addProperty("floorplan.servingBGColor", servingBgColor != null ? String.valueOf(servingBgColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableServingBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.servingBGColor")) ? new Color(255, 102, 102) : new Color(Integer.parseInt(this.getProperty("floorplan.servingBGColor")));
    }

    public void setTableBookForeColor(Color bookForeColor) {
        this.addProperty("floorplan.bookForeColor", bookForeColor != null ? String.valueOf(bookForeColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableBookForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.bookForeColor")) ? Color.BLACK : new Color(Integer.parseInt(this.getProperty("floorplan.bookForeColor")));
    }

    public void setTableBookBGColor(Color bookBgColor) {
        this.addProperty("floorplan.bookBGColor", bookBgColor != null ? String.valueOf(bookBgColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableBookBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.bookBGColor")) ? Color.YELLOW : new Color(Integer.parseInt(this.getProperty("floorplan.bookBGColor")));
    }

    public void setTableFreeForeColor(Color freeForeColor) {
        this.addProperty("floorplan.freeForeColor", freeForeColor != null ? String.valueOf(freeForeColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableFreeForeColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.freeForeColor")) ? Color.black : new Color(Integer.parseInt(this.getProperty("floorplan.freeForeColor")));
    }

    public void setTableFreeBGColor(Color freeBgColor) {
        this.addProperty("floorplan.freeBGColor", freeBgColor != null ? String.valueOf(freeBgColor.getRGB()) : "");
    }

    @XmlTransient
    public Color getTableFreeBGColor() {
        return StringUtils.isEmpty((String)this.getProperty("floorplan.freeBGColor")) ? Color.white : new Color(Integer.parseInt(this.getProperty("floorplan.freeBGColor")));
    }

    public boolean isShowTableNameOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableName", "false"));
    }

    public boolean isShowTableNumberOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableNumber", "true"));
    }

    public boolean isShowServerNameOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showServerName", "true"));
    }

    public boolean isShowTokenNumberOnTable() {
        return Boolean.valueOf(this.getProperty("floorplan.showTokenName", "true"));
    }

    public void setShowTableNameOnTable(boolean show) {
        this.addProperty("floorplan.showTableName", String.valueOf(show));
    }

    public void setShowTableNumberOnTable(boolean show) {
        this.addProperty("floorplan.showTableNumber", String.valueOf(show));
    }

    public void setShowServerNameOnTable(boolean show) {
        this.addProperty("floorplan.showServerName", String.valueOf(show));
    }

    public void setShowTokenNumberOnTable(boolean show) {
        this.addProperty("floorplan.showTokenName", String.valueOf(show));
    }

    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getExtraProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getExtraProperties(), JsonObject.class);
        }
        return this.propertiesContainer;
    }

    public void addProperty(String key, String value) {
        JsonObject propertyStore = this.getPropertyStore();
        propertyStore.addProperty(key, value);
        this.setExtraProperties(propertyStore.toString());
    }

    public void removeProperty(String propertyName) {
        JsonObject propertyStore = this.getPropertyStore();
        propertyStore.remove(propertyName);
        this.setExtraProperties(propertyStore.toString());
    }

    public String getProperty(String key) {
        if (this.getPropertyStore().has(key)) {
            return this.getPropertyStore().get(key).getAsString();
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        if (this.getPropertyStore().has(key)) {
            return this.getPropertyStore().get(key).getAsString();
        }
        return defaultValue;
    }

    public Boolean getBooleanProperty(String key, boolean defaultValue) {
        JsonElement string = this.getPropertyStore().get(key);
        if (string == null) {
            return defaultValue;
        }
        return string.getAsBoolean();
    }
}

