/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Printer;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.dao.TerminalPrintersDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PrinterType;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="printers")
public class PosPrinters {
    private String receiptPrinter;
    private Printer defaultKitchenPrinter;
    private List<Printer> kitchenPrinters = new ArrayList<Printer>(1);
    private List<Printer> reportPrinters = new ArrayList<Printer>(1);
    private List<Printer> receiptPrinters = new ArrayList<Printer>(1);
    private List<Printer> stickerPrinters = new ArrayList<Printer>(1);
    private List<Printer> labelPrinters = new ArrayList<Printer>(1);
    private boolean printToKds;

    public String getReceiptPrinter() {
        return this.receiptPrinter;
    }

    public List<Printer> getKitchenPrinters() {
        return this.kitchenPrinters;
    }

    @Deprecated
    public Printer getDefaultKitchenPrinter() {
        if (this.getKitchenPrinters().size() > 0) {
            this.defaultKitchenPrinter = this.kitchenPrinters.get(0);
            for (Printer printer : this.kitchenPrinters) {
                if (!printer.isDefaultPrinter()) continue;
                this.defaultKitchenPrinter = printer;
                break;
            }
        }
        return this.defaultKitchenPrinter;
    }

    public static PosPrinters load() {
        return PosPrinters.load(Application.getInstance().getTerminal());
    }

    public static PosPrinters load(Terminal terminal) {
        PosPrinters printers = new PosPrinters();
        try {
            List<TerminalPrinters> terminalPrinters = TerminalPrintersDAO.getInstance().findTerminalPrinters(terminal);
            ArrayList<Printer> terminalActivePrinters = new ArrayList<Printer>();
            for (TerminalPrinters terminalPrinter : terminalPrinters) {
                int printerType = terminalPrinter.getVirtualPrinter().getType();
                if (printerType == 0) {
                    printers.reportPrinters.add(PosPrinters.createPrinter(terminalPrinter));
                    continue;
                }
                if (printerType == 5) {
                    printers.labelPrinters.add(PosPrinters.createPrinter(terminalPrinter));
                    continue;
                }
                if (printerType == 1) {
                    printers.receiptPrinter = terminalPrinter.getPrinterName();
                    printers.receiptPrinters.add(PosPrinters.createPrinter(terminalPrinter));
                    continue;
                }
                if (printerType == 2) {
                    printers.kitchenPrinters.add(PosPrinters.createPrinter(terminalPrinter));
                    continue;
                }
                if (printerType == 6) {
                    printers.stickerPrinters.add(PosPrinters.createPrinter(terminalPrinter));
                    continue;
                }
                Printer printer = PosPrinters.createPrinter(terminalPrinter);
                terminalActivePrinters.add(printer);
            }
            if (printers.receiptPrinter == null) {
                printers.receiptPrinter = PosPrinters.getDefaultPrinterName();
            }
            printers.printToKds = DataProvider.get().getStore().isKDSenabled();
        }
        catch (Exception e) {
            PosLog.error(PosPrinters.class, e);
        }
        return printers;
    }

    public static Printer createPrinter(TerminalPrinters terminalPrinter) {
        Printer printer = new Printer(terminalPrinter.getVirtualPrinter(), terminalPrinter.getPrinterName());
        printer.setPrintSystem(terminalPrinter.getProperty("receipt.printer_type", "Standard"));
        printer.setPrinterType(terminalPrinter.getProperty("printerType", PrinterType.LOCAL.getName()));
        printer.setIpAddress(terminalPrinter.getProperty("ipAddress"));
        printer.setIpPort(terminalPrinter.getProperty("ipPort"));
        printer.setSerialPort(terminalPrinter.getProperty("serialPort"));
        printer.setTextLength(POSUtil.parseInteger(terminalPrinter.getProperty("textLength")));
        return printer;
    }

    public static String getDefaultPrinterName() {
        PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
        if (defaultPrintService != null) {
            return defaultPrintService.getName();
        }
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        if (services.length > 0) {
            return services[0].getName();
        }
        return null;
    }

    public boolean isPrintToKds() {
        return this.printToKds;
    }

    public List<Printer> getReportPrinters() {
        return this.reportPrinters;
    }

    public List<Printer> getReceiptPrinters() {
        return this.receiptPrinters;
    }

    public List<Printer> getStickerPrinters() {
        return this.stickerPrinters;
    }

    public List<Printer> getLabelPrinters() {
        return this.labelPrinters;
    }

    public String getLabelPrinter() {
        if (this.labelPrinters.size() == 0) {
            return null;
        }
        return this.labelPrinters.get(0).getDeviceName();
    }
}

