/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public interface PropertyContainer {
    public String getProperties();

    public void setProperties(String var1);

    @JsonIgnore
    public JsonObject getPropertyStore();

    default public boolean hasProperty(String key) {
        return this.getPropertyStore().has(key);
    }

    default public String getProperty(String key) {
        if (this.getPropertyStore().has(key)) {
            return this.getPropertyStore().get(key).getAsString();
        }
        return null;
    }

    default public String getProperty(String key, String defaultValue) {
        if (this.getPropertyStore().has(key)) {
            return this.getPropertyStore().get(key).getAsString();
        }
        return defaultValue;
    }

    default public Boolean getBooleanProperty(String key, boolean defaultValue) {
        JsonElement string = this.getPropertyStore().get(key);
        if (string == null) {
            return defaultValue;
        }
        return string.getAsBoolean();
    }

    default public void addProperty(String key, String value) {
        JsonObject propertyStore = this.getPropertyStore();
        propertyStore.addProperty(key, value);
        this.setProperties(propertyStore.toString());
    }

    default public void removeProperty(String propertyName) {
        JsonObject propertyStore = this.getPropertyStore();
        propertyStore.remove(propertyName);
        this.setProperties(propertyStore.toString());
    }
}

