/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.model.base.BaseReseller;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;

public class Reseller
extends BaseReseller {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;

    public Reseller() {
    }

    public Reseller(String id) {
        super(id);
    }

    @Override
    public String toString() {
        String fName = this.getName();
        if (fName == null) {
            fName = this.getEmail();
        }
        return fName;
    }

    @Override
    public String getName() {
        String name = super.getFirstName();
        if (StringUtils.isNotEmpty((String)super.getLastName())) {
            name = name + " " + super.getLastName();
        }
        return name;
    }

    public void setEncryptedSecretCode(String secretCode) {
        try {
            this.setSecretCode(AESencrp.encrypt((String)secretCode));
        }
        catch (Exception e) {
            this.setSecretCode(secretCode);
        }
    }

    public String getUnencryptedSecretCode() {
        String secretKey = this.getSecretCode();
        if (StringUtils.isNotEmpty((String)secretKey)) {
            try {
                secretKey = AESencrp.decrypt((String)secretKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return secretKey;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setProperties(String properties) {
        super.setProperties(properties);
        if (StringUtils.isNotEmpty((String)properties)) {
            this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        }
    }

    public void addProperty(String key, String value) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        if (StringUtils.isNotEmpty((String)value)) {
            this.propertiesContainer.addProperty(key, value);
        }
    }

    public String getProperty(String key) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(key) && !(jsonElement = this.propertiesContainer.get(key)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public void removeProperty(String propertyName) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(propertyName);
        }
    }
}

