/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseTaxGroup;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={""})
@XmlRootElement
public class TaxGroup
extends BaseTaxGroup
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public TaxGroup() {
    }

    public TaxGroup(String id) {
        super(id);
    }

    public TaxGroup(String id, String name) {
        super(id, name);
    }

    @Override
    public String toString() {
        String name = super.getName();
        List<Tax> taxes = this.getTaxes();
        if (taxes == null || taxes.isEmpty()) {
            return name;
        }
        name = name + " (";
        double sumOfRates = 0.0;
        for (Tax tax : taxes) {
            sumOfRates += tax.getRate().doubleValue();
        }
        name = name + NumberUtil.formatAmount(sumOfRates);
        name = name + ")";
        return name;
    }

    public String getUniqueId() {
        return ("taxgroup_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setProperties(String properties) {
        super.setProperties(properties);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
    }

    public void addProperty(String key, String value) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(key, value);
    }

    public String getProperty(String key) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(key) && !(jsonElement = this.propertiesContainer.get(key)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String key) {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.has(key);
        }
        return false;
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public void removeProperty(String propertyName) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(propertyName);
        }
    }

    public double getTotalTaxRate() {
        double total = 0.0;
        List<Tax> taxes = this.getTaxes();
        if (taxes != null || !taxes.isEmpty()) {
            for (Tax tax : taxes) {
                total += tax.getRate().doubleValue();
            }
        }
        return total;
    }

    public void setServiceChargeName(String serviceChargeName) {
        this.addProperty("scName", serviceChargeName);
    }

    public String getServiceChargeName() {
        return this.getProperty("scName");
    }
}

