/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.model.Printer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseVirtualPrinter;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@JsonIgnoreProperties(ignoreUnknown=true, value={"kdsPrinter"})
@XmlRootElement
public class VirtualPrinter
extends BaseVirtualPrinter
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final int REPORT = 0;
    public static final int RECEIPT = 1;
    public static final int KITCHEN = 2;
    public static final int PACKING = 3;
    public static final int KITCHEN_DISPLAY = 4;
    public static final int LABEL = 5;
    public static final int STICKER = 6;
    private static Printer kdsPrinter;
    public static final String[] PRINTER_TYPE_NAMES;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public VirtualPrinter() {
    }

    public VirtualPrinter(String id) {
        super(id);
    }

    public VirtualPrinter(String id, String name) {
        super(id, name);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof VirtualPrinter)) {
            return false;
        }
        VirtualPrinter other = (VirtualPrinter)obj;
        return this.getName().equalsIgnoreCase(other.getName());
    }

    public String getDisplayName() {
        return PRINTER_TYPE_NAMES[this.getType()];
    }

    public static Printer getKdsPrinter() {
        if (kdsPrinter == null) {
            VirtualPrinter kdsVPrinter = new VirtualPrinter();
            kdsVPrinter.setName("kds");
            kdsVPrinter.setType(4);
            kdsPrinter = new Printer(kdsVPrinter, "kds");
        }
        return kdsPrinter;
    }

    @Override
    public String toString() {
        String name = this.getName();
        List<String> typeNames = this.getOrderTypeNames();
        if (typeNames != null && typeNames.size() > 0) {
            name = name + " (";
            Iterator<String> iterator = typeNames.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                name = name + string;
                if (!iterator.hasNext()) continue;
                name = name + ", ";
            }
            name = name + ")";
        }
        return name;
    }

    static {
        PRINTER_TYPE_NAMES = new String[]{Messages.getString("VirtualPrinter.0"), Messages.getString("VirtualPrinter.1"), Messages.getString("VirtualPrinter.2"), Messages.getString("VirtualPrinter.3"), "", Messages.getString("VirtualPrinter.5"), Messages.getString("VirtualPrinter.6")};
    }
}

