/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BaseActionHistoryDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ActionHistoryDAO
extends BaseActionHistoryDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    public void saveOrUpdateActionHistory(List<ActionHistory> actionHistoryList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (actionHistoryList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (ActionHistory item : actionHistoryList) {
                ActionHistory existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getActionName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem);
                    continue;
                }
                item.setVersion(0L);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    public static void saveHistory(User performer, Ticket ticket, PosTransaction posTransaction, String actionName, String description) {
        Transaction transaction = null;
        try (Session session = ActionHistoryDAO.getInstance().createNewSession();){
            transaction = session.beginTransaction();
            ActionHistoryDAO.saveHistory(performer, ticket, posTransaction, actionName, description, session);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            LogFactory.getLog(ActionHistoryDAO.class).error((Object)"Error occured while trying to save action history", (Throwable)e);
        }
    }

    public static void saveHistory(User performer, Ticket ticket, String actionName, String description) {
        ActionHistoryDAO.saveHistory(performer, ticket, null, actionName, description);
    }

    public static void saveHistory(Ticket ticket, String actionName, String description) {
        ActionHistoryDAO.saveHistory(Application.getCurrentUser(), ticket, null, actionName, description);
    }

    public static void saveHistory(String actionName, String description) {
        ActionHistoryDAO.saveHistory(Application.getCurrentUser(), null, null, actionName, description);
    }

    public static void saveHistory(String actionName, String description, Session session) {
        ActionHistoryDAO.saveHistory(Application.getCurrentUser(), null, null, actionName, description, session);
    }

    public static void saveHistory(User performer, String actionName, String description) {
        ActionHistoryDAO.saveHistory(performer, null, null, actionName, description);
    }

    public static void saveHistory(User performer, Ticket ticket, PosTransaction transaction, String actionName, String description, Session session) {
        ActionHistory history = new ActionHistory();
        history.setActionName(actionName);
        history.setDescription(description);
        history.setPerformer(performer);
        history.setActionTime(StoreDAO.getServerTimestamp());
        if (ticket != null) {
            history.setTicketId(ticket.getId());
        }
        if (transaction != null) {
            history.setTransactionId(transaction.getId());
        }
        ActionHistoryDAO.getInstance().save(history, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(Map<String, ActionHistory> historyMap) {
        ActionHistoryDAO instance2 = ActionHistoryDAO.getInstance();
        Transaction transaction = null;
        try (Session session = instance2.createNewSession();){
            transaction = session.beginTransaction();
            for (ActionHistory actionHistory : historyMap.values()) {
                instance2.save(actionHistory, session);
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            historyMap.clear();
        }
    }

    public void performActionHistorySaveOperation(Ticket ticket, boolean newOrder) {
        if (ticket == null) {
            return;
        }
        this.performSave(ticket, newOrder);
    }

    private void populateEventsDescription(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        Map<String, ActionHistory> events = ticket.getEvents();
        if (events.isEmpty()) {
            return;
        }
        Collection<ActionHistory> histories = events.values();
        histories.forEach(history -> {
            history.setTicketId(ticket.getId());
            Object objectReference = history.getObjectReference();
            String description = history.getDescription();
            if (objectReference instanceof TicketDiscount) {
                TicketDiscount ticketDiscount = (TicketDiscount)objectReference;
                description = ticketDiscount.getType() == 3 ? String.format("Ticket id : %s, Loyalty points : %s", ticketDiscount.getTicket().getId(), ticketDiscount.getLoyaltyPoint()) : String.format("Ticket id : %s, Discount id : %s, Coupon quantity : %s", ticketDiscount.getTicket().getId(), ticketDiscount.getDiscountId(), ticketDiscount.getCouponQuantity());
            } else if (objectReference instanceof TicketItemDiscount) {
                TicketItemDiscount itemDiscount = (TicketItemDiscount)objectReference;
                TicketItem ticketItem = itemDiscount.getTicketItem();
                description = String.format("Ticket id : %s, Item id : %s, Discount id : %s, Coupon quantity : %s", ticket != null ? ticket.getId() : "", ticketItem != null ? ticketItem.getId() : "", itemDiscount.getDiscountId(), itemDiscount.getCouponQuantity());
            } else if (history.getActionName() == "Tax exempt" && ticket.isTaxExempt().booleanValue()) {
                String exemptId = ticket.getProperty("tax_exempt_id");
                description = String.format("Ticket id : %s, Exempt id : %s", ticket.getId(), exemptId);
            } else if (history.getActionName() == "New check") {
                description = String.format("Check#: %s", ticket.getId());
            }
            history.setDescription(description);
        });
    }

    public void performSave(Ticket ticket, boolean newOrder) {
        if (ticket == null) {
            return;
        }
        try {
            this.populateEventsDescription(ticket);
            ActionHistoryDAO.save(ticket.getEvents());
        }
        catch (Exception e) {
            PosLog.error(this.getReferenceClass(), e);
        }
    }

    public static void addDiscountRemovedActionHistory(Ticket ticket, TicketDiscount ticketDiscount) {
        if (ticket == null) {
            return;
        }
        String key = String.valueOf(ticketDiscount.hashCode());
        if (ticket.getEvents().containsKey(key)) {
            ticket.getEvents().remove(key);
        } else {
            String action = ticketDiscount.getType() == 3 ? "Loyalty removed" : "Ticket discount removed";
            ActionHistoryDAO.addActionHistory(ticket, key, action, null, ticketDiscount);
        }
    }

    public static void addDiscountAddedActionHistory(Ticket ticket, TicketDiscount ticketDiscount) {
        if (ticket == null) {
            return;
        }
        String key = String.valueOf(ticketDiscount.hashCode());
        String action = ticketDiscount.getType() == 3 ? "Loyalty added" : "Ticket discount added";
        ActionHistoryDAO.addActionHistory(ticket, key, action, null, ticketDiscount);
    }

    public static void addSetGratuityActionHistory(Ticket ticket, Gratuity gratuity) {
        if (ticket == null) {
            return;
        }
        if (ticket.getId() == null) {
            return;
        }
        String action = "Gratuity set";
        String key = "Gratuity set";
        String description = String.format("Ticket id : %s, Gratuity amount : %s", ticket.getId(), gratuity == null ? 0.0 : gratuity.getAmount());
        ActionHistoryDAO.addActionHistory(ticket, key, action, description, gratuity);
    }

    public static void addTableAddedActionHistory(Ticket ticket, List<ShopTable> tables) {
        if (ticket == null) {
            return;
        }
        if (ticket.getId() == null) {
            return;
        }
        if (tables == null) {
            return;
        }
        String action = "Table change";
        String key = "Table change";
        StringBuilder tableIds = new StringBuilder();
        Iterator<ShopTable> iterator = tables.iterator();
        while (iterator.hasNext()) {
            ShopTable table = iterator.next();
            tableIds.append(table.getId());
            if (!iterator.hasNext()) continue;
            tableIds.append(", ");
        }
        String description = String.format("Ticket id : %s, Tables : %s", ticket.getId(), tableIds.toString());
        ActionHistoryDAO.addActionHistory(ticket, key, action, description, tables);
    }

    public static void addSalesAreaAddedActionHistory(Ticket ticket, SalesArea salesArea) {
        if (ticket == null) {
            return;
        }
        if (ticket.getId() == null) {
            return;
        }
        if (salesArea == null) {
            return;
        }
        String action = "Sales area change";
        String key = "Sales area change";
        String description = String.format("Ticket id : %s, Sales area : %s", ticket.getId(), salesArea.getName());
        ActionHistoryDAO.addActionHistory(ticket, key, action, description, salesArea);
    }

    public static void addTicketItemDiscountRemovedActionHistory(Ticket ticket, TicketItemDiscount itemDiscount) {
        if (ticket == null) {
            return;
        }
        String key = String.valueOf(itemDiscount.hashCode());
        if (ticket.getEvents().containsKey(key)) {
            ticket.getEvents().remove(key);
        } else {
            ActionHistoryDAO.addActionHistory(ticket, key, "Item discount removed", null, itemDiscount);
        }
    }

    public static void addTicketItemDiscountAddedActionHistory(Ticket ticket, TicketItemDiscount itemDiscount) {
        if (ticket == null) {
            return;
        }
        String key = String.valueOf(itemDiscount.hashCode());
        ActionHistoryDAO.addActionHistory(ticket, key, "Item discount added", null, itemDiscount);
    }

    public static void addSplitTicketActionHistory(Ticket parentTicket, List<Ticket> splitTickets) {
        if (parentTicket == null) {
            return;
        }
        if (parentTicket.getId() == null || splitTickets == null) {
            return;
        }
        try {
            String splitType = parentTicket.getProperty("SPLIT_TYPE");
            ActionHistoryDAO dao = ActionHistoryDAO.getInstance();
            splitTickets.forEach(ticket -> {
                Map<String, ActionHistory> events = ticket.getEvents();
                String action = "Split check";
                String key = "Split check";
                String description = String.format("Parent ticket id : %s, Ticket id : %s, Split type : %s", parentTicket.getId(), ticket.getId(), splitType);
                ActionHistory history = ActionHistory.create(ticket, action, description);
                history.setObjectReference(ticket);
                events.put(key, history);
                dao.performSave((Ticket)ticket, !parentTicket.getId().equals(ticket.getId()));
            });
        }
        catch (Exception e) {
            PosLog.error(ActionHistory.class, e);
        }
    }

    public static void addItemVoidedActionHistory(Ticket ticket, TicketItem ticketItem, double voidQuantity) {
        if (ticket == null || ticket.getId() == null || ticketItem == null) {
            return;
        }
        String key = String.valueOf(ticketItem.hashCode());
        String action = "Ticket item void";
        String description = String.format("Ticket id : %s, Item id : %s, Void quantity : %s", ticket.getId(), ticketItem.getId(), voidQuantity);
        ActionHistoryDAO.addActionHistory(ticket, key, action, description, ticketItem);
    }

    public static void addActionHistory(Ticket ticket, String action, String description) {
        ActionHistoryDAO.addActionHistory(ticket, action, action, description);
    }

    public static void addActionHistory(Ticket ticket, String key, String action, String description) {
        ActionHistoryDAO.addActionHistory(ticket, key, action, description, null);
    }

    public static void addActionHistory(Ticket ticket, String key, String action, String description, Object objectReference) {
        if (ticket == null) {
            return;
        }
        ActionHistory history = ActionHistory.create(ticket, action, description);
        history.setObjectReference(objectReference);
        ticket.getEvents().put(key, history);
    }
}

