/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.dao.BaseCronJobDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public class CronJobDAO
extends BaseCronJobDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        CronJob bean = (CronJob)obj;
        if (bean == null) {
            throw new PosException(Messages.getString("CronJobDAO.0"));
        }
        bean.setDeleted(Boolean.TRUE);
        this.update(bean, session);
    }

    @Override
    public List<CronJob> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public List<CronJob> findAllActive() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(CronJob.class);
            criteria.add((Criterion)Restrictions.eq((String)CronJob.PROP_ACTIVE, (Object)true));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CronJob> findCronJobByJobName(String jobName) {
        List cronJobs = null;
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(CronJob.class);
            if (StringUtils.isNotEmpty((String)jobName)) {
                criteria.add(Restrictions.ilike((String)CronJob.PROP_JOB_NAME, (String)jobName, (MatchMode)MatchMode.ANYWHERE));
            }
            this.addDeletedFilter(criteria);
            cronJobs = criteria.list();
        }
        finally {
            this.closeSession(session);
        }
        return cronJobs;
    }

    @Override
    public void saveOrUpdate(CronJob cronJob) {
        try {
            CronJob storedCronJob = super.get(cronJob.getId());
            if (storedCronJob == null) {
                storedCronJob = new CronJob();
                storedCronJob.setExecutionTime(cronJob.getExecutionTime());
                storedCronJob.setFrequency(cronJob.getFrequency());
                storedCronJob.setJobId(cronJob.getJobId());
                storedCronJob.setJobName(cronJob.getJobName());
                storedCronJob.setLastSyncTime(cronJob.getLastSyncTime());
                storedCronJob.setLastUpdateTime(cronJob.getLastUpdateTime());
                storedCronJob.setProperties(cronJob.getProperties());
                storedCronJob.setId(cronJob.getId());
                storedCronJob.setActive(cronJob.isActive());
                super.save(storedCronJob);
            } else {
                storedCronJob.setExecutionTime(cronJob.getExecutionTime());
                storedCronJob.setFrequency(cronJob.getFrequency());
                storedCronJob.setJobId(cronJob.getJobId());
                storedCronJob.setJobName(cronJob.getJobName());
                storedCronJob.setLastSyncTime(cronJob.getLastSyncTime());
                storedCronJob.setLastUpdateTime(cronJob.getLastUpdateTime());
                storedCronJob.setProperties(cronJob.getProperties());
                storedCronJob.setActive(cronJob.isActive());
                super.update(storedCronJob);
            }
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), e0);
        }
    }

    public void saveOrUpdateCronJob(List<CronJob> salesAreaList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (salesAreaList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (CronJob item : salesAreaList) {
                CronJobDAO dao = CronJobDAO.getInstance();
                CronJob existingItem = dao.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getJobName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    dao.update(existingItem);
                    continue;
                }
                item.setVersion(0L);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                dao.save(item);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

