/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuDiscountRelation;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.BaseMenuDiscountRelationDAO;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class MenuDiscountRelationDAO
extends BaseMenuDiscountRelationDAO {
    public List<Discount> getAutoApplyDiscounts(MenuItem menuItem, OrderType orderType) {
        Date currentDate = new Date();
        try (Session session = this.createNewSession();){
            DetachedCriteria menuDiscountCriteria = DetachedCriteria.forClass(MenuDiscountRelation.class);
            menuDiscountCriteria.setProjection((Projection)Property.forName((String)MenuDiscountRelation.PROP_DISCOUNT_ID));
            Disjunction or = Restrictions.disjunction();
            or.add(Restrictions.in((String)MenuDiscountRelation.PROP_MENUITEM_ID, Arrays.asList(menuItem.getId())));
            if (StringUtils.isNotBlank((String)menuItem.getMenuCategoryId())) {
                or.add(Restrictions.in((String)MenuDiscountRelation.PROP_MENUCATEGORY_ID, Arrays.asList(menuItem.getMenuCategoryId())));
            }
            if (StringUtils.isNotBlank((String)menuItem.getMenuGroupId())) {
                or.add(Restrictions.in((String)MenuDiscountRelation.PROP_MENUGROUP_ID, Arrays.asList(menuItem.getMenuGroupId())));
            }
            if (StringUtils.isNotBlank((String)orderType.getId())) {
                or.add(Restrictions.in((String)MenuDiscountRelation.PROP_ORDER_TYPE_ID, Arrays.asList(orderType.getId())));
            }
            menuDiscountCriteria.add((Criterion)or);
            Criteria criteria = session.createCriteria(Discount.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_AUTO_APPLY, (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)Discount.PROP_ENABLED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_QUALIFICATION_TYPE, (Object)0), (Criterion)Restrictions.eq((String)Discount.PROP_TYPE, (Object)2)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Discount.PROP_NEVER_EXPIRE, (Object)Boolean.TRUE), (Criterion)Restrictions.ge((String)Discount.PROP_EXPIRY_DATE, (Object)currentDate)));
            criteria.add(Property.forName((String)Discount.PROP_ID).in(menuDiscountCriteria));
            List list = criteria.list();
            return list;
        }
    }
}

