/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.dao.BaseMenuItemSizeDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.PizzaModifierPriceDAO;
import com.floreantpos.model.dao.PizzaPriceDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public class MenuItemSizeDAO
extends BaseMenuItemSizeDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    public List<MenuItemSize> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void delete(Object obj, Session session) {
        MenuItemSize menuItemSize;
        if (obj instanceof MenuItemSize) {
            List<String> listOfModifierPriceId;
            menuItemSize = (MenuItemSize)obj;
            session.refresh((Object)menuItemSize);
            List<String> listOfPriceId = PizzaPriceDAO.getInstance().findByMenuItemSize(menuItemSize, session);
            if (listOfPriceId != null && !listOfPriceId.isEmpty()) {
                MenuItemDAO.getInstance().removePizzaPrices(listOfPriceId, session);
            }
            if ((listOfModifierPriceId = PizzaModifierPriceDAO.getInstance().findByMenuItemSize(menuItemSize, session)) != null && !listOfModifierPriceId.isEmpty()) {
                MenuModifierDAO.getInstance().removePizzaModifierPrices(listOfModifierPriceId, session);
            }
        } else {
            throw new PosException(Messages.getString("MenuItemSizeDAO.0"));
        }
        menuItemSize.setDeleted(Boolean.TRUE);
        super.update(menuItemSize, session);
    }

    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)MenuItemSize.PROP_SORT_ORDER);
    }

    public void saveOrUpdateSizeList(List<MenuItemSize> items, Session session) {
        for (MenuItemSize menuItemSize : items) {
            session.saveOrUpdate((Object)menuItemSize);
        }
    }

    public void saveOrUpdateList(List<MenuItemSize> sizeList) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.saveOrUpdateSizeList(sizeList, session);
            tx.commit();
        }
    }

    public void saveOrUpdateMenuItemSize(List<MenuItemSize> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (MenuItemSize item : dataList) {
                MenuItemSize existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) continue;
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

