/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseMenuPageDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.swing.PaginatedListModel;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class MenuPageDAO
extends BaseMenuPageDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdatePages(List<MenuPage> items) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (MenuPage menuPage : items) {
                session.saveOrUpdate((Object)menuPage);
            }
            tx.commit();
        }
    }

    public List<MenuPage> findByGroup(MenuGroup menuGroup) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
    }

    public void loadItems(Terminal terminal, MenuGroup menuGroup, OrderType selectedOrderType, Boolean visible, PaginatedListModel listModel) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            this.addOrderTypeCriteria(selectedOrderType, criteria);
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            listModel.setNumRows(this.rowCount(criteria));
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(1);
            listModel.setData(criteria.list());
        }
    }

    private void addOrderTypeCriteria(OrderType selectedOrderType, Criteria criteria) {
        if (selectedOrderType != null) {
            String id = selectedOrderType.getId();
            Criterion orderIdEqual = Restrictions.eqOrIsNull((String)MenuPage.PROP_ORDER_TYPE_ID, (Object)id);
            Criterion ilike = Restrictions.ilike((String)MenuPage.PROP_ORDER_TYPE_IDS, (String)id, (MatchMode)MatchMode.ANYWHERE);
            Criterion ilikeAll = Restrictions.ilike((String)MenuPage.PROP_ORDER_TYPE_IDS, (String)POSConstants.ALL, (MatchMode)MatchMode.ANYWHERE);
            Criterion isNullOrderIds = Restrictions.eqOrIsNull((String)MenuPage.PROP_ORDER_TYPE_IDS, null);
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{orderIdEqual, ilike, ilikeAll, isNullOrderIds}));
        }
    }

    public void deleteAll(List<MenuPage> items) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.deleteAll(items, session);
            tx.commit();
        }
    }

    public void deleteAll(List<MenuPage> items, Session session) {
        for (MenuPage menuPage : items) {
            MenuPage menuPage2 = (MenuPage)session.get(MenuPage.class, (Serializable)((Object)menuPage.getId()));
            session.delete((Object)menuPage2);
        }
    }

    public void addToMenuGroupEndPage(MenuItem mnuItem) {
        if (mnuItem.getMenuGroupId() == null) {
            return;
        }
        MenuItemDAO.getInstance().initialize(mnuItem);
        MenuPage page = this.getLastPage(mnuItem.getMenuGroupId());
        MenuPageItem menuPageItem = new MenuPageItem(null, null, mnuItem, page);
        for (int i = 0; i < page.getRows(); ++i) {
            for (int j = 0; j < page.getCols(); ++j) {
                if (page.getItemForCell(j, i) != null) continue;
                menuPageItem.setCol(j);
                menuPageItem.setRow(i);
                menuPageItem.setMenuPage(page);
                MenuPageItemDAO.getInstance().saveOrUpdate(page);
                return;
            }
        }
    }

    private MenuPage getLastPage(String menuGroupId) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)menuGroupId));
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            List list = criteria.list();
            MenuPage page = null;
            if (list != null && !list.isEmpty()) {
                page = (MenuPage)list.get(list.size() - 1);
            }
            List<MenuPageItem> pageItems = null;
            if (page != null) {
                pageItems = MenuPageItemDAO.getInstance().getPageItems(page);
            }
            if (page == null || pageItems != null && !pageItems.isEmpty() && pageItems.size() == page.getRows() * page.getCols()) {
                page = new MenuPage();
                page.setMenuGroupId(menuGroupId);
                int pageNumber = list.size() + 1;
                page.setName("Page " + pageNumber);
                page.setSortOrder(pageNumber);
                page.setCols(5);
                page.setRows(5);
                page.setButtonHeight(120);
                page.setButtonWidth(120);
                page.setVisible(true);
            }
            MenuPage menuPage = page;
            return menuPage;
        }
    }

    public void initialize(MenuPage menuPage) {
        if (menuPage == null || Hibernate.isInitialized(menuPage.getPageItems())) {
            return;
        }
        try (Session session = this.createNewSession();){
            session.refresh((Object)menuPage);
            Hibernate.initialize(menuPage.getPageItems());
        }
    }

    public MenuPage getInitialized(String menuPageId) {
        if (menuPageId == null) {
            return null;
        }
        try (Session session = this.createNewSession();){
            MenuPage menuPage = (MenuPage)session.get(MenuPage.class, (Serializable)((Object)menuPageId));
            Hibernate.initialize(menuPage.getPageItems());
            MenuPage menuPage2 = menuPage;
            return menuPage2;
        }
    }

    public int getRowCount(Terminal terminal, List<String> menuGroupIds, Object selectedOrderType) {
        if (menuGroupIds == null || menuGroupIds.size() == 0) {
            return 0;
        }
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.in((String)MenuPage.PROP_MENU_GROUP_ID, menuGroupIds));
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, List<String> menuGroupIds, OrderType selectedOrderType, Boolean visible, PaginatedListModel listModel) {
        if (menuGroupIds == null || menuGroupIds.size() == 0) {
            return;
        }
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            criteria.add(Restrictions.in((String)MenuPage.PROP_MENU_GROUP_ID, menuGroupIds));
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(1);
            listModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateMenuPageList(List<MenuPage> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (MenuPage menuPage : dataList) {
                MenuPage existingMenuPage = this.get(menuPage.getId());
                if (existingMenuPage != null) {
                    this.initialize(existingMenuPage);
                }
                List<MenuPageItem> pageItems = menuPage.getPageItems();
                menuPage.setUpdateLastUpdateTime(updateLastUpdateTime);
                menuPage.setUpdateSyncTime(updateSyncTime);
                menuPage.setPageItems(null);
                this.saveOrUpdateMenuPage(session, menuPage, existingMenuPage);
                this.saveOrUpdateMenuPageItems(session, menuPage, existingMenuPage, pageItems);
                menuPage.setPageItems(pageItems);
                this.saveOrUpdate(menuPage, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    private void saveOrUpdateMenuPageItems(Session session, MenuPage menuPage, MenuPage existingMenuPage, List<MenuPageItem> pageItems) {
        if (pageItems == null || pageItems.isEmpty()) {
            return;
        }
        List<MenuPageItem> existingPageItems = null;
        if (existingMenuPage != null) {
            existingPageItems = existingMenuPage.getPageItems();
        }
        for (MenuPageItem pageItem : pageItems) {
            pageItem.setMenuPage(menuPage);
            this.saveOrUpdateMenuPageItem(session, pageItem, existingPageItems);
        }
    }

    private void saveOrUpdateMenuPageItem(Session session, MenuPageItem pageItem, List<MenuPageItem> existingPageItems) {
        MenuPageItemDAO menuPageItemDAO = new MenuPageItemDAO();
        MenuPageItem existingMenuPageItem = null;
        if (existingPageItems == null || existingPageItems.isEmpty()) {
            menuPageItemDAO.save(pageItem, session);
        } else {
            int idx = existingPageItems.indexOf(pageItem);
            if (idx != -1) {
                existingMenuPageItem = existingPageItems.get(idx);
                if (existingMenuPageItem == null) {
                    menuPageItemDAO.save(pageItem, session);
                } else {
                    pageItem.setVersion(existingMenuPageItem.getVersion());
                }
            } else {
                menuPageItemDAO.save(pageItem, session);
            }
        }
    }

    private void saveOrUpdateMenuPage(Session session, MenuPage menuPage, MenuPage existingMenuPage) {
        if (existingMenuPage == null) {
            this.save(menuPage, session);
        } else {
            menuPage.setVersion(existingMenuPage.getVersion());
        }
    }
}

