/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.dao.BaseMultiplierDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class MultiplierDAO
extends BaseMultiplierDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void delete(Object obj, Session s) {
        if (obj instanceof Multiplier) {
            Multiplier multiplier = (Multiplier)obj;
            String hql = "DELETE FROM %s MMP WHERE MMP.%s=:m_id";
            hql = String.format(hql, ModifierMultiplierPrice.REF, ModifierMultiplierPrice.PROP_MULTIPLIER_ID);
            Query query = s.createQuery(hql);
            query.setParameter("m_id", (Object)multiplier.getId());
            query.executeUpdate();
            multiplier.setDeleted(Boolean.TRUE);
            super.update(multiplier, s);
        } else {
            super.delete(obj, s);
        }
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Multiplier> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)Multiplier.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            return null;
        }
    }

    public void saveOrUpdateMultipliers(List<Multiplier> items) {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (Multiplier multiplier : items) {
                session.saveOrUpdate((Object)multiplier);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            PosLog.error(this.getClass(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Multiplier getDefaultMutltiplier() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Multiplier.PROP_DEFAULT_MULTIPLIER, (Object)Boolean.TRUE));
            List list = criteria.list();
            if (list == null) return null;
            if (list.isEmpty()) return null;
            Multiplier multiplier = (Multiplier)list.get(0);
            return multiplier;
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        return null;
    }

    public boolean nameExists(String name) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Multiplier.PROP_ID, (Object)name).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = rowCount.intValue() > 0;
            return bl;
        }
    }

    public void deleteMultiplier(Multiplier multiplier) {
        this.delete(multiplier);
    }

    public void saveOrUpdateMultiplierList(List<Multiplier> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Multiplier item : dataList) {
                Multiplier existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getId() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

