/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.BaseOutletDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;

public class OutletDAO
extends BaseOutletDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime((Outlet)obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime((Outlet)obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime((Outlet)obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outlet initialize(Outlet outlet) {
        if (outlet == null || outlet.getId() == null) {
            return outlet;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)outlet);
            Hibernate.initialize(outlet.getDepartments());
            Outlet outlet2 = outlet;
            return outlet2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateOutlets(List<Outlet> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Outlet item : dataList) {
                Outlet existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setVersion(0L);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutletSyncable(String outletId) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (outletId != null) {
                criteria.add((Criterion)Restrictions.eq((String)Outlet.PROP_ID, (Object)outletId));
            }
            Criterion nullUpdateTime = Restrictions.isNull((String)Outlet.PROP_LAST_UPDATE_TIME);
            Criterion nullSyncTime = Restrictions.isNull((String)Outlet.PROP_LAST_SYNC_TIME);
            PropertyExpression gtQuery = Restrictions.gtProperty((String)Outlet.PROP_LAST_UPDATE_TIME, (String)Outlet.PROP_LAST_SYNC_TIME);
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{nullUpdateTime, nullSyncTime, gtQuery}));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List result = criteria.list();
            if (result.size() == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }
}

