/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.dao.BasePackagingUnitDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class PackagingUnitDAO
extends BasePackagingUnitDAO {
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_DOT_STRING = ".";
    private static final String EMPTY_NEWLINE_STRING = "\n";
    private static final String EMPTY_SPACE_STRING = " ";

    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session s) {
        if (obj instanceof PackagingUnit) {
            PackagingUnit packagingUnit = (PackagingUnit)obj;
            List<MenuItem> menuItems = MenuItemDAO.getInstance().getMenuItemsByPackagingUnit(packagingUnit, s);
            if (menuItems != null && !menuItems.isEmpty()) {
                String message = packagingUnit.getName() + EMPTY_SPACE_STRING + Messages.getString("PackagingUnitDAO.4");
                String details = this.constructExceptionDetailsByMenuItems(packagingUnit, menuItems);
                throw new PosException(message, details);
            }
            packagingUnit.setDeleted(Boolean.TRUE);
            super.update(packagingUnit, s);
        } else {
            super.delete(obj, s);
        }
    }

    private String constructExceptionDetailsByMenuItems(PackagingUnit packagingUnit, List<MenuItem> menuItems) {
        if (menuItems != null && !menuItems.isEmpty()) {
            StringBuilder builder = new StringBuilder(packagingUnit.getName() + EMPTY_SPACE_STRING + Messages.getString("PackagingUnitDAO.5"));
            for (int i = 0; i < menuItems.size(); ++i) {
                String message = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + menuItems.get(i).getName();
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return EMPTY_STRING;
    }

    public boolean nameExists(PackagingUnit packagingUnit, String code) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(InventoryUnit.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_CODE, (Object)code).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null && rowCount.intValue() > 0) {
                boolean bl = true;
                return bl;
            }
            criteria = session.createCriteria(PackagingUnit.class);
            this.addDeletedFilter(criteria);
            if (packagingUnit != null && packagingUnit.getId() != null) {
                criteria.add((Criterion)Restrictions.ne((String)InventoryUnit.PROP_ID, (Object)packagingUnit.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)InventoryUnit.PROP_CODE, (Object)code).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null && rowCount.intValue() > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public List<PackagingUnit> findAll() {
        return this.findAll(false);
    }

    public List<PackagingUnit> findAll(boolean recipeUnit) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (recipeUnit) {
                criteria.add((Criterion)Restrictions.eq((String)PackagingUnit.PROP_RECIPE_UNIT, (Object)true));
            } else {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PackagingUnit.PROP_RECIPE_UNIT), (Criterion)Restrictions.eq((String)PackagingUnit.PROP_RECIPE_UNIT, (Object)recipeUnit)));
            }
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdatePackagingUnits(List<PackagingUnit> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            ArrayList<String> uniqueNames = new ArrayList<String>();
            for (PackagingUnit item : dataList) {
                if (uniqueNames.contains(item.getName())) {
                    item.setName(item.getName() + "_");
                }
                uniqueNames.add(item.getName());
                PackagingUnit existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

