/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.BasePayOutTransactionDAO;
import com.floreantpos.model.util.DataProvider;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class PayOutTransactionDAO
extends BasePayOutTransactionDAO {
    public void saveTransaction(PayOutTransaction t, Terminal terminal) throws Exception {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            session.saveOrUpdate((Object)t);
            session.saveOrUpdate((Object)terminal);
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public void createPayoutTransaction(PayoutReason reason, PayoutRecepient recepient, String note, double payoutAmount, User currentUser, Terminal drawerTerminal) throws Exception {
        StoreSession storeSession = DataProvider.get().getStoreSession();
        if (storeSession == null && drawerTerminal.getCurrentCashDrawer() != null) {
            storeSession = drawerTerminal.getCurrentCashDrawer().getStoreSession();
        }
        PayOutTransaction payOutTransaction = new PayOutTransaction();
        payOutTransaction.setPaymentType(PaymentType.CASH);
        payOutTransaction.setTransactionType(TransactionType.DEBIT.name());
        payOutTransaction.setReason(reason);
        payOutTransaction.setRecepient(recepient);
        payOutTransaction.setNote(note);
        payOutTransaction.setAmount(payoutAmount);
        payOutTransaction.setCashDrawer(currentUser.getActiveDrawerPullReport());
        if (storeSession != null) {
            payOutTransaction.setStoreSessionId(storeSession.getId());
        }
        payOutTransaction.setUser(currentUser);
        payOutTransaction.setServer(currentUser);
        payOutTransaction.setTransactionTime(new Date());
        payOutTransaction.setTerminal(drawerTerminal);
        this.saveTransaction(payOutTransaction, drawerTerminal);
    }

    public List<PayOutTransaction> getUnsettled(Terminal terminal, User cashier) {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PayOutTransaction.PROP_DRAWER_RESETTED, (Object)Boolean.FALSE));
            if (cashier == null) {
                criteria.add((Criterion)Restrictions.eq((String)PayOutTransaction.PROP_TERMINAL_ID, (Object)(terminal == null ? null : terminal.getId())));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)PayOutTransaction.PROP_USER_ID, (Object)cashier.getId()));
            }
            List list2 = list = criteria.list();
            return list2;
        }
    }
}

