/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.BasePrinterGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class PrinterGroupDAO
extends BasePrinterGroupDAO {
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_DOT_STRING = ".";
    private static final String EMPTY_NEWLINE_STRING = "\n";
    private static final String EMPTY_SPACE_STRING = " ";

    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void delete(Object obj, Session s) {
        if (obj instanceof PrinterGroup) {
            PrinterGroup printerGroup = (PrinterGroup)obj;
            List<MenuItem> menuItems = MenuItemDAO.getInstance().getMenuItemsByPrinterGroup(printerGroup, s);
            if (menuItems != null && !menuItems.isEmpty()) {
                String message = printerGroup.getName() + EMPTY_SPACE_STRING + Messages.getString("PrinterGroupDAO.0");
                String details = this.constructExceptionDetailsByMenuItems(printerGroup, menuItems);
                throw new PosException(message, details);
            }
            printerGroup.setDeleted(Boolean.TRUE);
            super.update(printerGroup, s);
        } else {
            super.delete(obj, s);
        }
    }

    private String constructExceptionDetailsByMenuItems(PrinterGroup printerGroup, List<MenuItem> menuItems) {
        if (menuItems != null && !menuItems.isEmpty()) {
            StringBuilder builder = new StringBuilder(printerGroup.getName() + EMPTY_SPACE_STRING + Messages.getString("PrinterGroupDAO.1"));
            for (int i = 0; i < menuItems.size(); ++i) {
                String message = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + menuItems.get(i).getName();
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return EMPTY_STRING;
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    public List<PrinterGroup> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdatePrinterGroup(List<PrinterGroup> printerGroupList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (printerGroupList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (PrinterGroup item : printerGroupList) {
                PrinterGroup existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem);
                    continue;
                }
                item.setVersion(0L);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public PrinterGroup findByName(String name, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)PrinterGroup.PROP_NAME, (Object)name));
        return (PrinterGroup)criteria.uniqueResult();
    }

    public PrinterGroup findByName(String name) {
        try (Session session = this.createNewSession();){
            PrinterGroup printerGroup = this.findByName(name, session);
            return printerGroup;
        }
    }

    public PrinterGroup getDefaultPrinterGroup() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)PrinterGroup.PROP_IS_DEFAULT, (Object)Boolean.TRUE));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                PrinterGroup printerGroup = (PrinterGroup)list.get(0);
                return printerGroup;
            }
            PrinterGroup printerGroup = null;
            return printerGroup;
        }
    }

    public List<PrinterGroup> getPrinterGroupsByVirtualPrinter(VirtualPrinter virtualPrinter, Session session) {
        ArrayList<PrinterGroup> printerGroups = null;
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        List list = criteria.list();
        if (list != null && !list.isEmpty()) {
            printerGroups = new ArrayList<PrinterGroup>();
            for (PrinterGroup printerGroup : list) {
                if (!printerGroup.getPrinterNames().contains(virtualPrinter.getName())) continue;
                printerGroups.add(printerGroup);
            }
        }
        return printerGroups;
    }
}

