/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.BaseRecepieDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.RecepieItemDAO;
import com.floreantpos.model.ext.InvMapKey;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.BeanTableModel;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class RecepieDAO
extends BaseRecepieDAO {
    @Override
    protected void delete(Object obj, Session session) {
        Recepie bean = (Recepie)obj;
        if (bean == null) {
            throw new PosException(Messages.getString("RecepieDAO.0"));
        }
        this.checkForeignRelation(bean);
        bean.setDeleted(Boolean.TRUE);
        this.update(bean, session);
    }

    private void checkForeignRelation(Recepie bean) throws PosException {
        try (Session session = this.createNewSession();){
            List<String> foreignItemNames = GenericDAO.getInstance().getForeignDataListNames(session, MenuItem.class, MenuItem.PROP_DEFAULT_RECIPE_ID, bean.getId());
            if (foreignItemNames != null && foreignItemNames.size() > 0) {
                String details = Messages.getString("RecepieDAO.1") + (foreignItemNames.size() > 1 ? Messages.getString("RecepieDAO.2") : ":");
                int count = 1;
                for (String itemName : foreignItemNames) {
                    details = details + "\n" + count + ". " + itemName;
                    ++count;
                }
                throw new PosException(Messages.getString("RecepieDAO.4"), details);
            }
        }
    }

    @Override
    public List<Recepie> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(String name, boolean subRecipeOnly) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Recepie.class);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)name)) {
                criteria.add(Restrictions.ilike((String)Recepie.PROP_NAME, (String)name.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            this.addDeletedFilter(criteria);
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRecepies(BeanTableModel<Recepie> model, String name, boolean subRecipeOnly) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Recepie.class);
            if (StringUtils.isNotEmpty((String)name)) {
                Disjunction disjunction = Restrictions.disjunction();
                disjunction.add(Restrictions.ilike((String)Recepie.PROP_NAME, (String)name.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.createAlias(Recepie.PROP_MENU_ITEM, "item");
                disjunction.add(Restrictions.ilike((String)"item.name", (String)name.trim(), (MatchMode)MatchMode.START));
                criteria.add((Criterion)disjunction);
            }
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            model.setNumRows(rowCount.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)Recepie.PROP_NAME));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List result = criteria.list();
            model.setRows(result);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Recepie> findBy(MenuItem menuItem) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Recepie.PROP_MENU_ITEM, (Object)menuItem));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Recepie findByName(String name, String id) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Recepie.PROP_NAME, (Object)name));
            if (StringUtils.isNotBlank((String)id)) {
                criteria.add((Criterion)Restrictions.ne((String)Recepie.PROP_ID, (Object)id));
            }
            criteria.setMaxResults(1);
            Recepie recepie = (Recepie)criteria.uniqueResult();
            return recepie;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<String> getForeignDataListNames(MenuItem menuItem) {
        try (Session session = this.createNewSession();){
            List<String> list = this.getForeignDataListNames(menuItem, session);
            return list;
        }
    }

    public List<String> getForeignDataListNames(MenuItem menuItem, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)Recepie.PROP_NAME)));
        criteria.createAlias("recepieItems", "items");
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Recepie.PROP_MENU_ITEM, (Object)menuItem), (Criterion)Restrictions.eq((String)("items." + RecepieItem.PROP_INVENTORY_ITEM), (Object)menuItem)));
        this.addDeletedFilter(criteria);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public void adjustInventory(Double mainItemQty, List<Recepie> recipes) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.adjustInventory(mainItemQty, recipes, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void adjustInventory(Double mainItemQty, List<Recepie> recipes, Session session) throws Exception {
        HashMap<InvMapKey, Double> itemMap = new HashMap<InvMapKey, Double>();
        HashMap<InvMapKey, Double> recipeMap = new HashMap<InvMapKey, Double>();
        for (Recepie recepie : recipes) {
            Double actualYieldValue = recepie.getYield();
            Double cookingYield = recepie.getCookingYield();
            MenuItem menuItem = recepie.getMenuItem();
            InvMapKey key = new InvMapKey(menuItem.getId(), menuItem.getUnit().getCode());
            Double previousValue = itemMap.get(key);
            if (previousValue == null) {
                previousValue = 0.0;
            }
            Double toBeAdjustQty = recepie.getPortion();
            if ((toBeAdjustQty = Double.valueOf(toBeAdjustQty + previousValue)) <= 0.0) continue;
            itemMap.put(key, toBeAdjustQty);
            recepie.populateRecipeItemQuantity(mainItemQty, recipeMap, cookingYield / actualYieldValue);
        }
        InventoryLocation defaultOutInventoryLocation = InventoryLocationDAO.getInstance().getDefaultOutInventoryLocation(session);
        InventoryLocation defaultInInventoryLocation = InventoryLocationDAO.getInstance().getDefaultInInventoryLocation(session);
        this.adjustInventory(itemMap, InventoryTransactionType.IN, "PREPARE IN", defaultInInventoryLocation, session);
        this.adjustInventory(recipeMap, InventoryTransactionType.OUT, "PREPARE OUT", defaultOutInventoryLocation, session);
    }

    public void adjustRecipeItemsFromInventory(Double mainItemQty, List<Recepie> recipes, Session session) throws Exception {
        HashMap<InvMapKey, Double> itemMap = new HashMap<InvMapKey, Double>();
        HashMap<InvMapKey, Double> recipeMap = new HashMap<InvMapKey, Double>();
        for (Recepie recepie : recipes) {
            Double actualYieldValue = recepie.getYield();
            Double cookingYield = recepie.getCookingYield();
            MenuItem menuItem = recepie.getMenuItem();
            InvMapKey menuItemUnit = new InvMapKey(menuItem.getId(), menuItem.getUnit().getCode());
            Double previousValue = (Double)itemMap.get(menuItemUnit);
            if (previousValue == null) {
                previousValue = 0.0;
            }
            Double toBeAdjustQty = recepie.getPortion();
            if ((toBeAdjustQty = Double.valueOf(toBeAdjustQty + previousValue)) <= 0.0) continue;
            itemMap.put(menuItemUnit, toBeAdjustQty);
            recepie.populateRecipeItemQuantity(mainItemQty, recipeMap, cookingYield / actualYieldValue);
        }
        InventoryLocation defaultOutInventoryLocation = InventoryLocationDAO.getInstance().getDefaultOutInventoryLocation(session);
        this.adjustInventory(recipeMap, InventoryTransactionType.OUT, "PREPARE OUT", defaultOutInventoryLocation, session);
    }

    private void adjustInventory(HashMap<InvMapKey, Double> itemMap, InventoryTransactionType transactionType, String reason, InventoryLocation location, Session session) throws Exception {
        Store store = DataProvider.get().getStore();
        boolean isUpdateOnHandBlncForSale = store.isUpdateOnHandBlncForSale();
        boolean isUpdateAvailBlncForSale = store.isUpdateAvlBlncForSale();
        for (InvMapKey menuItemKey : itemMap.keySet()) {
            String menuItemId = menuItemKey.getMenuItemId();
            Double unitQuantity = itemMap.get(menuItemKey);
            MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemWithFields(menuItemId, MenuItem.PROP_NAME, MenuItem.PROP_PRICE, MenuItem.PROP_SKU, MenuItem.PROP_BARCODE, MenuItem.PROP_UNIT_ID, MenuItem.PROP_COST, MenuItem.PROP_AVERAGE_UNIT_PURCHASE_PRICE, MenuItem.PROP_AVG_COST);
            if (menuItem == null || !menuItem.isInventoryItem().booleanValue()) continue;
            double baseUnitQuantity = menuItem.getBaseUnitQuantity(menuItemKey.getUnitCode());
            menuItem.setId(menuItemId);
            InventoryTransaction trans = new InventoryTransaction();
            trans.setReason(reason);
            trans.setTransactionDate(new Date());
            trans.setMenuItem(menuItem);
            trans.setType(transactionType.getType());
            trans.setUser(Application.getCurrentUser());
            trans.setUnitPrice(menuItem.getPrice() * baseUnitQuantity);
            trans.setQuantity(unitQuantity);
            if (menuItemKey.getUnitCode() != null) {
                trans.setUnit(menuItemKey.getUnitCode());
            } else {
                InventoryUnit unit = menuItem.getUnit();
                if (unit != null) {
                    trans.setUnit(unit.getCode());
                }
            }
            trans.setUnitCost(menuItem.getAverageUnitPurchasePrice());
            if (transactionType == InventoryTransactionType.IN) {
                trans.setToInventoryLocation(location);
            } else {
                trans.setFromInventoryLocation(location);
            }
            trans.calculateTotal();
            InventoryTransactionDAO.getInstance().adjustInventoryStock(trans, session, isUpdateAvailBlncForSale, isUpdateOnHandBlncForSale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMenuItemName(Recepie recepie) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias("menuItem", "item");
            criteria.setProjection((Projection)Projections.property((String)"item.name"));
            criteria.add((Criterion)Restrictions.eq((String)RecipeTable.PROP_ID, (Object)recepie.getId()));
            this.addDeletedFilter(criteria);
            String string = (String)criteria.uniqueResult();
            return string;
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected Serializable save(Object obj, Session s) {
        Recepie recepie = (Recepie)obj;
        if (this.nameExists(recepie.getId(), recepie.getName())) {
            throw new PosException(Messages.getString("RecepieDAO.6"));
        }
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        Recepie recepie = (Recepie)obj;
        if (this.nameExists(recepie.getId(), recepie.getName())) {
            throw new PosException(Messages.getString("RecepieDAO.6"));
        }
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        Recepie recepie = (Recepie)obj;
        if (this.nameExists(recepie.getId(), recepie.getName())) {
            throw new PosException(Messages.getString("RecepieDAO.6"));
        }
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(String id, String name) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)id)) {
                criteria.add((Criterion)Restrictions.ne((String)Recepie.PROP_ID, (Object)id));
            }
            criteria.add((Criterion)Restrictions.eq((String)Recepie.PROP_NAME, (Object)name).ignoreCase());
            this.addDeletedFilter(criteria);
            Number rowCount = (Number)criteria.uniqueResult();
            boolean bl = rowCount != null && rowCount.intValue() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateRecipes(List<Recepie> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        HashMap<String, MenuItem> itemMap = new HashMap<String, MenuItem>();
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (Recepie item : dataList) {
                List<RecepieItem> items = item.getRecepieItems();
                item.setRecepieItems(null);
                String recipeItemId = item.getMenuItem().getId();
                MenuItem existingRecipeMenuItem = (MenuItem)itemMap.get(recipeItemId);
                if (existingRecipeMenuItem == null) {
                    existingRecipeMenuItem = MenuItemDAO.getInstance().get(recipeItemId);
                    if (existingRecipeMenuItem == null) {
                        throw new Exception("No item found with id " + recipeItemId);
                    }
                    itemMap.put(existingRecipeMenuItem.getId(), existingRecipeMenuItem);
                }
                item.setMenuItem(existingRecipeMenuItem);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                RecepieDAO dao = RecepieDAO.getInstance();
                Recepie existingItem = dao.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getId() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    item.setVersion(version);
                } else {
                    this.save(item, session);
                }
                List<RecepieItem> existingItems = null;
                if (existingItem != null && existingItem.getRecepieItems() != null) {
                    existingItems = existingItem.getRecepieItems();
                }
                if (existingItems == null) {
                    existingItems = new ArrayList<RecepieItem>();
                }
                if (items != null && items.size() > 0) {
                    for (RecepieItem recipeItem : items) {
                        String itemId;
                        MenuItem inventoryItem = recipeItem.getInventoryItem();
                        if (inventoryItem == null || StringUtils.isEmpty((String)(itemId = inventoryItem.getId()))) continue;
                        MenuItem existingMenuItem = (MenuItem)itemMap.get(itemId);
                        if (existingMenuItem == null) {
                            existingMenuItem = MenuItemDAO.getInstance().get(itemId);
                            if (existingMenuItem == null) {
                                throw new Exception("No item found with id " + itemId);
                            }
                            itemMap.put(existingMenuItem.getId(), existingMenuItem);
                        }
                        recipeItem.setInventoryItem(existingMenuItem);
                        recipeItem.setRecepie(item);
                        int idx = existingItems.indexOf(recipeItem);
                        RecepieItem existingRecipeItem = null;
                        if (idx != -1) {
                            existingRecipeItem = existingItems.get(idx);
                            if (existingRecipeItem == null) {
                                recipeItem.setVersion(0L);
                                RecepieItemDAO.getInstance().save(recipeItem, session);
                                continue;
                            }
                            recipeItem.setVersion(existingRecipeItem.getVersion());
                            continue;
                        }
                        recipeItem.setVersion(0L);
                        RecepieItemDAO.getInstance().save(recipeItem, session);
                    }
                }
                item.setRecepieItems(items);
                this.saveOrUpdate(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }
}

