/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Reseller;
import com.floreantpos.model.dao.BaseResellerDAO;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ResellerDAO
extends BaseResellerDAO {
    public Reseller findByEmail(String userEmail) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Reseller.PROP_EMAIL, (Object)userEmail));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                Reseller reseller = (Reseller)list.get(0);
                return reseller;
            }
            Reseller reseller = null;
            return reseller;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reseller findById(String resellerId) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Reseller.PROP_ID, (Object)resellerId));
            Reseller reseller = (Reseller)criteria.uniqueResult();
            return reseller;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmailExistExceptCustomer(String email, Reseller customer) {
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Reseller.PROP_EMAIL, (Object)email));
            criteria.add((Criterion)Restrictions.ne((String)Reseller.PROP_ID, (Object)customer.getId()));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }
}

