/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Gratuity;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.GenericDAO;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class SFSyncDAO
extends GenericDAO {
    public static SFSyncDAO instance;

    public static SFSyncDAO getInstance() {
        if (null == instance) {
            instance = new SFSyncDAO();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findUnsyncedItemsCount() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(TicketItem.class);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_CLOUD_SYNCED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_HAS_SYNC_ERROR, (Object)false));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    public List<TicketItem> findUnsyncedItems() {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(TicketItem.class);
            criteria.createAlias(TicketItem.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_CLOSED), (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_CLOUD_SYNCED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_HAS_SYNC_ERROR, (Object)false));
            criteria.add(Restrictions.isNotNull((String)TicketItem.PROP_MENU_ITEM_ID));
            List list = criteria.list();
            return list;
        }
    }

    public List<TicketItem> findUnsyncedItems(String ticketId, List<String> returnTicketItemIds) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(TicketItem.class, "item");
            criteria.createAlias(TicketItem.PROP_TICKET, "ticket");
            if (returnTicketItemIds != null && !returnTicketItemIds.isEmpty()) {
                criteria.add(Restrictions.in((String)("item." + TicketItem.PROP_ID), returnTicketItemIds));
            }
            criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_ID), (Object)ticketId));
            criteria.add(Restrictions.eqOrIsNull((String)("item." + TicketItem.PROP_CLOUD_SYNCED), (Object)Boolean.FALSE));
            criteria.add(Restrictions.eqOrIsNull((String)("item." + TicketItem.PROP_HAS_SYNC_ERROR), (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_ITEM_RETURNED), (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
    }

    public List<TicketItem> findUnsyncedErrorItems() {
        return this.findUnsyncedErrorItems(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TicketItem> findUnsyncedErrorItems(Date fromDate, Date todate) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(TicketItem.class);
            criteria.createAlias("ticket", "ticket");
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_CLOUD_SYNCED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_HAS_SYNC_ERROR, (Object)true));
            if (fromDate != null && todate != null) {
                criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)fromDate, (Object)todate));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Gratuity> findUnsyncedGratuities() {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(Gratuity.class);
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_CLOUD_SYNCED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_HAS_SYNC_ERROR, (Object)false));
            criteria.add((Criterion)Restrictions.gt((String)Gratuity.PROP_AMOUNT, (Object)new Double(0.0)));
            List list = criteria.list();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Gratuity gratuity = (Gratuity)iterator.next();
                if (this.isGratuityValidForSync(gratuity)) continue;
                iterator.remove();
            }
            List list2 = list;
            return list2;
        }
    }

    private boolean isGratuityValidForSync(Gratuity gratuity) {
        Ticket ticket = gratuity.getTicket();
        if (ticket == null) {
            return false;
        }
        if (!ticket.isClosed().booleanValue()) {
            return false;
        }
        return gratuity.equals(ticket.getGratuity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Gratuity> findUnsyncedErrorGratuities() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Gratuity.class);
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_CLOUD_SYNCED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)Gratuity.PROP_HAS_SYNC_ERROR, (Object)true));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<PosTransaction> findUnsyncedTransactions() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(PosTransaction.class);
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_CLOSED), (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CLOUD_SYNCED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_HAS_SYNC_ERROR, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()), (Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.getDisplayString())));
            List list = criteria.list();
            list.addAll(this.findUnsyncedRefundedMemberTransactions());
            List list2 = list;
            return list2;
        }
    }

    public List<PosTransaction> findUnsyncedRefundedMemberTransactions() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(RefundTransaction.class);
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_CLOSED), (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CLOUD_SYNCED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_HAS_SYNC_ERROR, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()), (Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.getDisplayString())));
            List list = criteria.list();
            return list;
        }
    }

    public List<PosTransaction> findUnsyncedErrorTransactions() {
        return this.findUnsyncedErrorTransactions(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PosTransaction> findUnsyncedErrorTransactions(Date fromDate, Date todate) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(PosTransaction.class);
            criteria.createAlias("ticket", "ticket");
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CLOUD_SYNCED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_HAS_SYNC_ERROR, (Object)true));
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()), (Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.getDisplayString())));
            if (fromDate != null && todate != null) {
                criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)fromDate, (Object)todate));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsToUploadCostAndBalance(Date lastSyncDate) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItemInventoryStatus.class);
            if (lastSyncDate != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItemInventoryStatus.PROP_LAST_UPDATE_TIME), (Criterion)Restrictions.ge((String)MenuItemInventoryStatus.PROP_LAST_UPDATE_TIME, (Object)lastSyncDate)));
            }
            criteria.setProjection((Projection)Projections.property((String)MenuItemInventoryStatus.PROP_ID));
            List menuItemsIds = criteria.list();
            if (menuItemsIds == null || menuItemsIds.isEmpty()) {
                List<MenuItem> list = null;
                return list;
            }
            criteria = session.createCriteria(MenuItem.class);
            criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)menuItemsIds));
            criteria.addOrder(Order.desc((String)MenuItem.PROP_PARENT_MENU_ITEM_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }
}

