/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Department;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseSalesAreaDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class SalesAreaDAO
extends BaseSalesAreaDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        SalesArea bean = (SalesArea)obj;
        if (bean == null) {
            throw new PosException(Messages.getString("SalesAreaDAO.0"));
        }
        this.checkForeignRelation(bean);
        bean.setDeleted(Boolean.TRUE);
        this.update(bean, session);
    }

    private void checkForeignRelation(SalesArea bean) throws PosException {
        String id = bean.getId();
        StringBuilder ref = new StringBuilder();
        StringBuilder details = new StringBuilder();
        try (Session session = this.createNewSession();){
            GenericDAO dao = GenericDAO.getInstance();
            this.append(dao.getForeignDataListNames(session, OrderType.class, OrderType.PROP_SALES_AREA_ID, id), Messages.getString("SalesAreaDAO.1"), ref, details);
            this.append(dao.getForeignDataListNames(session, PriceRule.class, PriceRule.PROP_SALES_AREA_ID, id), Messages.getString("SalesAreaDAO.2"), ref, details);
            this.append(dao.getForeignDataListNames(session, ShopTable.class, ShopTable.PROP_SALES_AREA_ID, id), Messages.getString("SalesAreaDAO.3"), ref, details);
            this.append(dao.getForeignDataListNames(session, Terminal.class, Terminal.PROP_SALES_AREA_ID, id), Messages.getString("SalesAreaDAO.4"), ref, details);
        }
        String foreignItemDetails = details.toString();
        if (StringUtils.isNotBlank((String)foreignItemDetails)) {
            String foreignReferences = ref.toString();
            if (foreignReferences.endsWith(", ")) {
                foreignReferences = foreignReferences.substring(0, foreignReferences.length() - 2);
            }
            throw new PosException(Messages.getString("SalesAreaDAO.6") + foreignReferences + Messages.getString("SalesAreaDAO.7") + foreignReferences + ".", foreignItemDetails);
        }
    }

    private void append(List<String> foreignDataListNames, String ref, StringBuilder refDetails, StringBuilder details) {
        if (foreignDataListNames == null || foreignDataListNames.isEmpty()) {
            return;
        }
        details.append(Messages.getString("SalesAreaDAO.9") + ref + ":");
        refDetails.append(ref + ", ");
        int count = 1;
        for (String itemName : foreignDataListNames) {
            details.append("\n" + count + ". " + itemName);
            ++count;
        }
        details.append("\n");
    }

    @Override
    public List<SalesArea> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SalesArea> findSalesAreaByDept(Department department) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)SalesArea.PROP_DEPARTMENT_ID, (Object)department.getId()));
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesArea findById(String id) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)SalesArea.PROP_ID, (Object)id));
            this.addDeletedFilter(criteria);
            SalesArea salesArea = (SalesArea)criteria.uniqueResult();
            return salesArea;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesArea find(SalesArea salesArea) {
        Session session = null;
        try {
            if (salesArea == null) {
                SalesArea salesArea2 = null;
                return salesArea2;
            }
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)SalesArea.PROP_ID, (Object)salesArea.getId()));
            this.addDeletedFilter(criteria);
            SalesArea salesArea3 = (SalesArea)criteria.uniqueResult();
            return salesArea3;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesArea findByName(String name) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)SalesArea.PROP_NAME, (Object)name));
            this.addDeletedFilter(criteria);
            SalesArea salesArea = (SalesArea)criteria.uniqueResult();
            return salesArea;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateSalesArea(List<SalesArea> salesAreaList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (salesAreaList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (SalesArea item : salesAreaList) {
                SalesAreaDAO dao = SalesAreaDAO.getInstance();
                SalesArea existingItem = dao.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    dao.update(existingItem);
                    continue;
                }
                item.setVersion(0L);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                dao.save(item);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

