/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.dao.BaseSlideShowImageDAO;
import com.floreantpos.swing.PaginatedTableModel;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class SlideShowImageDAO
extends BaseSlideShowImageDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rowCount() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(SlideShowImage.class);
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImages(PaginatedTableModel model) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(SlideShowImage.class);
            criteria.addOrder(Order.asc((String)SlideShowImage.PROP_ID));
            criteria.addOrder(Order.asc((String)SlideShowImage.PROP_SORT_ORDER));
            int currentRowIndex = model.getCurrentRowIndex();
            criteria.setFirstResult(currentRowIndex);
            criteria.setMaxResults(model.getPageSize());
            criteria.setProjection((Projection)Projections.property((String)SlideShowImage.PROP_IMAGE_ID));
            List imageIds = criteria.list();
            if (imageIds == null || imageIds.isEmpty()) {
                model.setRows(null);
                return;
            }
            criteria = session.createCriteria(ImageResource.class);
            criteria.add(Restrictions.in((String)ImageResource.PROP_ID, (Collection)imageIds));
            List imageResources = criteria.list();
            model.setRows(imageResources);
        }
        catch (Exception e) {
            model.setRows(new ArrayList());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlideShowImage findByImageId(String imageId) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(SlideShowImage.class);
            criteria.add((Criterion)Restrictions.eq((String)SlideShowImage.PROP_IMAGE_ID, (Object)imageId));
            List result = criteria.list();
            if (result.size() == 0) {
                SlideShowImage slideShowImage = null;
                return slideShowImage;
            }
            SlideShowImage slideShowImage = (SlideShowImage)result.get(0);
            return slideShowImage;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll(List<ImageResource> imageResources) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ImageResource imgResource : imageResources) {
                SlideShowImage slideShowImage = new SlideShowImage();
                slideShowImage.setImageId(imgResource.getId());
                this.saveOrUpdate(slideShowImage, session);
            }
            tx.commit();
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateSlideShowImage(List<SlideShowImage> shopTableTypeList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (shopTableTypeList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (SlideShowImage item : shopTableTypeList) {
                SlideShowImage existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), "Slide show image : " + item.getImageId() + " already updated");
                        continue;
                    }
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }
}

