/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.StoreAlreadyCloseException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.Address;
import com.floreantpos.model.DataSyncInfo;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.BaseStoreDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.util.DateUtil;
import com.orocube.siiopa.common.model.SubscriptionProduct;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class StoreDAO
extends BaseStoreDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    public static Store getRestaurant() {
        return StoreDAO.getInstance().get("1");
    }

    @Deprecated
    public static Date geServerTimestamp() {
        return StoreDAO.getServerTimestamp();
    }

    public static Date getServerTimestamp() {
        Date currentdate = new Date();
        try {
            String deafultDate = TerminalConfig.getTicketCreationDate();
            if (deafultDate == null) {
                return currentdate;
            }
            Date parseDate = DateUtil.parseDate(deafultDate);
            return DateUtil.copyTime(parseDate, currentdate);
        }
        catch (ParseException e) {
            PosLog.debug(StoreDAO.class, e.getMessage());
            return currentdate;
        }
    }

    public void closeStore(User closedBy) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            StoreSession storeSession = StoreSessionDAO.getInstance().getLastOpenSession();
            if (storeSession == null) {
                throw new StoreAlreadyCloseException("Store is already closed.");
            }
            storeSession.setClosedBy(closedBy);
            storeSession.setCloseTime(new Date());
            session.saveOrUpdate((Object)storeSession);
            String sqlDeleteItem = "delete from KITCHEN_TICKET_ITEM";
            String sqlDeleteTicketTables = "delete from KIT_TICKET_TABLE_NUM";
            String sqlKitchenTicket = "delete from KITCHEN_TICKET";
            SQLQuery query = session.createSQLQuery(sqlDeleteItem);
            query.executeUpdate();
            SQLQuery query2 = session.createSQLQuery(sqlDeleteTicketTables);
            query2.executeUpdate();
            SQLQuery query3 = session.createSQLQuery(sqlKitchenTicket);
            query3.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store getCloudRestaurant(String uId) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Store.PROP_UUID, (Object)uId));
            Store store = (Store)criteria.uniqueResult();
            return store;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateStore(List<Store> dataList, boolean updateLastUpdateTime, boolean updateSyncTime, boolean isDownload) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (Store store : dataList) {
                Store existingStore = this.get(store.getId());
                Address address = store.getAddress();
                Map<String, String> properties = store.getProperties();
                store.setUpdateLastUpdateTime(updateLastUpdateTime);
                store.setUpdateSyncTime(updateSyncTime);
                store.setAddress(null);
                this.saveOrUpdateStore(session, store, existingStore);
                this.saveOrUpdateStoreAddress(session, store, address);
                this.addOrUpdateStoreProperties(session, store, existingStore, properties, isDownload);
                Map<String, String> properties2 = existingStore.getProperties();
                store.setProperties(properties2);
                store.setAddress(address);
                this.saveOrUpdate(store, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void addOrUpdateStoreProperties(Session session, Store store, Store existingStore, Map<String, String> properties, boolean isDownload) {
        Map<String, String> existingProperties = null;
        ArrayList<String> subscriptionProductList = new ArrayList<String>();
        SubscriptionProduct[] values = SubscriptionProduct.values();
        for (SubscriptionProduct subscriptionProduct : values) {
            subscriptionProductList.add(subscriptionProduct.getId());
        }
        if (existingStore != null) {
            existingProperties = existingStore.getProperties();
        }
        for (Map.Entry entry : properties.entrySet()) {
            String extension;
            String key = (String)entry.getKey();
            String existingPropertyValue = existingProperties.get(key);
            if (!isDownload) {
                if (StringUtils.isNotEmpty((String)existingPropertyValue)) {
                    String startString = StringUtils.substringBefore((String)key, (String)".");
                    if (subscriptionProductList.contains(startString) || startString.contains("database")) continue;
                    this.addProperty(existingProperties, entry, existingPropertyValue);
                    continue;
                }
                extension = key.substring(key.lastIndexOf(".") + 1);
                if (extension.equals("lastUpdateTime")) continue;
                this.addProperty(existingProperties, entry, (String)entry.getValue());
                continue;
            }
            extension = key.substring(key.lastIndexOf(".") + 1);
            if (extension.equals("lastUpdateTime")) continue;
            this.addProperty(existingProperties, entry, existingPropertyValue);
        }
    }

    private void addProperty(Map<String, String> existingProperties, Map.Entry<String, String> propertyValue, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            existingProperties.put(propertyValue.getKey(), propertyValue.getValue());
        } else {
            existingProperties.putIfAbsent(propertyValue.getKey(), propertyValue.getValue());
        }
    }

    private void saveOrUpdateStoreAddress(Session session, Store item, Address address) {
        if (address == null) {
            return;
        }
        AddressDAO instance = AddressDAO.getInstance();
        Address existingAddress = instance.get(address.getId());
        if (existingAddress == null) {
            instance.save(address);
        } else {
            address.setVersion(existingAddress.getVersion());
        }
    }

    private void saveOrUpdateStore(Session session, Store store, Store existingStore) {
        if (existingStore != null) {
            store.setVersion(existingStore.getVersion());
            store.setUuid(existingStore.getUuid());
            store.setDefaultOutletId(existingStore.getDefaultOutletId());
        }
    }

    public void removeLastUpdateTime() {
        try (Session session = this.createNewSession();){
            Transaction transaction = session.beginTransaction();
            Store store = (Store)session.get(Store.class, (Serializable)((Object)"1"));
            this.removeLastUpdateTime(store);
            transaction.commit();
        }
    }

    public void removeLastUpdateTime(Store store) {
        Map<String, String> properties = store.getProperties();
        ArrayList<String> keys = new ArrayList<String>(properties.keySet());
        keys.forEach(key -> {
            if (key.endsWith("lastUpdateTime")) {
                properties.remove(key);
            }
        });
    }

    public void updateLastUpdateTimeProperty(Date currentDate, List<DataSyncInfo> syncInfos) {
        Store store = StoreDAO.getRestaurant();
        for (DataSyncInfo dataSyncInfo : syncInfos) {
            GenericDAO.getInstance().updateLastUpdateTimeProperty(store, dataSyncInfo.getBeanClass(), currentDate);
        }
        StoreDAO.getInstance().saveOrUpdate(store);
    }
}

