/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BaseStoreSessionDAO;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class StoreSessionDAO
extends BaseStoreSessionDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStoreSession(PaginationSupport model) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(StoreSession.class);
            criteria.addOrder(Order.asc((String)StoreSession.PROP_ID));
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> findSessions(Date startDate, Date endDate) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)startDate), (Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)endDate)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)StoreSession.PROP_CLOSE_TIME), (Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_CLOSE_TIME, (Object)startDate), (Criterion)Restrictions.le((String)StoreSession.PROP_CLOSE_TIME, (Object)endDate))));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> findSessions(Outlet outlet, Date startDate, Date endDate) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)startDate), (Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)endDate)));
            if (outlet != null) {
                criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
            }
            List openTimeList = criteria.list();
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)StoreSession.PROP_CLOSE_TIME, (Object)startDate), (Criterion)Restrictions.le((String)StoreSession.PROP_CLOSE_TIME, (Object)endDate)));
            List closeTimeList = criteria.list();
            if (!closeTimeList.isEmpty()) {
                for (StoreSession storeSession : closeTimeList) {
                    if (openTimeList.contains(storeSession)) continue;
                    openTimeList.add(storeSession);
                }
            }
            List list = openTimeList;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreSession findOpenSession(Outlet outlet) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNull((String)StoreSession.PROP_CLOSE_TIME));
            if (outlet != null) {
                criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
            }
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            List openSessions = criteria.list();
            if (openSessions != null) {
                StoreSession storeSession = (StoreSession)openSessions.get(0);
                return storeSession;
            }
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    public Integer getStoreSessionTotalGuest(StoreSession storeSession) {
        if (storeSession == null) {
            return 0;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
            criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_NUMBER_OF_GUESTS));
            Long guestNumber = (Long)criteria.uniqueResult();
            if (guestNumber != null) {
                Integer n = guestNumber.intValue();
                return n;
            }
            Integer n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreSession> getTransactionsByOutlet(Date from, Date to, Outlet outlet, Pagination pagination) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (pagination != null) {
                criteria.setFirstResult(pagination.getCurrentRowIndex());
                criteria.setMaxResults(pagination.getPageSize());
            }
            this.updateCriteria(criteria, from, to, outlet);
            List list = criteria.list();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(criteria, from, to, outlet);
            if (pagination != null) {
                Number uniqueResult = (Number)criteria.uniqueResult();
                pagination.setNumRows(uniqueResult.intValue());
            }
            List list2 = list;
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(Criteria criteria, Date from, Date to, Outlet outlet) {
        if (from != null) {
            criteria.add((Criterion)Restrictions.ge((String)StoreSession.PROP_OPEN_TIME, (Object)from));
        }
        if (to != null) {
            criteria.add((Criterion)Restrictions.le((String)StoreSession.PROP_OPEN_TIME, (Object)to));
        }
        if (outlet != null) {
            criteria.add((Criterion)Restrictions.eq((String)StoreSession.PROP_OUTLET_ID, (Object)outlet.getId()));
        }
    }

    public void saveOrUpdateStoreSessions(List<StoreSession> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (StoreSession item : dataList) {
                StoreSession existingItem = this.get(item.getId());
                String colseByUserId = item.getClosedByUserId();
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getId() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    if (colseByUserId != null) {
                        existingItem.setClosedByUserId(colseByUserId);
                    }
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    public StoreSession getLastOpenSession() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNull((String)StoreSession.PROP_CLOSE_TIME));
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            criteria.setMaxResults(1);
            StoreSession storeSession = (StoreSession)criteria.uniqueResult();
            return storeSession;
        }
    }

    public StoreSession getLastStoreSession() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.desc((String)StoreSession.PROP_OPEN_TIME));
            criteria.setMaxResults(1);
            StoreSession storeSession = (StoreSession)criteria.uniqueResult();
            return storeSession;
        }
    }
}

