/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.explorer.TicketExplorer;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DeletedData;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.BaseTicketDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.DeletedDataDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.KitchenTicketItemDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.ext.DeletedDataType;
import com.floreantpos.model.ext.InvMapKey;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.payment.PaymentPlugin;
import com.floreantpos.report.DeliverySummaryReportData;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.NumericGlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.CloudDataUploader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SortOrder;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.json.JSONArray;
import org.json.JSONObject;

public class TicketDAO
extends BaseTicketDAO {
    private static final TicketDAO instance = new TicketDAO();

    @Override
    public Order getDefaultOrder() {
        return Order.desc((String)Ticket.PROP_CREATE_DATE);
    }

    @Override
    protected Serializable save(Object obj, Session session) {
        Ticket ticket = (Ticket)obj;
        this.performPreSaveOperations(ticket);
        Serializable save = super.save(obj, session);
        this.performPostSaveOperations(session, ticket);
        return save;
    }

    @Override
    protected void update(Object obj, Session session) {
        Ticket ticket = (Ticket)obj;
        this.performPreSaveOperations(ticket);
        super.update(obj, session);
        this.performPostSaveOperations(session, ticket);
    }

    @Override
    public synchronized void saveOrUpdate(Ticket ticket) {
        this.performPreSaveOperations(ticket);
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            boolean newOrder = ticket.getId() == null;
            this.saveOrUpdate(ticket, session);
            tx.commit();
            ActionHistoryDAO.getInstance().performActionHistorySaveOperation(ticket, newOrder);
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    @Override
    public void saveOrUpdate(Ticket ticket, Session session) {
        this.updateTime(ticket);
        this.saveOrUpdate(ticket, session, true);
    }

    public void saveOrUpdate(Ticket ticket, Session session, boolean updateTableStatus) {
        boolean newTicket;
        boolean bl = newTicket = StringUtils.isEmpty((String)ticket.getId()) ? true : this.isNewTicket(ticket.getId());
        if (newTicket) {
            if (StringUtils.isEmpty((String)ticket.getId())) {
                ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
            }
            if (StringUtils.isEmpty((String)ticket.getShortId())) {
                ticket.setShortId(RandomStringUtils.randomNumeric((int)7));
            }
            ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
        }
        ticket.setActiveDate(StoreDAO.getServerTimestamp());
        ticket.updateGratuityInfo();
        if (ticket.isPaid().booleanValue() && ticket.getDueAmount() > 0.0) {
            ticket.setPaid(false);
        }
        if (newTicket) {
            this.save(ticket, session);
        } else {
            this.update(ticket, session);
        }
        if (updateTableStatus) {
            this.updateShopTableStatus(ticket, session, newTicket);
        }
    }

    @Override
    protected void delete(Object obj, Session s) {
        super.delete(obj, s);
        if (obj instanceof Ticket) {
            Ticket ticket = (Ticket)obj;
            DeletedData deletedData = new DeletedData();
            Date date = StoreDAO.getServerTimestamp();
            deletedData.setLastUpdateTime(date);
            deletedData.setDeleteDate(date);
            deletedData.setDataId(ticket.getId());
            deletedData.setDeletedDataType(DeletedDataType.TICKET);
            deletedData.setDeleteByUserId(Application.getCurrentUser().getId());
            DeletedDataDAO.getInstance().save(deletedData, s);
        }
    }

    public void saveOrUpdateTemporaryTicket(Ticket ticket) {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            boolean newTicket;
            tx = session.beginTransaction();
            ticket.setActiveDate(StoreDAO.getServerTimestamp());
            boolean bl = newTicket = StringUtils.isEmpty((String)ticket.getId()) ? true : this.isNewTicket(ticket.getId());
            if (newTicket) {
                if (StringUtils.isEmpty((String)ticket.getId())) {
                    ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
                }
                if (StringUtils.isEmpty((String)ticket.getShortId())) {
                    ticket.setShortId(RandomStringUtils.randomNumeric((int)7));
                }
                ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
                this.updateTime(ticket);
                session.save((Object)ticket);
            } else {
                this.updateTime(ticket);
                session.update((Object)ticket);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    private void performPreSaveOperations(Ticket ticket) {
        StoreSession storeSession;
        if (ticket.isUpdateLastUpdateTime()) {
            ticket.setLastUpdateTime(StoreDAO.getServerTimestamp());
        }
        if (ticket.getCreateDate() == null) {
            Calendar currentTime = DateUtil.getServerTimeCalendar();
            ticket.setCreateDate(currentTime.getTime());
            ticket.setCreationHour(currentTime.get(11));
        }
        if (StringUtils.isEmpty((String)ticket.getStoreSessionId()) && (storeSession = DataProvider.get().getStoreSession()) != null) {
            ticket.setStoreSessionId(storeSession.getId());
        }
    }

    private void performPostSaveOperations(Session session, Ticket ticket) {
        this.updateStock(ticket, session);
        ticket.setShouldUpdateStock(false);
        ticket.clearDeletedItems();
    }

    public synchronized void saveOrUpdateSplitTickets(List<Ticket> tickets, List<Integer> tableNumbers) {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (Ticket ticket : tickets) {
                ticket.setUpdateLastUpdateTime(true);
                this.saveOrUpdate(ticket, session, false);
            }
            ShopTableStatusDAO.getInstance().addTicketsToShopTableStatus(tableNumbers, tickets, session);
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNewTicket(String id) {
        Session session = null;
        try {
            session = this.createNewSession();
            boolean bl = this.isNewTicket(id, session);
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    private boolean isNewTicket(String id, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.setProjection(Projections.rowCount());
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)id));
        Number number = (Number)criteria.uniqueResult();
        return number == null || number.intValue() == 0;
    }

    private void clearVoidedItems(Ticket ticket) {
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            ticketItem.markVoidedItemAsAdjusted(null);
        }
    }

    public synchronized void saveKitchenPrintStatus(Ticket ticket, KitchenTicket kitchenTicket) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            List<KitchenTicketItem> ticketItems = kitchenTicket.getTicketItems();
            Iterator<KitchenTicketItem> iterator = ticketItems.iterator();
            while (iterator.hasNext()) {
                KitchenTicketItem kitchenTicketItem = iterator.next();
                if (!kitchenTicketItem.isVoided().booleanValue()) continue;
                String ticketItemId = kitchenTicketItem.getVoidedItemId();
                KitchenTicketItemDAO.getInstance().markVoided(ticketItemId, kitchenTicketItem.isModifierItem(), session);
                iterator.remove();
            }
            if (ticketItems.size() > 0) {
                KitchenTicketDAO.getInstance().saveOrUpdate(kitchenTicket, session);
            }
            ticket.clearDeletedItems();
            if (ticket.getId() == null) {
                ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
            }
            this.saveOrUpdate(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateShopTableStatus(Ticket ticket, Session session, boolean isNewTicket) {
        List<Integer> tableNumbers = ticket.getTableNumbers();
        if (tableNumbers == null || tableNumbers.isEmpty()) {
            return;
        }
        if (ticket.isClosed().booleanValue()) {
            ShopTableStatusDAO.getInstance().removeTicketFromShopTableStatus(ticket, session);
        } else if (isNewTicket || ticket.isShouldUpdateTableStatus()) {
            ShopTableDAO.getInstance().occupyTables(ticket, session);
            ticket.setShouldUpdateTableStatus(false);
        }
    }

    public void voidTicket(Ticket ticket) throws Exception {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            ticket.setShouldUpdateStock(true);
            ticket.setDiscounts(null);
            for (TicketItem ticketItem : ticket.getTicketItems()) {
                boolean inventoryAdjusted;
                if (ticketItem.isTreatAsSeat().booleanValue()) continue;
                boolean bl = inventoryAdjusted = ticketItem.getInventoryAdjustQty() >= ticketItem.getQuantity();
                if (!ticketItem.isVoided().booleanValue()) {
                    ticket.voidItem(ticketItem, ticket.getVoidReason(), ticket.isWasted(), Math.abs(ticketItem.getQuantity()));
                    if (inventoryAdjusted) continue;
                    ticketItem.setInventoryAdjustQty(ticketItem.getQuantity());
                    continue;
                }
                if (!ticketItem.isReturned() || ticketItem.isReturnedItemVoided()) continue;
                ticket.voidReturnedItem(ticketItem, ticket.getVoidReason(), ticket.isWasted());
                if (inventoryAdjusted) continue;
                ticketItem.setInventoryAdjustQty(ticketItem.getQuantity());
            }
            ticket.calculatePrice();
            tx = session.beginTransaction();
            List<KitchenTicket> kitchenTickets = KitchenTicketDAO.getInstance().findByParentId(ticket.getId());
            Date serverTimestamp = StoreDAO.getServerTimestamp();
            if (kitchenTickets != null) {
                for (KitchenTicket kitchenTicket : kitchenTickets) {
                    kitchenTicket.setCreateDate(serverTimestamp);
                    kitchenTicket.setVoided(true);
                    session.saveOrUpdate((Object)kitchenTicket);
                }
            }
            ticket.setVoided(true);
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            tx.commit();
            String actionDescription = "Ticket is voided. Total: " + NumberUtil.formatNumber(ticket.getTotalAmountWithTips());
            ActionHistoryDAO.saveHistory(ticket, "Void check", actionDescription);
        }
        catch (Exception x) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw x;
        }
        finally {
            ticket.setShouldUpdateStock(false);
        }
    }

    @Deprecated
    private void populateVoidItems(Ticket ticket) {
        HashMap<String, Double> voidedItemQuantityMap = new HashMap<String, Double>();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (!ticketItem.isVoided().booleanValue()) continue;
            Double previousValue = (Double)voidedItemQuantityMap.get(ticketItem.getMenuItemId());
            if (previousValue == null) {
                previousValue = 0.0;
            }
            double voidedQuantity = 0.0;
            voidedQuantity = Math.abs(ticketItem.getQuantity());
            if ((voidedQuantity += previousValue.doubleValue()) == 0.0) continue;
            voidedItemQuantityMap.put(ticketItem.getMenuItemId(), voidedQuantity);
        }
        HashMap<TicketItem, VoidItem> toBeVoidedItemsMap = new HashMap<TicketItem, VoidItem>();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.getId() == null || ticketItem.isVoided().booleanValue() || ticketItem.getVoidItem() != null || ticketItem.isTreatAsSeat().booleanValue()) continue;
            Double voidedQuantity = (Double)voidedItemQuantityMap.get(ticketItem.getMenuItemId());
            double toBeVoidQuantity = ticketItem.getQuantity();
            if (voidedQuantity != null && voidedQuantity > 0.0) {
                if (voidedQuantity >= toBeVoidQuantity) {
                    voidedItemQuantityMap.put(ticketItem.getMenuItemId(), voidedQuantity - toBeVoidQuantity);
                    continue;
                }
                toBeVoidQuantity -= voidedQuantity.doubleValue();
            }
            toBeVoidedItemsMap.put(ticketItem, new VoidItem(ticket.getVoidReason(), ticket.isWasted(), toBeVoidQuantity));
        }
        Set keys = toBeVoidedItemsMap.keySet();
        for (TicketItem ticketItem : keys) {
            if (ticketItem.isTreatAsSeat().booleanValue()) continue;
            VoidItem voidItem = (VoidItem)toBeVoidedItemsMap.get(ticketItem);
            ticket.voidItem(ticketItem, voidItem.getVoidReason(), voidItem.isItemWasted(), voidItem.getQuantity());
        }
    }

    public void loadFullTicket(Ticket ticket) {
        if (ticket.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(ticket.getTicketItems()) && Hibernate.isInitialized(ticket.getTransactions())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)ticket);
            Hibernate.initialize(ticket.getTicketItems());
            Hibernate.initialize(ticket.getTransactions());
        }
        finally {
            this.closeSession(session);
        }
    }

    public Ticket loadFullTicket(String id) {
        try (Session session = this.createNewSession();){
            Ticket ticket = this.loadFullTicket(id, session);
            return ticket;
        }
    }

    public Ticket loadFullTicket(String id, Session session) {
        try {
            Ticket ticket = (Ticket)session.get(this.getReferenceClass(), (Serializable)((Object)id));
            if (ticket == null) {
                return null;
            }
            Hibernate.initialize(ticket.getTicketItems());
            Hibernate.initialize(ticket.getTransactions());
            return ticket;
        }
        catch (HibernateException e) {
            String message = e.getMessage();
            String predefinedMessage = "null index column for collection: com.floreantpos.model.Ticket.ticketItems";
            if (predefinedMessage.equals(message)) {
                this.fixTicketItemsIndex(id);
                return this.loadFullTicket(id, session);
            }
            throw e;
        }
    }

    private void fixTicketItemsIndex(String ticketId) {
        Ticket ticket = new Ticket(ticketId);
        Transaction transaction = null;
        try (Session session = TicketItemDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(TicketItem.class);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TICKET, (Object)ticket));
            criteria.addOrder(Order.asc((String)TicketItem.PROP_CREATE_DATE));
            List list = criteria.list();
            transaction = session.beginTransaction();
            for (int i = 0; i < list.size(); ++i) {
                TicketItem ticketItem = (TicketItem)list.get(i);
                String sql = "update ticket_item set item_index=%s where id='%s'";
                int update = session.createSQLQuery(sql = String.format(sql, i, ticketItem.getId())).executeUpdate();
                if (update == 1) continue;
                throw new PosException(POSConstants.ERROR_MESSAGE);
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
    }

    public Ticket loadCouponsAndTransactions(String ticketId) {
        try (Session session = this.createNewSession();){
            Ticket ticket = (Ticket)session.get(this.getReferenceClass(), (Serializable)((Object)ticketId));
            Hibernate.initialize(ticket.getTransactions());
            Ticket ticket2 = ticket;
            return ticket2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets() {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.addOrder(this.getDefaultOrder());
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets(Integer customerId) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            criteria.addOrder(this.getDefaultOrder());
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> findOpenTickets(Terminal terminal, UserType userType) {
        return this.findOpenTickets(Arrays.asList(terminal), userType, null, null, null);
    }

    public List<Ticket> findOpenTickets(List<Terminal> terminals, UserType userType, List<String> orderTypeIds, Date startDate, Date endDate) {
        try (Session session = this.createNewSession();){
            ArrayList<Integer> terminalIdList = new ArrayList<Integer>();
            if (terminals != null) {
                for (Terminal terminal : terminals) {
                    terminalIdList.add(terminal.getId());
                }
            }
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (startDate != null && endDate != null) {
                criteria.add(Restrictions.between((String)Ticket.PROP_CREATE_DATE, (Object)startDate, (Object)endDate));
            }
            if (userType != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_TYPE_ID, (Object)userType.getId()));
            }
            if (!terminalIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)Ticket.PROP_TERMINAL_ID, terminalIdList));
            }
            if (orderTypeIds != null && orderTypeIds.size() > 0) {
                criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, orderTypeIds));
            }
            criteria.addOrder(this.getDefaultOrder());
            List list = criteria.list();
            return list;
        }
    }

    public int getNumTickets() {
        return this.getNumTickets(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTickets(List<String> orderTypeIds) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteriaFilters(criteria);
            if (orderTypeIds != null && !orderTypeIds.isEmpty()) {
                criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, orderTypeIds));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void loadTickets(PaginatedTableModel tableModel) {
        this.loadTickets(tableModel, null);
    }

    public void loadTickets(PaginatedTableModel tableModel, List<String> orderTypeIds) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteriaFilters(criteria);
            if (orderTypeIds != null && !orderTypeIds.isEmpty()) {
                criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, orderTypeIds));
            }
            tableModel.setNumRows(this.rowCount(criteria));
            criteria.addOrder(this.getDefaultOrder());
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            tableModel.setRows(criteria.list());
        }
    }

    public void loadDeliveryTickets(PaginatedTableModel tableModel, String customerId, Date startDate, Date endDate, boolean onlineOrderOnly, boolean isPickupOnly, boolean isDeliveryOnly, boolean filterUnassigned) {
        block23: {
            try (Session session = this.createNewSession();){
                List<String> orderTypeIds;
                Criteria criteria = session.createCriteria(this.getReferenceClass());
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
                if (StringUtils.isNotEmpty((String)customerId)) {
                    criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
                }
                if (startDate != null && endDate != null) {
                    criteria.add(Restrictions.between((String)Ticket.PROP_DELIVERY_DATE, (Object)startDate, (Object)endDate));
                }
                if (isPickupOnly) {
                    criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.TRUE));
                }
                if (isDeliveryOnly) {
                    criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.FALSE));
                }
                if (filterUnassigned) {
                    criteria.add(Restrictions.isNull((String)Ticket.PROP_ASSIGNED_DRIVER_ID));
                }
                if ((orderTypeIds = OrderTypeDAO.getInstance().getHomeDeliveryOrderTypeIds(session)) != null && !orderTypeIds.isEmpty()) {
                    criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, orderTypeIds));
                    tableModel.setNumRows(this.rowCount(criteria));
                    criteria.setFirstResult(tableModel.getCurrentRowIndex());
                    criteria.setMaxResults(tableModel.getPageSize());
                    criteria.addOrder(this.getDefaultOrder());
                    List tickets = criteria.list();
                    if (onlineOrderOnly) {
                        Iterator iterator = tickets.iterator();
                        while (iterator.hasNext()) {
                            Ticket ticket = (Ticket)iterator.next();
                            if (ticket.isSourceOnline()) continue;
                            iterator.remove();
                        }
                    }
                    tableModel.setRows(tickets);
                    break block23;
                }
                if (tableModel.getRows() != null) {
                    tableModel.getRows().clear();
                }
                tableModel.setNumRows(0);
                return;
            }
        }
    }

    public List<Ticket> findCustomerTickets(String customerId, PaginationSupport tableModel) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            tableModel.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            criteria.addOrder(this.getDefaultOrder());
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findNextCustomerTickets(Integer customerId, PaginatedTableModel tableModel, String filter) {
        List list;
        Session session = null;
        Criteria criteria = null;
        PaymentStatusFilter statusFilter = PaymentStatusFilter.fromString(filter);
        try {
            int nextIndex = tableModel.getNextRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            if (statusFilter == PaymentStatusFilter.OPEN) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            criteria.setFirstResult(nextIndex);
            criteria.setMaxResults(tableModel.getPageSize());
            List ticketList = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                tableModel.setNumRows(rowCount.intValue());
            }
            tableModel.setCurrentRowIndex(nextIndex);
            list = ticketList;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findPreviousCustomerTickets(Integer customerId, PaginatedTableModel tableModel, String filter) {
        List list;
        Session session = null;
        Criteria criteria = null;
        PaymentStatusFilter statusFilter = PaymentStatusFilter.fromString(filter);
        try {
            int previousIndex = tableModel.getPreviousRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            if (statusFilter == PaymentStatusFilter.OPEN) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            criteria.setFirstResult(previousIndex);
            criteria.setMaxResults(tableModel.getPageSize());
            List ticketList = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                tableModel.setNumRows(rowCount.intValue());
            }
            tableModel.setCurrentRowIndex(previousIndex);
            list = ticketList;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketByCustomer(Integer customerId) {
        Session session = null;
        Criteria criteria = null;
        try {
            List ticketList;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            List list = ticketList = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> findTickets(PaymentStatusFilter psFilter, OrderType orderType) {
        return this.findTicketsForUser(psFilter, orderType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForUser(PaymentStatusFilter psFilter, OrderType orderType, User user) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (psFilter == PaymentStatusFilter.OPEN) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            } else if (psFilter == PaymentStatusFilter.PAID) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.TRUE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            } else if (psFilter == PaymentStatusFilter.CLOSED) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
                Calendar currentTime = Calendar.getInstance();
                currentTime.add(11, -24);
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CLOSING_DATE, (Object)currentTime.getTime()));
            }
            if (orderType != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
            }
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOpenTickets(User user) {
        Session session = null;
        try {
            Number result;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if ((result = (Number)criteria.uniqueResult()) != null) {
                boolean bl = result.intValue() > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> findOpenTicketsForUser(User user) {
        return this.findOpenTicketsForUser(user, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTicketsForUser(User user, List<String> orderTypeIds) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)(user == null ? null : user.getId())));
            if (orderTypeIds != null && !orderTypeIds.isEmpty()) {
                criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, orderTypeIds));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsByOutletId(Date lastUpdateTime, String outletId, boolean includeClosedTickets) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OUTLET_ID, (Object)outletId));
            if (!includeClosedTickets) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            criteria.add((Criterion)Restrictions.ne((String)Ticket.PROP_STATUS, (Object)"Pending"));
            if (lastUpdateTime != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"lastUpdateTime"), (Criterion)Restrictions.gt((String)"lastUpdateTime", (Object)lastUpdateTime)));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findClosedTicketsByOpenTicketIds(Date lastUpdateTime, List<String> openTicketIds) {
        if (openTicketIds == null || openTicketIds.isEmpty()) {
            return null;
        }
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            criteria.add(Restrictions.in((String)Ticket.PROP_ID, openTicketIds));
            if (lastUpdateTime != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"lastUpdateTime"), (Criterion)Restrictions.gt((String)"lastUpdateTime", (Object)lastUpdateTime)));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets(Date startDate, Date endDate) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)endDate));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findClosedTickets(Date startDate, Date endDate) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            if (startDate != null && endDate != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)startDate));
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)endDate));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void closeOrder(Ticket ticket) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.saveOrUpdate(ticket);
            User driver = ticket.getAssignedDriver();
            if (driver != null) {
                driver.setAvailableForDelivery(true);
                UserDAO.getInstance().saveOrUpdate(driver);
            }
            ShopTableDAO.getInstance().releaseTables(ticket);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(TicketDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTickets(Date startDate, Date endDate, boolean closed, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)endDate));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForLaborHour(Date startDate, Date endDate, int hour, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_ACTIVE_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_ACTIVE_DATE, (Object)endDate));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CREATION_HOUR, (Object)hour));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForShift(Date startDate, Date endDate, Shift shit, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)endDate));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_SHIFT_ID, (Object)(shit == null ? null : shit.getId())));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public static TicketDAO getInstance() {
        return instance;
    }

    private void updateCriteriaFilters(Criteria criteria) {
        User user = Application.getCurrentUser();
        PaymentStatusFilter paymentStatusFilter = TerminalConfig.getPaymentStatusFilter();
        String orderTypeFilter = TerminalConfig.getOrderTypeFilter();
        boolean filterByMyTicket = TerminalConfig.isFilterByOwner();
        OrderType orderType = null;
        if (!POSConstants.ALL.equals(orderTypeFilter)) {
            orderType = DataProvider.get().getOrderType(orderTypeFilter);
        }
        if (paymentStatusFilter == PaymentStatusFilter.OPEN) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (!user.canViewAllOpenTickets() || filterByMyTicket) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
        } else if (paymentStatusFilter == PaymentStatusFilter.CLOSED) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            if (!user.canViewAllCloseTickets() || filterByMyTicket) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
        }
        if (!orderTypeFilter.equals(POSConstants.ALL) && orderType != null) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
        }
    }

    public void deleteTickets(List<Ticket> tickets) {
        this.deleteTickets(tickets, false);
    }

    public void deleteTickets(List<Ticket> tickets, boolean releaseTables) {
        this.deleteTickets(tickets, releaseTables, false);
    }

    public void deleteTickets(List<Ticket> tickets, boolean releaseTables, boolean updateStock) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.deleteTickets(session, tickets, releaseTables, updateStock);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(TicketDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void deleteTickets(Session session, List<Ticket> tickets, boolean releaseTables) throws Exception {
        this.deleteTickets(session, tickets, releaseTables, false);
    }

    public void deleteTickets(Session session, List<Ticket> tickets, boolean releaseTables, boolean updateStock) throws Exception {
        for (Ticket ticket : tickets) {
            if (!(ticket = (Ticket)session.merge((Object)ticket)).isClosed().booleanValue()) {
                ArrayList<TicketItem> removedTicketItems = new ArrayList<TicketItem>();
                removedTicketItems.addAll(ticket.getTicketItems());
                for (TicketItem ticketItem : removedTicketItems) {
                    ticket.addDeletedItems(ticketItem);
                }
                if (updateStock && ticket.getPaidAmount() > 0.0) {
                    TicketDAO.getInstance().updateStock(ticket, session);
                }
            }
            super.delete(ticket, session);
            if (!releaseTables) continue;
            ShopTableDAO.getInstance().freeTicketTables(ticket, session);
        }
    }

    protected void updateStock(Ticket ticket, Session session) {
        try {
            if (!this.shouldUpdateStock(ticket)) {
                return;
            }
            InventoryLocation defaultOutInventoryLocation = null;
            InventoryLocation defaultInInventoryLocation = null;
            defaultOutInventoryLocation = DataProvider.get().getDefaultOutLocation();
            HashMap<InvMapKey, Double> itemMap = this.buildItemMapForInventoryAdjustment(ticket);
            HashMap<InvMapKey, Double> voidedItemsMap = this.buildItemMapForVoidItems(ticket, session);
            HashMap<InvMapKey, Double> returnedVoidedItemsMap = this.buildItemMapForReturnedVoidItems(ticket, session);
            this.adjustInventory(ticket, itemMap, InventoryTransactionType.OUT, "TICKET SALES", defaultOutInventoryLocation, session);
            if (voidedItemsMap != null && voidedItemsMap.size() > 0) {
                defaultInInventoryLocation = DataProvider.get().getDefaultInLocation();
                this.adjustInventory(ticket, voidedItemsMap, InventoryTransactionType.IN, "VOID", defaultInInventoryLocation, session);
            }
            if (returnedVoidedItemsMap != null && returnedVoidedItemsMap.size() > 0) {
                this.adjustInventory(ticket, returnedVoidedItemsMap, InventoryTransactionType.OUT, "VOID", defaultOutInventoryLocation, session);
            }
            this.clearVoidedItems(ticket);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), "Failed to update stock balance for ticket: " + ticket.getId(), e);
        }
    }

    private void adjustInventory(Ticket ticket, HashMap<InvMapKey, Double> itemMap, InventoryTransactionType transactionType, String reason, InventoryLocation location, Session session) throws Exception {
        Store store = DataProvider.get().getStore();
        boolean isUpdateOnHandBlncForSale = store.isUpdateOnHandBlncForSale();
        boolean isUpdateAvailBlncForSale = store.isUpdateAvlBlncForSale();
        for (InvMapKey mapKey : itemMap.keySet()) {
            Double unitQuantity = itemMap.get(mapKey);
            MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemWithFields(session, mapKey.getMenuItemId(), MenuItem.PROP_NAME, MenuItem.PROP_PRICE, MenuItem.PROP_SKU, MenuItem.PROP_BARCODE, MenuItem.PROP_UNIT_ID, MenuItem.PROP_COST, MenuItem.PROP_AVERAGE_UNIT_PURCHASE_PRICE, MenuItem.PROP_AVG_COST, MenuItem.PROP_DEFAULT_RECIPE_ID, MenuItem.PROP_INVENTORY_ITEM);
            if (menuItem == null) continue;
            if (menuItem.isInventoryItem().booleanValue()) {
                InventoryTransaction outTrans = new InventoryTransaction();
                if ("VOID".equals(reason) && mapKey.isReturned()) {
                    outTrans.setReason("RETURN");
                } else {
                    outTrans.setReason(reason);
                }
                outTrans.setTransactionDate(new Date());
                outTrans.setMenuItem(menuItem);
                outTrans.setType(transactionType.getType());
                outTrans.setTicketId(ticket.getId());
                outTrans.setUser(ticket.getOwner());
                double baseUnitQuantity = menuItem.getBaseUnitQuantity(mapKey.getUnitCode());
                outTrans.setUnitPrice(menuItem.getPrice() * baseUnitQuantity);
                outTrans.setQuantity(unitQuantity);
                outTrans.setUnit(mapKey.getUnitCode());
                outTrans.setUnitCost(menuItem.getCost());
                if (transactionType == InventoryTransactionType.IN) {
                    outTrans.setToInventoryLocation(location);
                } else {
                    outTrans.setFromInventoryLocation(location);
                }
                outTrans.calculateTotal();
                InventoryTransactionDAO.getInstance().adjustInventoryStock(outTrans, session, isUpdateAvailBlncForSale, isUpdateOnHandBlncForSale);
            }
            if (!StringUtils.isNotEmpty((String)menuItem.getDefaultRecipeId())) continue;
            Recepie recepie = RecepieDAO.getInstance().get(menuItem.getDefaultRecipeId(), session);
            RecepieDAO.getInstance().adjustRecipeItemsFromInventory(unitQuantity, Arrays.asList(recepie), session);
        }
    }

    private HashMap<InvMapKey, Double> buildItemMapForInventoryAdjustment(Ticket ticket) {
        List<TicketItem> ticketItems = ticket.getTicketItems();
        HashMap<InvMapKey, Double> itemMap = new HashMap<InvMapKey, Double>();
        this.populateItemToMap(ticketItems, itemMap);
        return itemMap;
    }

    private void populateItemToMap(List<TicketItem> ticketItems, HashMap<InvMapKey, Double> itemMap) {
        for (TicketItem ticketItem : ticketItems) {
            if (ticketItem.getMenuItemId() == null || ticketItem.isVoided().booleanValue() || ticketItem.isInventoryAdjusted()) continue;
            InvMapKey key = new InvMapKey(ticketItem.getMenuItemId(), ticketItem.getUnitName());
            Double previousValue = itemMap.get(key);
            if (previousValue == null) {
                previousValue = 0.0;
            }
            Double toBeAdjustQty = ticketItem.getQuantity();
            toBeAdjustQty = toBeAdjustQty - ticketItem.getInventoryAdjustQty();
            if ((toBeAdjustQty = Double.valueOf(toBeAdjustQty + previousValue)) <= 0.0) continue;
            itemMap.put(key, toBeAdjustQty);
            ticketItem.setInventoryAdjustQty(ticketItem.getQuantity());
            if (!ticketItem.isComboItem().booleanValue()) continue;
            this.populateItemToMap(ticketItem.getComboItems(), itemMap);
        }
    }

    private HashMap<InvMapKey, Double> buildItemMapForVoidItems(Ticket ticket, Session session) {
        List<TicketItem> ticketItems = ticket.getTicketItems();
        HashMap<InvMapKey, Double> voidItemMap = new HashMap<InvMapKey, Double>();
        this.populateVoidItemToMap(ticket, session, ticketItems, voidItemMap);
        return voidItemMap;
    }

    private void populateVoidItemToMap(Ticket ticket, Session session, List<TicketItem> ticketItems, HashMap<InvMapKey, Double> voidItemMap) {
        for (TicketItem voidTicketItem : ticketItems) {
            VoidItem voidItem = voidTicketItem.getVoidItem();
            String menuItemId = voidTicketItem.getMenuItemId();
            if (voidItem == null || !voidTicketItem.isVoided().booleanValue() && !voidTicketItem.isItemReturned().booleanValue() || voidTicketItem.isReturnedItemVoided()) continue;
            InvMapKey mapKey = new InvMapKey(menuItemId, voidTicketItem.getUnitName());
            mapKey.setReturned(voidTicketItem.isItemReturned());
            Double previousValue = voidItemMap.get(mapKey);
            if (previousValue == null) {
                previousValue = 0.0;
            }
            double toBeAdjustQty = 0.0;
            toBeAdjustQty = voidItem.getQuantity();
            if ((toBeAdjustQty += previousValue.doubleValue()) == 0.0) continue;
            if (!voidItem.isItemWasted().booleanValue() && !voidTicketItem.isInventoryAdjusted()) {
                voidItemMap.put(mapKey, toBeAdjustQty);
                voidTicketItem.setInventoryAdjustQty(voidTicketItem.getQuantity());
            }
            Boolean isPrintedToKitchen = voidTicketItem.isPrintedToKitchen();
            VoidItemDAO.getInstance().saveAndSentToKitchenIfNeeded(voidItem, isPrintedToKitchen, ticket, session);
            voidTicketItem.addProperty("voidId", voidItem.getId());
            List<VoidItem> voidedModifiers = voidItem.getVoidedModifiers();
            String propModifierVoidIds = "";
            if (voidedModifiers != null && voidedModifiers.size() > 0) {
                Iterator<VoidItem> iterator = voidedModifiers.iterator();
                while (iterator.hasNext()) {
                    VoidItem voidedModifier = iterator.next();
                    VoidItemDAO.getInstance().saveAndSentToKitchenIfNeeded(voidedModifier, isPrintedToKitchen, ticket, session);
                    propModifierVoidIds = propModifierVoidIds + voidedModifier.getId();
                    if (!iterator.hasNext()) continue;
                    propModifierVoidIds = propModifierVoidIds + ",";
                }
            }
            if (voidTicketItem.isReturned() && StringUtils.isNotBlank((String)propModifierVoidIds)) {
                voidTicketItem.addProperty("modifierVoidIds", propModifierVoidIds);
            }
            if (!voidTicketItem.isComboItem().booleanValue()) continue;
            this.populateVoidItemToMap(ticket, session, voidTicketItem.getComboItems(), voidItemMap);
        }
    }

    private HashMap<InvMapKey, Double> buildItemMapForReturnedVoidItems(Ticket ticket, Session session) {
        List<TicketItem> ticketItems = ticket.getTicketItems();
        HashMap<InvMapKey, Double> voidItemMap = new HashMap<InvMapKey, Double>();
        this.populateReturnedVoidItemToMap(ticket, session, ticketItems, voidItemMap);
        return voidItemMap;
    }

    private void populateReturnedVoidItemToMap(Ticket ticket, Session session, List<TicketItem> ticketItems, HashMap<InvMapKey, Double> voidItemMap) {
        for (TicketItem voidTicketItem : ticketItems) {
            String[] modifierVoidIds;
            String propModifierVoidIds;
            VoidItem voidItem;
            String voidId;
            if (!voidTicketItem.isReturnedItemVoided() || StringUtils.isBlank((String)(voidId = voidTicketItem.getProperty("voidId"))) || (voidItem = VoidItemDAO.getInstance().get(voidId)) == null) continue;
            String menuItemId = voidTicketItem.getMenuItemId();
            InvMapKey mapKey = new InvMapKey(menuItemId, voidTicketItem.getUnitName());
            Double previousValue = voidItemMap.get(mapKey);
            if (previousValue == null) {
                previousValue = 0.0;
            }
            double toBeAdjustQty = 0.0;
            toBeAdjustQty = Math.abs(voidItem.getQuantity());
            if ((toBeAdjustQty += previousValue.doubleValue()) == 0.0) continue;
            if (!voidItem.isItemWasted().booleanValue() && !voidTicketItem.isInventoryAdjusted()) {
                voidItemMap.put(mapKey, toBeAdjustQty);
                voidTicketItem.setInventoryAdjustQty(voidTicketItem.getQuantity());
            }
            Boolean isPrintedToKitchen = voidTicketItem.isPrintedToKitchen();
            VoidItemDAO.getInstance().deleteAndSentToKitchenIfNeeded(voidItem, isPrintedToKitchen, ticket, session);
            if (voidTicketItem.isHasModifiers().booleanValue() && StringUtils.isNotBlank((String)(propModifierVoidIds = voidTicketItem.getProperty("modifierVoidIds"))) && (modifierVoidIds = propModifierVoidIds.split(",")).length > 0) {
                for (String modifierVoidId : modifierVoidIds) {
                    VoidItem existingVoid;
                    if (StringUtils.isBlank((String)modifierVoidId) || (existingVoid = VoidItemDAO.getInstance().get(modifierVoidId)) == null) continue;
                    VoidItemDAO.getInstance().delete(existingVoid, session);
                }
            }
            if (!voidTicketItem.isComboItem().booleanValue()) continue;
            this.populateReturnedVoidItemToMap(ticket, session, voidTicketItem.getComboItems(), voidItemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTickets(Date start, Date end) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (start != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)start));
            }
            if (end != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)end));
            }
            criteria.add(Restrictions.isNotNull((String)Ticket.PROP_DELIVERY_DATE));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTickets(PaginatedTableModel tableModel, Date beginingDeliveryDate, Date endingDeliveryDate) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(this.getDefaultOrder());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (beginingDeliveryDate != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)beginingDeliveryDate));
            }
            if (endingDeliveryDate != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)endingDeliveryDate));
            }
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            tableModel.setRows(criteria.list());
            return;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> getTicketsWithSpecificFields(String ... fields) {
        return this.getTicketsWithSpecificFields(true, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> getTicketsWithSpecificFields(boolean isOnlyOpenTickets, String ... fields) {
        Session session = null;
        Criteria criteria = null;
        User currentUser = Application.getCurrentUser();
        boolean filterUser = !currentUser.isAdministrator() || !currentUser.isManager();
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Ticket.class);
            if (isOnlyOpenTickets) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            if (filterUser) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)currentUser.getId()));
            }
            ProjectionList projectionList = Projections.projectionList();
            for (String field : fields) {
                projectionList.add((Projection)Projections.property((String)field), field);
            }
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(Ticket.class));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTicketByOnlineOrderId(String onlineOrderId) {
        Session session = null;
        try {
            session = this.createNewSession();
            String sql = "select * from TICKET_PROPERTIES where PROPERTY_VALUE='%s' and PROPERTY_NAME='%s'";
            sql = String.format(sql, onlineOrderId, "onlineOrderId");
            SQLQuery sqlQuery = session.createSQLQuery(sql);
            List list = sqlQuery.list();
            boolean bl = list.size() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTicketByReservationId(String reservationId) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)reservationId));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TYPE, (Object)TicketType.RESERVATION.getTypeNo()));
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                boolean bl = rowCount.intValue() > 0;
                return bl;
            }
        }
        catch (Exception e) {
            PosLog.error(this.getReferenceClass(), e);
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOnlineTickets(PaginatedTableModel tableModel) {
        Session session = null;
        try {
            session = this.createNewSession();
            String sql = "select TICKET_ID from TICKET_PROPERTIES where PROPERTY_VALUE='online' and PROPERTY_NAME='source'";
            SQLQuery sqlQuery = session.createSQLQuery(sql);
            List list = sqlQuery.list();
            ArrayList<Ticket> ticketList = new ArrayList<Ticket>();
            for (String ticketId : list) {
                if (ticketId == null) continue;
                Ticket ticket = this.get(ticketId);
                ticketList.add(ticket);
            }
            ArrayList<Ticket> arrayList = ticketList;
            return arrayList;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDriverOut(List<Ticket> tickets, List<User> drivers) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = TicketDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            for (Ticket ticket : tickets) {
                ticket.setStatus("Driving");
                ticket.addProperty("OUT_AT", DateUtil.getReportDate());
                User driver = ticket.getAssignedDriver();
                if (driver != null && !drivers.contains(driver)) {
                    drivers.add(driver);
                }
                this.saveOrUpdate(ticket, session);
            }
            transaction.commit();
            for (Ticket ticket : tickets) {
                CloudDataUploader.get().uploadToCloudIfOnlineOrder(ticket);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTicketForDeliveryDispath(PaginatedTableModel model, OrderType orderType, String customerId, Date startDate, Date endDate, boolean onlineOrderOnly, boolean isPickupOnly, boolean isDeliveryOnly, boolean filterUnassigned) {
        User user = Application.getCurrentUser();
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(this.getDefaultOrder());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (StringUtils.isNotEmpty((String)customerId)) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            }
            if (!user.canViewAllOpenTickets()) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if (startDate != null && endDate != null) {
                criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)startDate), (Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)endDate)));
            }
            if (isPickupOnly) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.TRUE));
            }
            if (isDeliveryOnly) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.FALSE));
            }
            if (filterUnassigned) {
                criteria.add(Restrictions.isNull((String)Ticket.PROP_ASSIGNED_DRIVER_ID));
            }
            int currentRowIndex = model.getCurrentRowIndex();
            criteria.setFirstResult(currentRowIndex);
            criteria.setMaxResults(model.getPageSize());
            List list = criteria.list();
            if (onlineOrderOnly) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Ticket ticket = (Ticket)iterator.next();
                    if (ticket.isSourceOnline()) continue;
                    iterator.remove();
                }
            }
            model.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void closeOrders(Ticket ... tickets) {
        Session session = TicketDAO.getInstance().createNewSession();
        Transaction transaction = null;
        if (tickets == null) {
            return;
        }
        try {
            transaction = session.beginTransaction();
            Date serverTimestamp = StoreDAO.getServerTimestamp();
            for (Ticket ticket : tickets) {
                ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                ticket.setClosed(true);
                ticket.setClosingDate(serverTimestamp);
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
            }
            transaction.commit();
            for (Ticket ticket : tickets) {
                CloudDataUploader.get().uploadToCloudIfOnlineOrder(ticket);
            }
        }
        catch (Exception e) {
            PosLog.error(OrderController.class, e);
            POSMessageDialog.showError(e.getMessage());
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findBarTabOpenTickets(OrderType orderType) {
        List list;
        ArrayList<String> barTabOrderTypes;
        Session session;
        block6: {
            Iterator<OrderType> iterator;
            session = null;
            try {
                barTabOrderTypes = new ArrayList<String>();
                List<OrderType> orderTypes = DataProvider.get().getOrderTypes();
                if (orderTypes != null) {
                    for (OrderType ot : orderTypes) {
                        if (!ot.isBarTab().booleanValue()) continue;
                        barTabOrderTypes.add(ot.getId());
                    }
                }
                if (barTabOrderTypes != null && !barTabOrderTypes.isEmpty()) break block6;
                iterator = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return iterator;
        }
        session = this.getSession();
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        User user = Application.getCurrentUser();
        if (user != null && !user.canViewAllOpenTickets()) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
        }
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)(orderType == null ? null : orderType.getId())));
        criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, barTabOrderTypes));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
        criteria.addOrder(this.getDefaultOrder());
        List list2 = list = criteria.list();
        this.closeSession(session);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findVoidTicketByDate(Date startDate, Date endDate, List terminalIdList, List<String> orderTypeIdList) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)true));
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)startDate));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CLOSING_DATE, (Object)endDate));
            if (!terminalIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)Ticket.PROP_TERMINAL_ID, (Collection)terminalIdList));
            }
            if (!orderTypeIdList.isEmpty()) {
                criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, orderTypeIdList));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public User findOwner(String ticketId) {
        if (ticketId == null) {
            return null;
        }
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)ticketId));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_OWNER_ID));
        criteria.setProjection((Projection)projectionList);
        if (criteria.list().isEmpty()) {
            return null;
        }
        User user = UserDAO.getInstance().get((String)criteria.list().get(0));
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket findByCustomerAndDeliveryDate(String customerId, Date deliveryDate) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            criteria.add(Restrictions.between((String)Ticket.PROP_DELIVERY_DATE, (Object)DateUtil.startOfDay(deliveryDate), (Object)DateUtil.endOfDay(deliveryDate)));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)false));
            List list = criteria.list();
            if (!list.isEmpty()) {
                Ticket ticket = (Ticket)list.get(0);
                return ticket;
            }
            Ticket ticket = null;
            return ticket;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveMergedTickets(List<Ticket> tickets, Ticket rootTicket) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            rootTicket.setShouldUpdateTableStatus(true);
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.deleteTickets(session, tickets, true);
            this.saveOrUpdate(rootTicket, session, true);
            tx.commit();
        }
        catch (Exception e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        this.closeSession(session);
    }

    public void saveOrUpdateTransferedTicketsList(List<Ticket> ticketsToDelete, List<Ticket> ticketsToUpdate) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            if (ticketsToDelete != null || ticketsToDelete.size() > 0) {
                this.deleteTickets(session, ticketsToDelete, true);
            }
            for (Ticket ticket : ticketsToUpdate) {
                this.saveOrUpdate(ticket, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void reversePayment(Ticket ticket, PosTransaction transaction, boolean forceVoid, boolean reverseGiftCardBalance) {
        String errorMessage = "Failed to reverse payment.";
        if (!forceVoid && transaction instanceof CreditCardTransaction) {
            CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
            try {
                cardProcessor.voidTransaction(transaction);
                if (!transaction.isVoided().booleanValue()) {
                    cardProcessor.refundTransaction(transaction, transaction.getAmount());
                    if (!transaction.isRefunded()) {
                        throw new PosException(errorMessage);
                    }
                }
                if (NumberUtil.isZero(ticket.getPaidAmount())) {
                    ticket.calculatePrice(true, false);
                }
            }
            catch (Exception e2) {
                try {
                    cardProcessor.refundTransaction(transaction, transaction.getAmount());
                    if (!transaction.isRefunded()) {
                        throw new PosException(errorMessage);
                    }
                }
                catch (Exception e3) {
                    throw new PosException(errorMessage);
                }
            }
            transaction.setVoided(true);
            double surchargeAmount = transaction.getSurchargeAmount();
            ticket.setTotalSurchargeAmount(ticket.getTotalSurchargeAmount() - surchargeAmount);
            Iterator<TicketItem> iterator = ticket.getTicketItems().iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = iterator.next();
                if (!ticketItem.getTransactionUUId().equals(transaction.getUUID())) continue;
                iterator.remove();
            }
            ticket.setPaidAmount(ticket.getPaidAmount() - transaction.getAmount());
            ticket.setDueAmount(ticket.getDueAmount() + transaction.getAmount());
            ticket.setClosed(false);
            ticket.setPaid(false);
            if (NumberUtil.isZero(ticket.getPaidAmount())) {
                ticket.calculatePrice(true, false);
            }
            Session session = null;
            Transaction tx = null;
            try {
                session = this.createNewSession();
                tx = session.beginTransaction();
                if (reverseGiftCardBalance) {
                    this.doReverseGiftCardBalance(ticket, transaction, session);
                }
                this.update(ticket, session);
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            finally {
                this.closeSession(session);
            }
        }
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            PaymentType paymentType = transaction.getPaymentType();
            PaymentPlugin paymentPlugin = paymentType.getPaymentPlugin();
            if (paymentPlugin != null) {
                paymentPlugin.voidPayment(transaction, session);
            }
            transaction.setVoided(true);
            ticket.setPaidAmount(ticket.getPaidAmount() - transaction.getAmount());
            ticket.setDueAmount(ticket.getDueAmount() + transaction.getAmount());
            ticket.setClosed(false);
            ticket.setPaid(false);
            if (NumberUtil.isZero(ticket.getPaidAmount())) {
                ticket.calculatePrice(true, false);
            }
            if (reverseGiftCardBalance) {
                this.doReverseGiftCardBalance(ticket, transaction, session);
            }
            this.update(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void doReverseGiftCardBalance(Ticket ticket, PosTransaction transaction, Session session) {
        String giftCardInfo = transaction.getGiftCardBalanceAddInfo();
        if (StringUtils.isEmpty((String)giftCardInfo)) {
            return;
        }
        JSONArray jsonArray = new JSONArray(giftCardInfo);
        for (Object object : jsonArray) {
            JSONObject jsonObject = (JSONObject)object;
            String ticketItemId = jsonObject.getString("ticketItemId");
            String giftCardNumber = jsonObject.getString("giftCardNo");
            double addedAmount = jsonObject.getDouble("addedAmount");
            GiftCard giftCard = GiftCardDAO.getInstance().findByCardNumber(session, giftCardNumber);
            if (giftCard != null) {
                giftCard.setBalance(giftCard.getBalance() - addedAmount);
                GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
            }
            List<TicketItem> ticketItems = ticket.getTicketItems();
            for (TicketItem ticketItem : ticketItems) {
                if (!ticketItem.getId().equals(ticketItemId)) continue;
                ticketItem.setGiftCardPaidAmount(0.0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTicketsForUser(User user, Date from, Date to, PaginatedTableModel listModel) {
        Session session = null;
        try {
            Number rowCount;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if (from != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)from), (Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)false)));
            }
            if (to != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)to));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                listModel.setNumRows(rowCount.intValue());
            } else {
                listModel.setNumRows(0);
            }
            criteria.setProjection(null);
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            criteria.addOrder(Order.desc((String)Ticket.PROP_CREATE_DATE));
            listModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    private boolean shouldUpdateStock(Ticket ticket) {
        if (ticket.isSourceOnline()) {
            return false;
        }
        if (ticket.isReservation()) {
            return true;
        }
        return ticket.isShouldUpdateStock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAllUnSyncTicket(StoreSession storeSession) {
        List list;
        block6: {
            Session session;
            block4: {
                List list2;
                block5: {
                    session = null;
                    try {
                        List<String> cashDrawerIds = CashDrawerDAO.getInstance().getCashDrawerIds(storeSession);
                        if (cashDrawerIds != null && !cashDrawerIds.isEmpty()) break block4;
                        list2 = null;
                        if (session == null) break block5;
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            this.closeSession(session);
                        }
                        throw throwable;
                    }
                    this.closeSession(session);
                }
                return list2;
            }
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Criterion nullUpdateTime = Restrictions.isNull((String)Ticket.PROP_LAST_UPDATE_TIME);
            Criterion nullSyncTime = Restrictions.isNull((String)Ticket.PROP_LAST_SYNC_TIME);
            PropertyExpression gtQuery = Restrictions.gtProperty((String)Ticket.PROP_LAST_UPDATE_TIME, (String)Ticket.PROP_LAST_SYNC_TIME);
            criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{nullUpdateTime, nullSyncTime, gtQuery}));
            list = criteria.list();
            if (session == null) break block6;
            this.closeSession(session);
        }
        return list;
    }

    public void updateTicketAndTicketItemSync(List<Ticket> ticketOrgin, boolean synced) {
        if (ticketOrgin != null) {
            for (Ticket ticket : ticketOrgin) {
                List<TicketItem> ticketItems;
                this.loadFullTicket(ticket);
                if (!ticket.isCloudSynced().booleanValue() && ticket.isClosed().booleanValue()) {
                    ticket.setCloudSynced(synced);
                    TicketDAO.getInstance().update(ticket);
                }
                if ((ticketItems = ticket.getTicketItems()) == null) continue;
                for (TicketItem ticketItem : ticketItems) {
                    if (ticketItem.isCloudSynced().booleanValue()) continue;
                    ticketItem.setCloudSynced(synced);
                    TicketItemDAO.getInstance().update(ticketItem);
                }
            }
        }
    }

    public void loadClosedTicket(PaginationSupport model, String txtNameOrId, Date fromDate, Date toDate) {
        this.loadClosedTicket(model, txtNameOrId, fromDate, toDate, null);
    }

    public void loadClosedTicket(PaginationSupport model, String txtNameOrId, Date fromDate, Date toDate, User user) {
        this.loadClosedTicket(model, txtNameOrId, fromDate, toDate, user, null);
    }

    public void loadClosedTicket(PaginationSupport model, String txtNameOrId, Date fromDate, Date toDate, User user, List<OrderType> orderTypes) {
        this.loadClosedTicket(model, txtNameOrId, txtNameOrId, fromDate, toDate, user, null, null);
    }

    public void loadClosedTicket(PaginationSupport model, String ticketId, String customerName, Date fromDate, Date toDate, User user, List<OrderType> orderTypes, List<TicketExplorer.SortData> sortDataList) {
        List<String> customerIdList = this.getCustomerIdList(customerName);
        List<String> orderTypeIdList = POSUtil.getStringIds(orderTypes, OrderType.class);
        try (Session session = this.createNewSession();){
            String as = " as ";
            String hqlCount = "select count(*) ";
            String hqlSelect = "select t." + Ticket.PROP_ID + as + Ticket.PROP_ID + ",t." + Ticket.PROP_ORDER_TYPE_ID + as + Ticket.PROP_ORDER_TYPE_ID + ",t." + Ticket.PROP_CREATE_DATE + as + Ticket.PROP_CREATE_DATE + ",t." + Ticket.PROP_CLOSING_DATE + as + Ticket.PROP_CLOSING_DATE + ", (select max(" + PosTransaction.PROP_TRANSACTION_TIME + ") from " + PosTransaction.REF + " where t." + Ticket.PROP_ID + " = " + PosTransaction.PROP_TICKET + " and " + PosTransaction.PROP_TRANSACTION_TYPE + " = 'DEBIT')" + as + "returnDate ,t." + Ticket.PROP_OWNER_ID + as + Ticket.PROP_OWNER_ID + ",t." + Ticket.PROP_CUSTOMER_ID + as + Ticket.PROP_CUSTOMER_ID + ",c." + Customer.PROP_NAME + as + "customerName,t." + Ticket.PROP_VOIDED + as + Ticket.PROP_VOIDED + ",t." + Ticket.PROP_CLOSED + as + Ticket.PROP_CLOSED + ",t." + Ticket.PROP_PAID + as + Ticket.PROP_PAID + ",t." + Ticket.PROP_SUBTOTAL_AMOUNT + as + Ticket.PROP_SUBTOTAL_AMOUNT + ",t." + Ticket.PROP_DISCOUNT_AMOUNT + as + Ticket.PROP_DISCOUNT_AMOUNT + ",t." + Ticket.PROP_TAX_AMOUNT + as + Ticket.PROP_TAX_AMOUNT + ",t." + Ticket.PROP_TOTAL_AMOUNT + as + Ticket.PROP_TOTAL_AMOUNT + ",t." + Ticket.PROP_PAID_AMOUNT + as + Ticket.PROP_PAID_AMOUNT;
            String hql = "%s from " + Ticket.REF + " as t left join " + Customer.REF + " as c on t." + Ticket.PROP_CUSTOMER_ID + " = c." + Customer.PROP_ID;
            hql = hql + " where ";
            if (StringUtils.isNotBlank((String)ticketId)) {
                hql = hql + " t." + Ticket.PROP_ID + " like :ticketId";
            } else {
                hql = hql + " t." + Ticket.PROP_CREATE_DATE + " between :fromDate and :toDate";
                if (customerIdList != null && customerIdList.size() > 0) {
                    hql = hql + " and t." + Ticket.PROP_CUSTOMER_ID + " in :customerIds ";
                }
                if (user != null) {
                    hql = hql + " and t." + Ticket.PROP_OWNER_ID + " = :ownerId";
                }
                if (!orderTypeIdList.isEmpty()) {
                    hql = hql + " and t." + Ticket.PROP_ORDER_TYPE_ID + " in :orderTypeIds";
                }
            }
            Query countQuery = this.createCommonQuery(ticketId, customerName, fromDate, toDate, user, customerIdList, orderTypeIdList, session, String.format(hql, hqlCount));
            Long longValue = (Long)countQuery.uniqueResult();
            model.setNumRows(longValue == null ? 0 : longValue.intValue());
            if (sortDataList != null) {
                for (TicketExplorer.SortData sortData : sortDataList) {
                    String columnName = sortData.getColumnName();
                    if (columnName.equals("customerName")) {
                        columnName = "c.name";
                    }
                    hql = hql + " order by ";
                    if (sortData.getSortOrder().equals(SortOrder.ASCENDING.name())) {
                        hql = hql + columnName + " asc ";
                        continue;
                    }
                    hql = hql + columnName + " desc ";
                }
            }
            Query query = this.createCommonQuery(ticketId, customerName, fromDate, toDate, user, customerIdList, orderTypeIdList, session, String.format(hql, hqlSelect));
            query.setResultTransformer(Transformers.aliasToBean(Ticket.class));
            query.setFirstResult(model.getCurrentRowIndex());
            query.setMaxResults(model.getPageSize());
            List results = query.list();
            model.setRows(results);
        }
    }

    private Query createCommonQuery(String ticketId, String customerName, Date fromDate, Date toDate, User user, List<String> customerIdList, List<String> orderTypeIdList, Session session, String hql) {
        Query query = session.createQuery(hql);
        if (StringUtils.isNotBlank((String)ticketId)) {
            query.setString("ticketId", ticketId + "%");
        } else {
            query.setTimestamp("fromDate", fromDate);
            query.setTimestamp("toDate", toDate);
            if (user != null) {
                query.setString("ownerId", user.getId());
            }
            if (customerIdList != null && customerIdList.size() > 0) {
                query.setParameterList("customerIds", customerIdList);
            }
            if (!orderTypeIdList.isEmpty()) {
                query.setParameterList("orderTypeIds", orderTypeIdList);
            }
        }
        return query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getCustomerIdList(String customerName) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Customer.class);
            List customerIds = null;
            if (StringUtils.isNotEmpty((String)customerName)) {
                criteria.setProjection((Projection)Projections.property((String)Customer.PROP_ID));
                criteria.add(Restrictions.ilike((String)Customer.PROP_NAME, (String)customerName, (MatchMode)MatchMode.ANYWHERE));
                customerIds = criteria.list();
            }
            List list = customerIds;
            return list;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
            return null;
        }
    }

    public List<Date> findTicketWithinDate(Date beginDate, Date currentDate, Session session) {
        try {
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add(Restrictions.between((String)Ticket.PROP_CREATE_DATE, (Object)DateUtil.startOfDay(beginDate), (Object)DateUtil.endOfDay(currentDate)));
            criteria.setProjection((Projection)Projections.property((String)Ticket.PROP_CREATE_DATE));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                return list;
            }
        }
        catch (Exception e0) {
            PosLog.error(this.getReferenceClass(), e0);
        }
        return null;
    }

    public List<DeliverySummaryReportData> findTicketsForDeliverySummaryReport(Date fromDate, Date toDate) {
        try (Session session = this.createNewSession();){
            String as = " as ";
            String hql = "select t." + Ticket.PROP_OWNER_ID + as + "employeeId" + ",t." + Ticket.PROP_CUSTOMER_ID + as + "customerId" + ",%s" + as + "customerName" + ",%s" + as + "memberId" + ",t." + Ticket.PROP_ID + as + "ticketId" + ",t." + Ticket.PROP_SUBTOTAL_AMOUNT + as + "netAmount" + ",t." + Ticket.PROP_TAX_AMOUNT + as + "taxAmount" + ",t." + Ticket.PROP_TOTAL_AMOUNT + as + "totalAmount" + ",t." + Ticket.PROP_SERVICE_CHARGE + as + "serviceCharge" + ",t." + Ticket.PROP_DISCOUNT_AMOUNT + as + "discount" + ",t." + Ticket.PROP_CREATE_DATE + as + "createdDate" + ",t." + Ticket.PROP_DELIVERY_DATE + as + "deliveryDate" + ",g." + Gratuity.PROP_AMOUNT + as + "gratuityAmount" + ",%s" + as + "cashPaymentCredit" + ",%s" + as + "creditCardPaymentCredit" + ",%s" + as + "memberChargeCredit" + ",%s" + as + "othersPaymentCredit" + ",%s" + as + "cashPaymentDebit" + ",%s" + as + "creditCardPaymentDebit" + ",%s" + as + "memberChargeDebit" + ",%s" + as + "othersPaymentDebit" + " from Ticket as t left outer join t.gratuity as g";
            String transSql = String.format("select sum(tr.%s) from PosTransaction as tr where t=tr.%s and tr.%s='%s' and tr.%s=%s", PosTransaction.PROP_AMOUNT, PosTransaction.PROP_TICKET, PosTransaction.PROP_TRANSACTION_TYPE, "%s", PosTransaction.PROP_VOIDED, false);
            String commonPaymentQuery = "(" + transSql + " and tr." + PosTransaction.PROP_PAYMENT_TYPE_STRING + "='%s')";
            String othersPaymentQuery = "(" + transSql + " and tr." + PosTransaction.PROP_PAYMENT_TYPE_STRING + " not in('%s','%s','%s'))";
            String customerQuery = "(select c.%s from Customer as c where t.%s=c.%s)";
            hql = String.format(hql, String.format(customerQuery, Customer.PROP_NAME, Ticket.PROP_CUSTOMER_ID, Customer.PROP_ID), String.format(customerQuery, Customer.PROP_MEMBER_ID, Ticket.PROP_CUSTOMER_ID, Customer.PROP_ID), String.format(commonPaymentQuery, TransactionType.CREDIT.name(), PaymentType.CASH.name()), String.format(commonPaymentQuery, TransactionType.CREDIT.name(), PaymentType.CREDIT_CARD.name()), String.format(commonPaymentQuery, TransactionType.CREDIT.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(othersPaymentQuery, TransactionType.CREDIT.name(), PaymentType.CASH.name(), PaymentType.CREDIT_CARD.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(commonPaymentQuery, TransactionType.DEBIT.name(), PaymentType.CASH.name()), String.format(commonPaymentQuery, TransactionType.DEBIT.name(), PaymentType.CREDIT_CARD.name()), String.format(commonPaymentQuery, TransactionType.DEBIT.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(othersPaymentQuery, TransactionType.DEBIT.name(), PaymentType.CASH.name(), PaymentType.CREDIT_CARD.name(), PaymentType.MEMBER_ACCOUNT.name()));
            hql = hql + " where t." + Ticket.PROP_DELIVERY_DATE + " between :fromDate and :toDate";
            hql = hql + " and t." + Ticket.PROP_VOIDED + " =:voided";
            hql = hql + " order by t." + Ticket.PROP_OWNER_ID + " asc";
            Query query = session.createQuery(hql);
            query.setTimestamp("fromDate", fromDate);
            query.setTimestamp("toDate", toDate);
            query.setBoolean("voided", Boolean.FALSE.booleanValue());
            query.setResultTransformer(Transformers.aliasToBean(DeliverySummaryReportData.class));
            List list = query.list();
            return list;
        }
    }

    @Deprecated
    public List<EndOfDayReportData> findTicketsGroupedByEmployee(Date fromDate, Date toDate, List<OrderType> orderTypes) {
        try (Session session = this.createNewSession();){
            String as = " as ";
            String hql = "select t." + Ticket.PROP_OWNER_ID + as + "employeeId" + ",t." + Ticket.PROP_CUSTOMER_ID + as + "customerId" + ",%s" + as + "customerName" + ",%s" + as + "memberId" + ",t." + Ticket.PROP_ID + as + "ticketId" + ",t." + Ticket.PROP_SUBTOTAL_AMOUNT + as + "netAmount" + ",t." + Ticket.PROP_TAX_AMOUNT + as + "taxAmount" + ",t." + Ticket.PROP_TOTAL_AMOUNT + as + "totalTicketAmount" + ",t." + Ticket.PROP_SERVICE_CHARGE + as + "serviceCharge" + ",t." + Ticket.PROP_DISCOUNT_AMOUNT + as + "discount" + ",g." + Gratuity.PROP_AMOUNT + as + "gratuityAmount" + ",%s" + as + "cashPaymentCredit" + ",%s" + as + "creditCardPaymentCredit" + ",%s" + as + "memberChargeCredit" + ",%s" + as + "othersPaymentCredit" + ",%s" + as + "cashPaymentDebit" + ",%s" + as + "creditCardPaymentDebit" + ",%s" + as + "memberChargeDebit" + ",%s" + as + "othersPaymentDebit" + " from Ticket as t left outer join t.gratuity as g";
            String transSql = String.format("select sum(tr.%s) from PosTransaction as tr where t=tr.%s and tr.%s='%s' and tr.%s=%s", PosTransaction.PROP_AMOUNT, PosTransaction.PROP_TICKET, PosTransaction.PROP_TRANSACTION_TYPE, "%s", PosTransaction.PROP_VOIDED, false);
            String commonPaymentQuery = "(" + transSql + " and tr." + PosTransaction.PROP_PAYMENT_TYPE_STRING + "='%s')";
            String othersPaymentQuery = "(" + transSql + " and tr." + PosTransaction.PROP_PAYMENT_TYPE_STRING + " not in('%s','%s','%s'))";
            String customerQuery = "(select c.%s from Customer as c where t.%s=c.%s)";
            hql = String.format(hql, String.format(customerQuery, Customer.PROP_NAME, Ticket.PROP_CUSTOMER_ID, Customer.PROP_ID), String.format(customerQuery, Customer.PROP_MEMBER_ID, Ticket.PROP_CUSTOMER_ID, Customer.PROP_ID), String.format(commonPaymentQuery, TransactionType.CREDIT.name(), PaymentType.CASH.name()), String.format(commonPaymentQuery, TransactionType.CREDIT.name(), PaymentType.CREDIT_CARD.name()), String.format(commonPaymentQuery, TransactionType.CREDIT.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(othersPaymentQuery, TransactionType.CREDIT.name(), PaymentType.CASH.name(), PaymentType.CREDIT_CARD.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(commonPaymentQuery, TransactionType.DEBIT.name(), PaymentType.CASH.name()), String.format(commonPaymentQuery, TransactionType.DEBIT.name(), PaymentType.CREDIT_CARD.name()), String.format(commonPaymentQuery, TransactionType.DEBIT.name(), PaymentType.MEMBER_ACCOUNT.name()), String.format(othersPaymentQuery, TransactionType.DEBIT.name(), PaymentType.CASH.name(), PaymentType.CREDIT_CARD.name(), PaymentType.MEMBER_ACCOUNT.name()));
            hql = hql + " where t." + Ticket.PROP_CREATE_DATE + " >= :fromDate and t." + Ticket.PROP_CREATE_DATE + " < :toDate";
            if (orderTypes != null) {
                String whereCondition = "(";
                Iterator<OrderType> iterator = orderTypes.iterator();
                while (iterator.hasNext()) {
                    OrderType orderType = iterator.next();
                    whereCondition = whereCondition + "'" + orderType.getId() + "'";
                    if (!iterator.hasNext()) continue;
                    whereCondition = whereCondition + ",";
                }
                whereCondition = whereCondition + ")";
                hql = hql + " and t." + Ticket.PROP_ORDER_TYPE_ID + " in " + whereCondition;
            }
            hql = hql + " and t." + Ticket.PROP_VOIDED + " =:voided";
            hql = hql + " order by t." + Ticket.PROP_OWNER_ID + " asc";
            Query query = session.createQuery(hql);
            query.setTimestamp("fromDate", DateUtil.toUTC(fromDate));
            query.setTimestamp("toDate", DateUtil.toUTC(toDate));
            query.setBoolean("voided", Boolean.FALSE.booleanValue());
            query.setResultTransformer(Transformers.aliasToBean(EndOfDayReportData.class));
            List list = query.list();
            return list;
        }
    }

    public List<Ticket> findTicketsByCustomer(String customerId) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)customerId));
            List list = criteria.list();
            return list;
        }
    }
}

