/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.BaseUserTypeDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class UserTypeDAO
extends BaseUserTypeDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void delete(Object obj, Session session) {
        UserType userType = (UserType)obj;
        if (userType == null) {
            throw new PosException(Messages.getString("UserTypeDAO.0"));
        }
        this.ensureUserTypeNotInUse(session, userType);
        userType.setDeleted(true);
        this.update(userType, session);
    }

    private void ensureUserTypeNotInUse(Session session, UserType userType) {
        Criteria criteria = session.createCriteria(User.class);
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)User.PROP_USER_TYPE_ID, (Object)userType.getId()));
        List users = criteria.list();
        if (users != null && users.size() > 0) {
            throw new PosException(Messages.getString("UserTypeDAO.1"));
        }
    }

    @Override
    public List<UserType> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)UserType.PROP_NAME));
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserType> findAllUnSyncUserType() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression falseCriteria = Restrictions.eq((String)UserType.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion nullCriteria = Restrictions.isNull((String)UserType.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)falseCriteria, (Criterion)nullCriteria));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void saveOrUpdateUserTypes(List<UserType> userTypes, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (userTypes == null) {
            return;
        }
        for (UserType userType : userTypes) {
            UserType existingUserType = this.get(userType.getId());
            if (existingUserType != null) {
                if (!BaseDataServiceDao.get().shouldSave(userType.getLastUpdateTime(), existingUserType.getLastUpdateTime())) {
                    PosLog.info(this.getClass(), userType.getName() + " already updated");
                    continue;
                }
                String id = existingUserType.getId();
                long version = existingUserType.getVersion();
                PropertyUtils.copyProperties((Object)existingUserType, (Object)userType);
                existingUserType.setId(id);
                existingUserType.setVersion(version);
                existingUserType.setUpdateLastUpdateTime(updateLastUpdateTime);
                existingUserType.setUpdateSyncTime(updateSyncTime);
                this.update(existingUserType);
                continue;
            }
            userType.setUpdateLastUpdateTime(updateLastUpdateTime);
            userType.setUpdateSyncTime(updateSyncTime);
            this.save(userType);
        }
    }
}

