/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Database;
import com.floreantpos.config.AppConfig;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosDataInterceptor;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao._BaseRootDAO;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.service.ServiceRegistry;

public abstract class _RootDAO
extends _BaseRootDAO {
    private static StandardServiceRegistry standardServiceRegistry;

    public static void initialize() {
        Database database = AppConfig.getDefaultDatabase();
        String connectString = AppConfig.getConnectString();
        String databaseUser = AppConfig.getDatabaseUser();
        String databasePassword = AppConfig.getDatabasePassword();
        _RootDAO.initialize("oropos.hibernate.cfg.xml", database, connectString, databaseUser, databasePassword);
    }

    public static void initialize(String hibernanetCfgFile) {
        Database database = AppConfig.getDefaultDatabase();
        String connectString = AppConfig.getConnectString();
        String databaseUser = AppConfig.getDatabaseUser();
        String databasePassword = AppConfig.getDatabasePassword();
        _RootDAO.initialize(hibernanetCfgFile, database, connectString, databaseUser, databasePassword);
    }

    public static void initialize(String hibernanetCfgFile, Database database, String connectString, String databaseUser, String databasePassword) {
        _RootDAO.initialize(hibernanetCfgFile, database.getHibernateDialect(), database.getHibernateConnectionDriverClass(), connectString, databaseUser, databasePassword);
    }

    public static void initialize(String hibernanetCfgFile, String hibernateDialectClass, String driverClass, String connectString, String databaseUser, String databasePassword) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hibernate.dialect", hibernateDialectClass);
        map.put("hibernate.connection.driver_class", driverClass);
        map.put("hibernate.connection.url", connectString);
        map.put("hibernate.connection.username", databaseUser);
        map.put("hibernate.connection.password", databasePassword);
        map.put("hibernate.connection.autocommit", "false");
        map.put("hibernate.max_fetch_depth", "3");
        map.put("hibernate.show_sql", "false");
        map.put("hibernate.connection.isolation", String.valueOf(1));
        map.put("hibernate.cache.use_second_level_cache", "false");
        map.put("hibernate.cache.provider_class", "org.hibernate.cache.EhCacheProvider");
        map.put("hibernate.cache.region.factory_class", "org.hibernate.cache.ehcache.SingletonEhCacheRegionFactory");
        _RootDAO.initialize(hibernanetCfgFile, map);
    }

    public static void initialize(Map<String, String> properties) {
        _RootDAO.initialize("oropos.hibernate.cfg.xml", properties);
    }

    public static void initialize(String hibernanetCfgFile, Map<String, String> properties) {
        _RootDAO.releaseConnection();
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
        URL resource = _RootDAO.class.getResource("/" + hibernanetCfgFile);
        registryBuilder.configure(resource);
        registryBuilder.applySettings(properties);
        _RootDAO.setupCconnectionPoolSettings(registryBuilder);
        standardServiceRegistry = registryBuilder.build();
        Metadata metaData = new MetadataSources((ServiceRegistry)standardServiceRegistry).getMetadataBuilder().build();
        SessionFactoryBuilder sessionFactoryBuilder = metaData.getSessionFactoryBuilder();
        _RootDAO.setSessionFactory(sessionFactoryBuilder.applyInterceptor((Interceptor)new PosDataInterceptor()).build());
    }

    public static void setupCconnectionPoolSettings(StandardServiceRegistryBuilder builder) {
        builder.applySetting("hibernate.c3p0.min_size", (Object)"0");
        builder.applySetting("hibernate.c3p0.max_size", (Object)"5");
        builder.applySetting("hibernate.c3p0.timeout", (Object)"300");
        builder.applySetting("hibernate.c3p0.max_statements", (Object)"0");
        builder.applySetting("hibernate.c3p0.checkoutTimeout", (Object)"15000");
        builder.applySetting("hibernate.c3p0.acquireRetryAttempts", (Object)"1");
        builder.applySetting("hibernate.c3p0.acquireRetryDelay", (Object)"100");
        builder.applySetting("hibernate.c3p0.acquireIncrement", (Object)"1");
        builder.applySetting("testConnectionOnCheckout", (Object)"true");
        builder.applySetting("hibernate.c3p0.breakAfterAcquireFailure", (Object)"false");
    }

    public static void setupHikariCPSettings(StandardServiceRegistryBuilder builder) {
        builder.applySetting("hibernate.connection.provider_class", (Object)"org.hibernate.hikaricp.internal.HikariCPConnectionProvider");
        builder.applySetting("hibernate.hikari.idleTimeout", (Object)"30000");
        builder.applySetting("hibernate.hikari.minimumIdle", (Object)"0");
        builder.applySetting("hibernate.hikari.maximumPoolSize", (Object)"5");
    }

    public static void initialize(String configFileName, Configuration configuration) {
        _RootDAO.releaseConnection();
        _RootDAO.initialize();
    }

    public static void releaseConnection() {
        _RootDAO.closeCurrentThreadSessions();
        if (sessionFactory != null && !sessionFactory.isClosed()) {
            sessionFactory.close();
        }
        if (standardServiceRegistry != null) {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardServiceRegistry);
        }
    }

    public void refresh(Object obj) {
        try (Session session = this.createNewSession();){
            super.refresh(obj, session);
        }
    }

    public int rowCount() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            int n = ((Long)criteria.uniqueResult()).intValue();
            return n;
        }
    }

    public int rowCount(Criteria criteria) {
        criteria.setProjection(Projections.rowCount());
        int intValue = ((Long)criteria.uniqueResult()).intValue();
        criteria.setProjection(null);
        return intValue;
    }

    public List getPageData(int pageNum, int pageSize) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(pageNum * pageSize);
            criteria.setMaxResults(pageSize);
            List list = criteria.list();
            return list;
        }
    }

    public int rowCount(Map<String, Object> restrictions) {
        try (Session session = this.createNewSession();){
            Number result;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (restrictions != null) {
                for (String key : restrictions.keySet()) {
                    criteria.add((Criterion)Restrictions.eq((String)key, (Object)restrictions.get(key)));
                }
            }
            if ((result = (Number)criteria.uniqueResult()) != null) {
                int n = result.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    public List getPageData(int pageNum, int pageSize, Map<String, Object> restrictions) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(pageNum * pageSize);
            criteria.setMaxResults(pageSize);
            if (restrictions != null) {
                for (String key : restrictions.keySet()) {
                    criteria.add((Criterion)Restrictions.eq((String)key, (Object)restrictions.get(key)));
                }
            }
            List list = criteria.list();
            return list;
        }
    }

    protected void updateTime(Object model) {
        if (!(model instanceof TimedModel)) {
            return;
        }
        TimedModel timedModel = (TimedModel)model;
        Date now = StoreDAO.getServerTimestamp();
        if (timedModel.isUpdateLastUpdateTime()) {
            timedModel.setLastUpdateTime(now);
        }
        if (timedModel.isUpdateSyncTime()) {
            timedModel.setLastSyncTime(now);
        }
    }

    private boolean containsDeletedField(Class modelClass) {
        try {
            if (modelClass == null) {
                modelClass = this.getReferenceClass();
            }
            return Arrays.stream(modelClass.getFields()).anyMatch(f -> f.getName().equalsIgnoreCase("PROP_DELETED"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addDeletedFilter(Criteria criteria) {
        Class<?> modelClass = null;
        try {
            CriteriaImpl criteriaImpl;
            String className;
            if (criteria instanceof CriteriaImpl && StringUtils.isNotBlank((String)(className = (criteriaImpl = (CriteriaImpl)criteria).getEntityOrClassName()))) {
                modelClass = Class.forName(className);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addDeletedFilter(criteria, modelClass);
    }

    public void addDeletedFilter(Criteria criteria, Class modelClass) {
        if (this.containsDeletedField(modelClass)) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        }
    }

    public static void addUserWithAllRoleCriteria(Criteria criteria, User user, String fieldName) {
        if (user != null) {
            criteria.add(Restrictions.in((String)fieldName, user.getRoleIds()));
        }
    }
}

