/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class DateUtil {
    private static final SimpleDateFormat dateFormat1 = new SimpleDateFormat("hh:mm a");
    private static final SimpleDateFormat giftCardDateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private static final DateFormat localeFormat = DateFormat.getDateInstance(3);
    private static SimpleDateFormat monthDateFormat = new SimpleDateFormat("MMM dd");

    public static String formatDateAsLocale(Date date) {
        String dateString = localeFormat.format(date);
        return dateString;
    }

    public static String formatReportDateAsString(Date date) {
        return DateUtil.formatDateWithTime(date);
    }

    public static String formatDateAsString(Date date) {
        return DateUtil.formatDateWithTime(date);
    }

    public static String formatDateAsUTCString(Date date) {
        String format = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format + " hh:mm a");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(date);
    }

    public static Date parseByFullDate(String date) throws Exception {
        return DateUtil.formatDateWithTimeAndSec(date);
    }

    public static String formatFullDateAsString(Date date) {
        return DateUtil.formatDate(date);
    }

    public static Date parseBySortDate(String date) throws Exception {
        return DateUtil.parseDate(date);
    }

    public static Date startOfDay(Date date) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        ZonedDateTime startOfDay = dateTime.toLocalDate().atStartOfDay(ZoneId.systemDefault());
        return Date.from(startOfDay.toInstant());
    }

    public static Date startOfNextDay(Date date) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        dateTime = dateTime.plusDays(1L);
        ZonedDateTime startOfDay = dateTime.toLocalDate().atStartOfDay(ZoneId.systemDefault());
        return Date.from(startOfDay.toInstant());
    }

    public static Date endOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date == null ? new Date() : date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return new Date(cal.getTimeInMillis());
    }

    public static Date startOfDayInUTC(Date date) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        ZonedDateTime startOfDay = dateTime.toLocalDate().atStartOfDay(ZoneId.of("UTC"));
        return Date.from(startOfDay.toInstant());
    }

    public static Date endOfDayInUTC(Date date) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        ZonedDateTime atStartOfDay = dateTime.toLocalDate().atStartOfDay(ZoneId.of("UTC"));
        ZonedDateTime enDateTime = atStartOfDay.plusDays(1L);
        return Date.from(enDateTime.toInstant());
    }

    public static Date toUTC(Date date) {
        int rawOffset = TimeZone.getDefault().getRawOffset();
        return new Date(date.getTime() - (long)rawOffset);
    }

    public static Date startOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(5, 1);
        return new Date(cal.getTimeInMillis());
    }

    public static Date endOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(5, cal.getActualMaximum(5));
        return new Date(cal.getTimeInMillis());
    }

    public static Date copyTime(Date copyTo, Date copyFrom) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(copyFrom);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        calendar.setTime(copyTo);
        calendar.set(11, hour);
        calendar.set(12, min);
        return calendar.getTime();
    }

    public static boolean between(Date startDate, Date endDate, Date guniping) {
        if (startDate == null || endDate == null) {
            return false;
        }
        return startDate.compareTo(guniping) * guniping.compareTo(endDate) >= 0;
    }

    public static String formatSmall(Date date) {
        return DateUtil.formatDate(date);
    }

    public static String getReportDate() {
        return DateUtil.formatDateWithTimeAndSec(new Date());
    }

    public static boolean isToday(Date date) {
        return DateUtil.isSameDay(date, Calendar.getInstance().getTime());
    }

    public static boolean isToday(Calendar cal) {
        return DateUtil.isSameDay(cal, Calendar.getInstance());
    }

    public static String formatAsTodayDate(Date date) {
        String dateString = dateFormat1.format(date);
        return Messages.getString("DateUtil.2") + " " + dateString;
    }

    public static String formatFullDateAndTimeAsString(Date date) {
        String dateString = date == null ? "" : DateUtil.formatDateWithTimeAndSec(date);
        return dateString;
    }

    public static String formatFullDateAndTimeWithoutYearAsString(Date date) {
        return DateUtil.formatDateWithTimeAndSec(date);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtil.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static String getOnlyFormattedTime(Date date) {
        String dateString = dateFormat1.format(date);
        return dateString;
    }

    public static String getOnlyFormattedDate(Date date) {
        return DateUtil.formatDateWithTime(date);
    }

    public static String getElapsedTime(Date oldTime, Date newTime) {
        DateTime startDate = new DateTime((Object)oldTime);
        DateTime endDate = new DateTime((Object)newTime);
        if (oldTime.after(newTime)) {
            startDate = new DateTime((Object)newTime);
            endDate = new DateTime((Object)oldTime);
        }
        Interval interval = new Interval((ReadableInstant)startDate, (ReadableInstant)endDate);
        long days = interval.toDuration().getStandardDays();
        long hours = interval.toDuration().getStandardHours();
        long minutes = interval.toDuration().getStandardMinutes();
        long seconds = interval.toDuration().getStandardSeconds();
        String strDays = days + "d, ";
        String strHours = (hours %= 24L) + "hr, ";
        String strMins = (minutes %= 60L) + "mn";
        String strSec = (seconds %= 60L) + "secs";
        String strAgo = "";
        String fullTime = strDays + strHours + strMins + strAgo;
        String timeWithoutDay = strHours + strMins + strAgo;
        String timeWithoutHour = strMins + strAgo;
        String timeWithoutMin = strSec + strAgo;
        if (days != 0L) {
            return fullTime;
        }
        if (hours != 0L) {
            return timeWithoutDay;
        }
        if (minutes != 0L) {
            return timeWithoutHour;
        }
        if (seconds != 0L) {
            return timeWithoutMin;
        }
        return "not printed yet";
    }

    public static Calendar getLocalTimeCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar getServerTimeCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(StoreDAO.getServerTimestamp());
        return calendar;
    }

    public static Date getGmtTime() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime();
    }

    public static Calendar getGmtCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    public static String getStoreDateFormat() {
        Store store = DataProvider.get().getStore();
        return store.getDateFormat();
    }

    public static SimpleDateFormat getSimpleDateFormat() {
        Store store = DataProvider.get().getStore();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(store == null ? "dd-MMM-yy" : store.getDateFormat());
        return simpleDateFormat;
    }

    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = DateUtil.getSimpleDateFormat();
        return simpleDateFormat.format(date);
    }

    public static Date parseDate(String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = DateUtil.getSimpleDateFormat();
        return simpleDateFormat.parse(date);
    }

    public static String parseStringDateToString(String inputFormat, String date) throws Exception {
        String outputFormat = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateOutputFormat = new SimpleDateFormat(outputFormat);
        SimpleDateFormat simpleDateInputFormat = new SimpleDateFormat(inputFormat);
        Date parseDate = simpleDateInputFormat.parse(date);
        return simpleDateOutputFormat.format(parseDate);
    }

    public static String formatDateWithTime(Date date) {
        String format = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format + " hh:mm a");
        return simpleDateFormat.format(date);
    }

    public static String formatReportDate(Date date) {
        String format = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format + " hh:mm a z");
        return simpleDateFormat.format(date);
    }

    public static String tweentyFourHoursDateFormat(Date date) {
        return new SimpleDateFormat(DateUtil.getStoreDateFormat() + " HH:mm", Locale.UK).format(date);
    }

    public static Date formatDateWithTime(String date) throws ParseException {
        String format = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format + " hh:mm a");
        return simpleDateFormat.parse(date);
    }

    public static String formatDateWithTimeAndSec(Date date) {
        String format = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format + " hh:mm:ss a");
        return simpleDateFormat.format(date);
    }

    public static Date formatDateWithTimeAndSec(String date) throws ParseException {
        String format = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format + " hh:mm:ss a");
        return simpleDateFormat.parse(date);
    }

    public static Date formatDateWithDefaultTimeAndSec(String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy hh:mm:ss a");
        return simpleDateFormat.parse(date);
    }

    public static String formatDateWithDefaultTimeAndSec(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy hh:mm:ss a");
        return simpleDateFormat.format(date);
    }

    public static String formatAsDefaultMonthDate(Date date) {
        return monthDateFormat.format(date);
    }

    public static String formatAsGiftCardDateFormat(Date date) {
        return giftCardDateFormat.format(date);
    }

    public static Date parseByGiftCardDateFormat(String dateAsString) throws ParseException {
        return giftCardDateFormat.parse(dateAsString);
    }

    public static String formatDateWithBrowserTimeOffset(Date date, int timezoneOffset) {
        String format = DataProvider.get().getStore().getDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format + " hh:mm:ss a");
        if (timezoneOffset == 0) {
            return simpleDateFormat.format(date);
        }
        String[] availableIDs = TimeZone.getAvailableIDs(timezoneOffset);
        String timezone = null;
        if (availableIDs.length > 0) {
            timezone = availableIDs[0];
        }
        if (StringUtils.isNotEmpty(timezone)) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timezone));
        }
        return simpleDateFormat.format(date);
    }

    public static Date formatDateWithBrowserTimeOffset(String date, int timezoneOffset) {
        try {
            String format = DataProvider.get().getStore().getDateFormat();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format + " hh:mm:ss a");
            if (timezoneOffset == 0) {
                return simpleDateFormat.parse(date);
            }
            String[] availableIDs = TimeZone.getAvailableIDs(timezoneOffset);
            String timezone = null;
            if (availableIDs.length > 0) {
                timezone = availableIDs[0];
            }
            if (StringUtils.isNotEmpty(timezone)) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timezone));
            }
            return simpleDateFormat.parse(date);
        }
        catch (Exception e) {
            PosLog.error(DateUtil.class, e);
            return null;
        }
    }

    public static String formatDateWithBrowserTimeOffsetWithoutSec(Date date, int timezoneOffset) {
        String format = DataProvider.get().getStore().getDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        if (timezoneOffset == 0) {
            return simpleDateFormat.format(date);
        }
        String[] availableIDs = TimeZone.getAvailableIDs(timezoneOffset);
        String timezone = null;
        if (availableIDs.length > 0) {
            timezone = availableIDs[0];
        }
        if (StringUtils.isNotEmpty(timezone)) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timezone));
        }
        return simpleDateFormat.format(date);
    }

    public static String format(String pattern, Date date) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static void validateDate(Date fromDate, Date toDate) {
        if (fromDate == null) {
            throw new PosException(POSConstants.FROM_DATE_IS_NULL);
        }
        if (toDate == null) {
            throw new PosException(POSConstants.TO_DATE_IS_NULL);
        }
        if (fromDate.after(toDate)) {
            throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
        }
    }

    public static String formatTimeAsUTC(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(date);
    }

    public static Date parseTimeAsUTC(String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date parse = simpleDateFormat.parse(date);
        return parse;
    }

    public static SimpleDateFormat getSimpleDateFormatWithTime() {
        String format = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format + " hh:mm:ss a");
        return simpleDateFormat;
    }

    public static Date createDate(int hour, int amPm) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        instance.set(10, hour);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(9, amPm);
        return instance.getTime();
    }
}

